/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.rtsj.framework.ethernet;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import org.eclipse.umlgen.rtsj.framework.ArgsBuffer;
import org.eclipse.umlgen.rtsj.framework.CommunicationLayer;

public class EthernetComServer
extends Thread {
    private Socket socket;
    private BufferedInputStream inputBuffer;
    private CommunicationLayer communicationLayer;
    ArgsBuffer header = new ArgsBuffer(100);
    ArgsBuffer params = new ArgsBuffer(800);
    StringBuffer identSb = new StringBuffer(50);
    StringBuffer serviceSb = new StringBuffer(50);

    public EthernetComServer(Socket socket, CommunicationLayer communicationLayer) {
        this.socket = socket;
        this.communicationLayer = communicationLayer;
        try {
            this.inputBuffer = new BufferedInputStream(socket.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    int headerSize = this.inputBuffer.read();
                    int i = 0;
                    while (i < headerSize) {
                        this.header.writeByte((byte)this.inputBuffer.read());
                        ++i;
                    }
                    this.header.readString(this.identSb);
                    this.header.readString(this.serviceSb);
                    int priority = this.header.readInteger();
                    int paramSize = this.header.readInteger();
                    int i2 = 0;
                    while (i2 < paramSize) {
                        this.params.writeByte((byte)this.inputBuffer.read());
                        ++i2;
                    }
                    if (this.communicationLayer.isSynchronousCall(this.identSb.toString())) {
                        this.communicationLayer.callAsynchronous(this.serviceSb.toString(), this.identSb.toString(), "", this.params, priority);
                    }
                    if (!this.communicationLayer.isSendEventData(this.identSb.toString())) continue;
                    this.communicationLayer.sendEventData(this.serviceSb.toString(), this.identSb.toString(), "", this.params);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
                continue;
            }
            break;
        }
    }
}

