/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.c.common.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.umlgen.c.common.Activator;

public final class PreferenceStoreManager {
    private static final String SEPARATOR = "::";
    private static final String LOGICAL_VIEW = "Logical View";

    private PreferenceStoreManager() {
    }

    public static void setDefaultValues(IProject project) {
        IPreferenceStore store = PreferenceStoreManager.getPreferenceStore(project);
        IFolder modelFolder = project.getFolder("Models");
        IFile modelFile = modelFolder.getFile(project.getFullPath().addFileExtension("uml"));
        URI uri = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
        store.setDefault("UMLModelPath", uri.toString());
        String srcQualifiedName = String.valueOf(project.getName()) + SEPARATOR + LOGICAL_VIEW + SEPARATOR + "Source Artefacts";
        store.setDefault("srcPackageName", srcQualifiedName);
        String typeQualifiedName = String.valueOf(project.getName()) + SEPARATOR + LOGICAL_VIEW + SEPARATOR + "Types";
        store.setDefault("typePackageName", typeQualifiedName);
        String extQualifiedName = String.valueOf(project.getName()) + SEPARATOR + LOGICAL_VIEW + SEPARATOR + "Libs";
        store.setDefault("extPackageName", extQualifiedName);
    }

    public static void setInitialValues(IProject project) {
        IPreferenceStore store = PreferenceStoreManager.getPreferenceStore(project);
        IFolder modelFolder = project.getFolder("Models");
        IFile modelFile = modelFolder.getFile(project.getFullPath().addFileExtension("uml"));
        URI uri = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
        store.setValue("UMLModelPath", uri.toString());
        String srcQualifiedName = String.valueOf(project.getName()) + SEPARATOR + LOGICAL_VIEW + SEPARATOR + "Source Artefacts";
        store.setValue("srcPackageName", srcQualifiedName);
        String typeQualifiedName = String.valueOf(project.getName()) + SEPARATOR + LOGICAL_VIEW + SEPARATOR + "Types";
        store.setValue("typePackageName", typeQualifiedName);
        String extQualifiedName = String.valueOf(project.getName()) + SEPARATOR + LOGICAL_VIEW + SEPARATOR + "Libs";
        store.setValue("extPackageName", extQualifiedName);
    }

    public static IPreferenceStore getPreferenceStore(IProject project) {
        ScopedPreferenceStore store = project != null ? new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), Activator.getBundleId()) : new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.getBundleId());
        return store;
    }
}

