/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.ui.internal.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.umlgen.c.common.interactions.SynchronizersManager;
import org.eclipse.umlgen.c.common.interactions.extension.IModelSynchronizer;
import org.eclipse.umlgen.c.common.ui.PreferenceStoreManager;
import org.eclipse.umlgen.gen.c.builder.UML2CBuilder;
import org.eclipse.umlgen.reverse.c.StructuralBuilder;
import org.eclipse.umlgen.reverse.c.resource.C2UMLSyncNature;
import org.eclipse.umlgen.reverse.c.resource.ProjectUtil;
import org.eclipse.umlgen.reverse.c.ui.internal.bundle.Messages;
import org.eclipse.umlgen.reverse.c.ui.internal.widgets.QuestionDialog;

public class AddC2UMLSyncNature
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            IProject project = (IProject)selection.getFirstElement();
            IPreferenceStore store = PreferenceStoreManager.getPreferenceStore((IProject)project);
            QuestionDialog dialog = new QuestionDialog(Display.getCurrent().getActiveShell(), Messages.getString("AddC2UMLSyncNature.dialogTitle"), Messages.getString("AddC2UMLSyncNature.dialogBody"), store);
            int result = dialog.open();
            if (result > -1) {
                IModelSynchronizer synchronizer = SynchronizersManager.getSynchronizer();
                if (synchronizer != null) {
                    synchronizer.setInitialValues(project);
                }
                if (result == 0) {
                    this.syncFromSources(project);
                } else if (result == 1) {
                    this.syncFromModel(project);
                }
            }
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void syncFromModel(IProject project) throws CoreException {
        IFile modelFile = C2UMLSyncNature.selectExistingUMLModel((IProject)project);
        if (modelFile != null) {
            ProjectUtil.addNature((IProject)project, (String)"org.eclipse.umlgen.reverse.c.syncNature");
            ProjectUtil.addNature((IProject)project, (String)"org.eclipse.umlgen.gen.c.nature");
            UML2CBuilder builder = new UML2CBuilder();
            builder.build((IResource)modelFile);
        }
    }

    private void syncFromSources(IProject project) throws CoreException {
        ProjectUtil.addNature((IProject)project, (String)"org.eclipse.umlgen.reverse.c.syncNature");
        ProjectUtil.addNature((IProject)project, (String)"org.eclipse.umlgen.gen.c.nature");
        IFile modelFile = null;
        IModelSynchronizer synchronizer = SynchronizersManager.getSynchronizer();
        if (synchronizer != null) {
            modelFile = synchronizer.createModel(project);
        }
        if (modelFile != null && modelFile.exists()) {
            ProjectUtil.removeFromBuildSpec((IProject)project, (String)"org.eclipse.umlgen.gen.c.builder");
            StructuralBuilder sb = new StructuralBuilder((IResource)modelFile);
            sb.build();
            sb.dispose();
            ProjectUtil.addToBuildSpec((IProject)project, (String)"org.eclipse.umlgen.gen.c.builder");
        }
    }
}

