/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.c.modeler.interactions.templates;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.umlgen.c.modeler.interactions.Activator;
import org.eclipse.umlgen.c.modeler.interactions.templates.AbstractExtensionManager;
import org.eclipse.umlgen.c.modeler.interactions.templates.TemplateDescriptor;

public final class TemplatesManager
extends AbstractExtensionManager {
    private static final String TEMPLATES_EXTENSION_POINT = "templates";
    private static TemplatesManager manager;
    private SortedSet<TemplateDescriptor> templates = new TreeSet<TemplateDescriptor>(new Comparator<TemplateDescriptor>(){

        @Override
        public int compare(TemplateDescriptor o1, TemplateDescriptor o2) {
            String id1 = o1.getId();
            String id2 = o2.getId();
            return id1.compareTo(id2);
        }
    });

    private TemplatesManager() {
        super(String.valueOf(Activator.getId()) + "." + TEMPLATES_EXTENSION_POINT);
        this.readRegistry();
    }

    public static TemplatesManager getInstance() {
        if (manager == null) {
            manager = new TemplatesManager();
        }
        return manager;
    }

    public TemplateDescriptor find(String id) {
        for (TemplateDescriptor desc : this.templates) {
            if (!id.equals(desc.getId())) continue;
            return desc;
        }
        return null;
    }

    public TemplateDescriptor[] getTemplates() {
        return this.templates.toArray(new TemplateDescriptor[this.templates.size()]);
    }

    protected void addExtension(IExtension extension) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement confElt = iConfigurationElementArray[n2];
            try {
                if ("template".equals(confElt.getName())) {
                    TemplateDescriptor descriptor = new TemplateDescriptor(confElt);
                    this.templates.add(descriptor);
                }
            }
            catch (CoreException ce) {
                Activator.log(ce);
            }
            ++n2;
        }
    }

    protected void removeExtension(IExtension extension) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement confElt = iConfigurationElementArray[n2];
            if ("template".equals(confElt.getName())) {
                String id = confElt.getAttribute("id");
                TemplateDescriptor descriptor = this.find(id);
                this.templates.remove(descriptor);
            }
            ++n2;
        }
    }
}

