/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.embedded.c.ui.launch;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.umlgen.gen.embedded.c.main.Uml2ec;
import org.eclipse.umlgen.gen.embedded.c.services.ConfigurationHolder;
import org.eclipse.umlgen.gen.embedded.c.ui.UML2ECUIActivator;
import org.eclipse.umlgen.gen.embedded.c.ui.common.ConfigurationServices;

public class UML2ECLaunchDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String umlModelPath = "";
        Path outputFolderPath = null;
        try {
            umlModelPath = configuration.getAttribute("uml_model_path", "");
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(configuration.getAttribute("output_folder_path", "")));
            outputFolderPath = new Path(folder.getRawLocation().toString());
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.umlgen.gen.embedded.c.ui", e.getMessage(), (Throwable)e);
            UML2ECUIActivator.getDefault().getLog().log((IStatus)status);
        }
        if (umlModelPath == null || umlModelPath.length() == 0) {
            return;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(umlModelPath));
        IWorkspaceRoot container = ResourcesPlugin.getWorkspace().getRoot();
        if (file != null && container != null && file.isAccessible() && container.isAccessible()) {
            URI modelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            ConfigurationHolder configurationHolder = ConfigurationServices.createConfigurationHolder(configuration);
            try {
                Uml2ec generator = new Uml2ec(modelURI, outputFolderPath.toFile(), new ArrayList());
                generator.setConfigurationHolder(configurationHolder);
                generator.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
                container.refreshLocal(2, monitor);
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.umlgen.gen.embedded.c.ui", e.getMessage(), (Throwable)e);
                UML2ECUIActivator.getDefault().getLog().log((IStatus)status);
            }
        }
    }
}

