/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.activity;

import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityFinalNode;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InitialNode;
import org.eclipse.umlgen.reverse.c.activity.beans.ActivityContext;
import org.eclipse.umlgen.reverse.c.activity.beans.ActivityNodesPins;
import org.eclipse.umlgen.reverse.c.activity.beans.CommentInfo;
import org.eclipse.umlgen.reverse.c.activity.beans.LoopStatementWrapper;
import org.eclipse.umlgen.reverse.c.activity.builder.CommonStatementBuilder;
import org.eclipse.umlgen.reverse.c.activity.builder.CompoundStatementBuilder;
import org.eclipse.umlgen.reverse.c.activity.builder.FlowControlStatementBuilder;
import org.eclipse.umlgen.reverse.c.activity.builder.IfStatementBuilder;
import org.eclipse.umlgen.reverse.c.activity.builder.LabelStatementBuilder;
import org.eclipse.umlgen.reverse.c.activity.builder.LoopStatementBuilder;
import org.eclipse.umlgen.reverse.c.activity.builder.SwitchStatementBuilder;
import org.eclipse.umlgen.reverse.c.activity.comments.CommentBuilder;
import org.eclipse.umlgen.reverse.c.activity.comments.CommentsReconciler;
import org.eclipse.umlgen.reverse.c.activity.util.UMLActivityFactory;
import org.eclipse.umlgen.reverse.c.activity.util.UMLActivitySanitizer;

public class UMLActivityBuilder {
    Map<IASTNode, CommentInfo> nodesAndComments;
    private UMLActivityFactory factory = new UMLActivityFactory();
    private SwitchStatementBuilder switchStmtBuilder;
    private CompoundStatementBuilder compoundStmtBuilder;
    private IfStatementBuilder ifStmtBuilder;
    private LoopStatementBuilder loopStmtBuilder;
    private CommonStatementBuilder commonStmtBuilder;
    private LabelStatementBuilder labelStmtBuilder;
    private FlowControlStatementBuilder flowControlStmtBuilder;
    private UMLActivitySanitizer sanitizer;
    private CommentsReconciler commentsReconciler;
    private CommentBuilder commentBuilder = new CommentBuilder(this.factory);

    public UMLActivityBuilder() {
        this.switchStmtBuilder = new SwitchStatementBuilder(this, this.factory, this.commentBuilder);
        this.compoundStmtBuilder = new CompoundStatementBuilder(this, this.factory, this.commentBuilder);
        this.ifStmtBuilder = new IfStatementBuilder(this, this.factory, this.commentBuilder);
        this.loopStmtBuilder = new LoopStatementBuilder(this, this.factory, this.commentBuilder);
        this.commonStmtBuilder = new CommonStatementBuilder(this, this.factory, this.commentBuilder);
        this.labelStmtBuilder = new LabelStatementBuilder(this, this.factory, this.commentBuilder);
        this.flowControlStmtBuilder = new FlowControlStatementBuilder(this, this.factory, this.commentBuilder);
        this.sanitizer = new UMLActivitySanitizer();
        this.commentsReconciler = new CommentsReconciler();
    }

    public static Activity build(IASTFunctionDefinition functionDefinition) {
        return new UMLActivityBuilder().createActivity(functionDefinition);
    }

    private Activity createActivity(IASTFunctionDefinition functionDefinition) {
        this.initComments(functionDefinition);
        String functionName = functionDefinition.getDeclarator().getName().toString();
        Activity activity = this.factory.createActivity(functionName);
        ActivityContext currentContext = new ActivityContext(activity);
        IASTStatement body = functionDefinition.getBody();
        ActivityNodesPins bodyNodes = this.buildNodes(body, currentContext);
        InitialNode initialNode = this.factory.createInitialNode(currentContext);
        ActivityFinalNode finalNode = null;
        if (bodyNodes.getStartNode() == null && bodyNodes.getEndNode() == null) {
            finalNode = this.factory.createActivityFinalNode(currentContext);
            this.factory.createControlFlow((ActivityNode)initialNode, (ActivityNode)finalNode, currentContext);
        } else {
            this.factory.createControlFlow((ActivityNode)initialNode, bodyNodes.getStartNode(), currentContext);
            if (!(bodyNodes.getEndNode() instanceof ActivityFinalNode)) {
                finalNode = this.factory.createActivityFinalNode(currentContext);
                this.factory.addFlowTowardsActivityFinalNode(bodyNodes.getEndNode(), (ActivityNode)finalNode, currentContext);
            } else {
                finalNode = (ActivityFinalNode)bodyNodes.getEndNode();
            }
        }
        this.commentBuilder.buildComment((Element)finalNode, this.nodesAndComments.remove(functionDefinition.getBody()));
        this.sanitizer.sanitize(activity);
        return activity;
    }

    private void initComments(IASTFunctionDefinition functionDefinition) {
        this.nodesAndComments = this.commentsReconciler.reconcile(functionDefinition);
        this.switchStmtBuilder.setStatementsAndComments(this.nodesAndComments);
        this.compoundStmtBuilder.setStatementsAndComments(this.nodesAndComments);
        this.ifStmtBuilder.setStatementsAndComments(this.nodesAndComments);
        this.loopStmtBuilder.setStatementsAndComments(this.nodesAndComments);
        this.commonStmtBuilder.setStatementsAndComments(this.nodesAndComments);
        this.labelStmtBuilder.setStatementsAndComments(this.nodesAndComments);
        this.flowControlStmtBuilder.setStatementsAndComments(this.nodesAndComments);
    }

    public ActivityNodesPins buildNodes(IASTStatement stmt, ActivityContext currentContext) {
        if (stmt instanceof IASTSwitchStatement) {
            return this.switchStmtBuilder.buildSwitchStatement((IASTSwitchStatement)stmt, currentContext);
        }
        if (stmt instanceof IASTForStatement || stmt instanceof IASTWhileStatement || stmt instanceof IASTDoStatement) {
            return this.loopStmtBuilder.buildLoopStatement(new LoopStatementWrapper(stmt), currentContext);
        }
        if (stmt instanceof IASTIfStatement) {
            return this.ifStmtBuilder.buildIfStatement((IASTIfStatement)stmt, currentContext);
        }
        if (stmt instanceof IASTCompoundStatement) {
            return this.compoundStmtBuilder.buildCompoundStatement((IASTCompoundStatement)stmt, currentContext);
        }
        if (stmt instanceof IASTCaseStatement) {
            return this.switchStmtBuilder.buildCaseStatement((IASTCaseStatement)stmt, currentContext);
        }
        if (stmt instanceof IASTDefaultStatement) {
            return this.switchStmtBuilder.buildDefaultStatement((IASTDefaultStatement)stmt, currentContext);
        }
        if (stmt instanceof IASTLabelStatement) {
            return this.labelStmtBuilder.buildLabelStatement((IASTLabelStatement)stmt, currentContext);
        }
        if (stmt instanceof IASTContinueStatement) {
            return this.flowControlStmtBuilder.buildContinueStatement((IASTContinueStatement)stmt, currentContext);
        }
        if (stmt instanceof IASTBreakStatement) {
            return this.flowControlStmtBuilder.buildBreakStatement((IASTBreakStatement)stmt, currentContext);
        }
        if (stmt instanceof IASTReturnStatement) {
            return this.flowControlStmtBuilder.buildReturnStatement((IASTReturnStatement)stmt, currentContext);
        }
        return this.commonStmtBuilder.buildCommonStatement(stmt, currentContext);
    }
}

