/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.java.diagram;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.uml.diagram.wizards.category.NewPapyrusModelCommand;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.umlgen.reverse.java.AbstractJava2UMLConverter;
import org.eclipse.umlgen.reverse.java.diagram.PrototypeJava2UMLConverter;
import org.eclipse.umlgen.reverse.java.diagram.diagram.ActivityDiagramUtils;
import org.eclipse.umlgen.reverse.java.diagram.diagram.ClassDiagramUtils;
import org.eclipse.umlgen.reverse.java.internal.ReversePlugin;
import org.eclipse.umlgen.reverse.java.internal.wizards.Java2UMLWizard;
import org.eclipse.umlgen.reverse.java.logging.LogUtils;

public class PrototypeJava2UMLWizard
extends Java2UMLWizard {
    private ModelSet resourceSet;

    protected void doFinish(String containerName, String fileName, String[] importList, IProgressMonitor monitor, String modelName, VisibilityKind visibility, AbstractJava2UMLConverter.ActivityGeneration activityGen) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        IFile file = container.getFile((IPath)new Path(fileName));
        if (this.javaElement == null) {
            this.throwCoreException("No java element selected.");
        }
        this.resourceSet = new ModelSet();
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        Resource emfResource = this.resourceSet.createResource(fileURI);
        URI tmpFileURI = URI.createPlatformResourceURI((String)(String.valueOf(file.getFullPath().toString()) + "_mergetemp_"), (boolean)false);
        this.resourceSet.createResource(tmpFileURI);
        if (file.exists()) {
            try {
                emfResource.load(new HashMap());
            }
            catch (IOException e) {
                Status status = new Status(4, ReversePlugin.getId(), 0, "An error occured during loading resource", (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        Model oldModel = null;
        EList contentsList = emfResource.getContents();
        for (EObject content : contentsList) {
            if (!(content instanceof Model)) continue;
            oldModel = (Model)content;
        }
        if (oldModel != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ErrorDialog errorDialog = new ErrorDialog(PrototypeJava2UMLWizard.this.getShell(), "Warning", "Warning message", (IStatus)new Status(4, ReversePlugin.getId(), "A model already exists, this one will be deleted"), 4);
                    errorDialog.open();
                }
            });
            emfResource.getContents().clear();
        }
        PrototypeJava2UMLConverter converter = new PrototypeJava2UMLConverter();
        converter.setImportList(importList);
        converter.setModelName(modelName);
        converter.setVisibility(visibility);
        converter.convert(this.javaElement, emfResource, activityGen);
        HashMap options = new HashMap();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        try {
            LogUtils.logMessage((String)("Saving .uml resource: " + dateFormat.format(Calendar.getInstance().getTime())));
            emfResource.save(options);
            LogUtils.logMessage((String)("Finished saving .uml resource: " + dateFormat.format(Calendar.getInstance().getTime())));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            Status status = new Status(4, ReversePlugin.getId(), 0, "An error occured while saving resource", (Throwable)ioe);
            throw new CoreException((IStatus)status);
        }
        try {
            final ServicesRegistry registry = this.createServicesRegistry();
            if (registry == null) {
                return;
            }
            final ModelSet modelSet = (ModelSet)registry.getService(ModelSet.class);
            for (final EObject contents : emfResource.getContents()) {
                if (!(contents instanceof Model)) continue;
                NewPapyrusModelCommand command = new NewPapyrusModelCommand(modelSet, fileURI);
                modelSet.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
                AbstractTransactionalCommand papModelsCommand = new AbstractTransactionalCommand(modelSet.getTransactionalEditingDomain(), "Create Diagram and save resources", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        NotationUtils.getNotationModel((ModelSet)modelSet).getResource();
                        SashModelUtils.getSashModel((ModelSet)modelSet).getResource();
                        try {
                            registry.startRegistry();
                            registry.getService(IPageManager.class);
                        }
                        catch (ServiceException e) {
                            e.printStackTrace();
                            LogUtils.logThrowable((Throwable)e);
                        }
                        LogUtils.logMessage((String)"Creating class diagrams");
                        ClassDiagramUtils.INSTANCE.createDiagrams((Package)contents, modelSet, true);
                        LogUtils.logMessage((String)"Creating activity diagrams");
                        ActivityDiagramUtils.INSTANCE.createDiagrams((Package)contents, modelSet, false);
                        try {
                            LogUtils.logMessage((String)"Saving .notation resource");
                            NotationUtils.getNotationModel((ModelSet)modelSet).getResource().save(null);
                            LogUtils.logMessage((String)"Finished saving .notation resource");
                            String uri = NotationUtils.getNotationModel((ModelSet)modelSet).getResource().getURI().toPlatformString(false).replace(".notation", ".di");
                            Resource res = SashModelUtils.getSashModel((ModelSet)modelSet).getResource();
                            res.setURI(URI.createPlatformResourceURI((String)uri, (boolean)false));
                            LogUtils.logMessage((String)"Saving .di resource");
                            res.save(null);
                            LogUtils.logMessage((String)"Finished saving .di resource");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            LogUtils.logThrowable((Throwable)e);
                        }
                        return CommandResult.newOKCommandResult();
                    }
                };
                modelSet.getTransactionalEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)papModelsCommand));
            }
        }
        catch (ServiceException e1) {
            e1.printStackTrace();
            LogUtils.logThrowable((Throwable)e1);
        }
        this.javaElement.getResource().refreshLocal(1, null);
    }

    protected ServicesRegistry createServicesRegistry() {
        ExtensionServicesRegistry result = null;
        try {
            result = new ExtensionServicesRegistry("org.eclipse.papyrus.infra.core");
        }
        catch (ServiceException serviceException) {}
        try {
            result.startServicesByClassKeys(new Class[]{ModelSet.class});
        }
        catch (ServiceException serviceException) {}
        return result;
    }
}

