/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.java.diagram.diagram;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.umlgen.reverse.java.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDiagramUtils {
    protected Map<Diagram, Set<Relationship>> relationships;

    public Set<Diagram> createDiagrams(final Package contents, final ModelSet resourceSet, final boolean openAutomatically) {
        this.init();
        final HashSet<Diagram> diagrams = new HashSet<Diagram>();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                diagrams.addAll(AbstractDiagramUtils.this.specificDiagramCreation(contents, resourceSet));
                try {
                    resourceSet.save((IProgressMonitor)new NullProgressMonitor());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (Diagram diagram : diagrams) {
                    AbstractDiagramUtils.this.addDiagram(diagram, openAutomatically);
                }
            }
        });
        return diagrams;
    }

    protected abstract Set<Diagram> specificDiagramCreation(Package var1, ModelSet var2);

    protected void init() {
        this.relationships = new HashMap<Diagram, Set<Relationship>>();
    }

    protected void addDiagramToResource(final ModelSet modelSet, final Diagram diagram) {
        AbstractTransactionalCommand addDiagramCommand = new AbstractTransactionalCommand(modelSet.getTransactionalEditingDomain(), "Add diagram", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                NotationUtils.getNotationModel((ModelSet)modelSet).getResource().getContents().add((Object)diagram);
                return CommandResult.newOKCommandResult();
            }
        };
        modelSet.getTransactionalEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)addDiagramCommand));
    }

    protected Node addNode(ModelSet modelSet, View diagram, EObject client, String semanticHint, PreferencesHint preferencesHint) {
        AddNodeCommand addNodeCommand = new AddNodeCommand(modelSet, diagram, client, semanticHint, preferencesHint);
        modelSet.getTransactionalEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)addNodeCommand));
        return addNodeCommand.getNode();
    }

    protected Edge addEdge(ModelSet modelSet, IAdaptable semanticAdapter, Diagram diagram, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        AddEdgeCommand addEdgeActivityCommand = new AddEdgeCommand(modelSet, semanticAdapter, diagram, semanticHint, index, persisted, preferencesHint);
        modelSet.getTransactionalEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)addEdgeActivityCommand));
        return addEdgeActivityCommand.getEdge();
    }

    private void addDiagram(Diagram diagram, boolean openAutomatically) {
        try {
            IPageManager pageManager = ServiceUtilsForEObject.getInstance().getIPageManager((Object)diagram);
            if (openAutomatically && diagram.getPersistedChildren() != null && !diagram.getPersistedChildren().isEmpty()) {
                pageManager.openPage((Object)diagram);
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
            LogUtils.logThrowable((Throwable)e);
        }
    }

    protected void setEdgeInfo(ModelSet modelSet, final Edge edge, final View source, final View target, final EObject element) {
        AbstractTransactionalCommand setResourceCommand = new AbstractTransactionalCommand(modelSet.getTransactionalEditingDomain(), "Set Edge Info", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                edge.setSource(source);
                edge.setTarget(target);
                edge.setElement(element);
                return CommandResult.newOKCommandResult();
            }
        };
        modelSet.getTransactionalEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)setResourceCommand));
    }

    protected class AddEdgeCommand
    extends AbstractTransactionalCommand {
        private Edge edge;
        private IAdaptable adapter;
        private Diagram diagram;
        private String semanticHint;
        private int index;
        private boolean persisted;
        private PreferencesHint preferencesHint;

        public AddEdgeCommand(ModelSet modelSet, IAdaptable adapter, Diagram diagram, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
            super(modelSet.getTransactionalEditingDomain(), "Add Edge", null);
            this.adapter = adapter;
            this.diagram = diagram;
            this.semanticHint = semanticHint;
            this.index = index;
            this.persisted = persisted;
            this.preferencesHint = preferencesHint;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Edge edgeView = ViewService.getInstance().createEdge(this.adapter, (View)this.diagram, this.semanticHint, this.index, this.persisted, this.preferencesHint);
            if (edgeView instanceof Edge) {
                this.edge = edgeView;
                return CommandResult.newOKCommandResult();
            }
            return CommandResult.newErrorCommandResult((String)("Creation of edge " + this.semanticHint + " returned non-Edge object"));
        }

        public Edge getEdge() {
            return this.edge;
        }
    }

    protected class AddNodeCommand
    extends AbstractTransactionalCommand {
        private Node node;
        private View diagram;
        private String semanticHint;
        private EObject client;
        private PreferencesHint preferencesHint;

        public AddNodeCommand(ModelSet modelSet, View diagram, EObject client, String semanticHint, PreferencesHint preferencesHint) {
            super(modelSet.getTransactionalEditingDomain(), "Add Node", null);
            this.diagram = diagram;
            this.client = client;
            this.semanticHint = semanticHint;
            this.preferencesHint = preferencesHint;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.node = ViewService.createNode((View)this.diagram, (EObject)this.client, (String)this.semanticHint, (PreferencesHint)this.preferencesHint);
            if (this.node instanceof Node) {
                return CommandResult.newOKCommandResult();
            }
            return CommandResult.newErrorCommandResult((String)("Creation of edge " + this.semanticHint + " returned non-Edge object"));
        }

        public Node getNode() {
            return this.node;
        }
    }
}

