/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.java.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.umlgen.reverse.java.AbstractJava2UMLConverter;

public class Java2UMLWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private Text modelText;
    private ISelection selection;
    private org.eclipse.swt.widgets.List listModelImports;
    private List<String> automaticListModelImports;
    private Combo restrictVisCombo;
    private Button buttonadd;
    private Button buttondel;
    private Button buttonclear;
    private Button noActivityRadio;
    private Button annotatedActivityRadio;
    private Button allActivityRadio;
    private Combo loggingLevelChoice;

    public Java2UMLWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("UML Model File");
        this.setDescription("This wizard creates a new file with *.uml extension from a Java Reverse Engineering process.");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Container:");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = false;
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Java2UMLWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Java2UMLWizardPage.this.handleBrowse();
            }
        });
        Label fileNameLabel = new Label(container, 0);
        fileNameLabel.setText("&File name:");
        this.fileText = new Text(container, 2052);
        GridData gd1 = new GridData(768);
        gd1.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gd1);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Java2UMLWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("&Model name:");
        this.modelText = new Text(container, 2052);
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 2;
        this.modelText.setLayoutData((Object)gd2);
        this.modelText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Java2UMLWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("&Limit Visibility:");
        this.restrictVisCombo = new Combo(container, 2060);
        this.restrictVisCombo.add(VisibilityKind.PUBLIC_LITERAL.getLiteral());
        this.restrictVisCombo.add(VisibilityKind.PACKAGE_LITERAL.getLiteral());
        this.restrictVisCombo.add(VisibilityKind.PROTECTED_LITERAL.getLiteral());
        this.restrictVisCombo.add(VisibilityKind.PRIVATE_LITERAL.getLiteral());
        this.restrictVisCombo.select(3);
        gd = new GridData(768);
        this.restrictVisCombo.setLayoutData((Object)gd);
        this.restrictVisCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Java2UMLWizardPage.this.dialogChanged();
            }
        });
        new Label(container, 0);
        Label lblLoggingLevel = new Label(container, 0);
        lblLoggingLevel.setText("Logging level:");
        this.loggingLevelChoice = new Combo(container, 8);
        this.loggingLevelChoice.setItems(new String[]{"debug", "info", "error"});
        this.loggingLevelChoice.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.loggingLevelChoice.select(1);
        new Label(container, 0);
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 3;
        GridData gridData5 = new GridData();
        gridData5.grabExcessVerticalSpace = true;
        gridData5.grabExcessHorizontalSpace = true;
        gridData5.verticalSpan = 20;
        gridData5.horizontalAlignment = 4;
        gridData5.verticalAlignment = 4;
        gridData5.horizontalSpan = 10;
        Group groupModel = new Group(container, 0);
        groupModel.setText("Model imports");
        groupModel.setLayoutData((Object)gridData5);
        groupModel.setLayout((Layout)gridLayout1);
        GridData gridData7 = new GridData();
        gridData7.grabExcessHorizontalSpace = true;
        gridData7.grabExcessVerticalSpace = true;
        gridData7.verticalSpan = 20;
        gridData7.horizontalAlignment = 4;
        gridData7.verticalAlignment = 4;
        gridData7.horizontalSpan = 10;
        this.listModelImports = new org.eclipse.swt.widgets.List((Composite)groupModel, 2050);
        this.listModelImports.setLayoutData((Object)gridData7);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.justify = false;
        rowLayout.pack = false;
        rowLayout.fill = false;
        GridData gridData10 = new GridData();
        gridData10.horizontalAlignment = 4;
        gridData10.horizontalSpan = 2;
        Composite compositebtn = new Composite((Composite)groupModel, 0);
        compositebtn.setLayoutData((Object)gridData10);
        compositebtn.setLayout((Layout)rowLayout);
        this.buttonadd = new Button(compositebtn, 0);
        this.buttonadd.setText("add");
        this.buttonadd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Java2UMLWizardPage.this.handleAddImport();
            }
        });
        this.buttondel = new Button(compositebtn, 0);
        this.buttondel.setText("del");
        this.buttondel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] selection2;
                String[] stringArray = selection2 = Java2UMLWizardPage.this.listModelImports.getSelection();
                int n = selection2.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    Java2UMLWizardPage.this.listModelImports.remove(string);
                    ++n2;
                }
            }
        });
        this.buttonclear = new Button(compositebtn, 0);
        this.buttonclear.setText("clear");
        new Label((Composite)groupModel, 0);
        this.buttonclear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Java2UMLWizardPage.this.listModelImports.setItems(new String[0]);
            }
        });
        Group groupModel1 = new Group(container, 0);
        groupModel1.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        groupModel1.setText("Activity generation");
        groupModel1.setLayout((Layout)new GridLayout(3, false));
        this.noActivityRadio = new Button((Composite)groupModel1, 16);
        this.noActivityRadio.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.noActivityRadio.setBounds(0, 0, 90, 16);
        this.noActivityRadio.setText("None");
        this.noActivityRadio.setSelection(true);
        this.annotatedActivityRadio = new Button((Composite)groupModel1, 16);
        this.annotatedActivityRadio.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.annotatedActivityRadio.setBounds(0, 0, 90, 16);
        this.annotatedActivityRadio.setText("Annotated Only");
        this.annotatedActivityRadio.setEnabled(false);
        this.annotatedActivityRadio.setSelection(false);
        this.allActivityRadio = new Button((Composite)groupModel1, 16);
        this.allActivityRadio.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.allActivityRadio.setBounds(0, 0, 90, 16);
        this.allActivityRadio.setText("All");
        this.allActivityRadio.setSelection(false);
        new Label(container, 0);
        new Label(container, 0);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                String name = container.getFullPath().toString();
                this.containerText.setText(name);
                name = container.getName();
                this.modelText.setText(name);
                this.fileText.setText(String.valueOf(name) + ".uml");
            }
        }
    }

    private void handleAddImport() {
        IWorkspaceRoot cont = ResourcesPlugin.getWorkspace().getRoot();
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)cont, "select Model to Import");
        if (dialog.open() == 0) {
            Object[] obj = dialog.getResult();
            if (obj == null || obj.length < 1) {
                return;
            }
            Object[] objectArray = obj;
            int n = obj.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IResource) {
                    String filename = ((IResource)object).getFullPath().toString();
                    this.listModelImports.add(filename);
                }
                ++n2;
            }
        }
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("File container must exist");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !"uml".equalsIgnoreCase(ext = fileName.substring(dotLoc + 1))) {
            this.updateStatus("File extension must be \"uml\"");
            return;
        }
        this.calculateModelImports(container, fileName, this.getModelName());
        this.updateStatus(null);
    }

    private void calculateModelImports(IResource resource, String fileName, String modelName) {
        if (this.automaticListModelImports == null) {
            this.automaticListModelImports = new ArrayList<String>();
        }
        for (String string : this.automaticListModelImports) {
            this.listModelImports.remove(string);
        }
        this.automaticListModelImports.clear();
    }

    private void updateModelImports(Model model) {
        if (model.getPackageImports() != null) {
            for (PackageImport pImport : model.getPackageImports()) {
                Model otherModel = pImport.getImportedPackage().getModel();
                if (otherModel == null || model.eResource().equals(otherModel.eResource())) continue;
                String platformString = otherModel.eResource().getURI().toPlatformString(true);
                this.automaticListModelImports.add(platformString);
                this.listModelImports.add(platformString);
            }
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String[] getImportList() {
        return this.listModelImports.getItems();
    }

    public VisibilityKind getVisibilityKind() {
        switch (this.restrictVisCombo.getSelectionIndex()) {
            case 1: {
                return VisibilityKind.PACKAGE_LITERAL;
            }
            case 2: {
                return VisibilityKind.PROTECTED_LITERAL;
            }
            case 3: {
                return VisibilityKind.PRIVATE_LITERAL;
            }
        }
        return VisibilityKind.PUBLIC_LITERAL;
    }

    public String getModelName() {
        return this.modelText.getText();
    }

    public AbstractJava2UMLConverter.ActivityGeneration getActivityGeneration() {
        if (this.allActivityRadio.getSelection()) {
            return AbstractJava2UMLConverter.ActivityGeneration.ALL;
        }
        if (this.noActivityRadio.getSelection()) {
            return AbstractJava2UMLConverter.ActivityGeneration.NONE;
        }
        if (this.annotatedActivityRadio.getSelection()) {
            return AbstractJava2UMLConverter.ActivityGeneration.ANNOTATED;
        }
        return null;
    }

    public void setActivityGen(AbstractJava2UMLConverter.ActivityGeneration activityGen) {
        switch (activityGen) {
            case ALL: {
                this.allActivityRadio.setSelection(true);
                return;
            }
            case ANNOTATED: {
                this.annotatedActivityRadio.setSelection(true);
                return;
            }
            case NONE: {
                this.noActivityRadio.setSelection(true);
                return;
            }
        }
    }

    public int getLoggingLevel() {
        switch (this.loggingLevelChoice.getSelectionIndex()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
        }
        return 1;
    }
}

