/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.java.logging;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.umlgen.reverse.java.internal.ReversePlugin;

public class LogUtils {
    private static ILog logger = ReversePlugin.getDefault().getLog();
    private static String tabbedSpace = "";
    private static String tabIncrement = "   ";
    private static int logLevel = 1;

    public static void resetTabbing() {
        tabbedSpace = "";
    }

    public static void incrementTabbing() {
        tabbedSpace = String.valueOf(tabbedSpace) + tabIncrement;
    }

    private static void decreaseTabbing() {
        if (tabbedSpace.length() >= tabIncrement.length()) {
            tabbedSpace = tabbedSpace.substring(tabIncrement.length());
        }
    }

    public static String getFullName(Object object) {
        if (object instanceof IJavaElement) {
            return "Java " + LogUtils.getTypeName(object) + " " + ((IJavaElement)object).getElementName();
        }
        if (object instanceof Element) {
            String umlName = LogUtils.getUMLName((Element)object);
            return "UML " + object.getClass().getSimpleName() + " " + umlName;
        }
        if (object instanceof ASTNode) {
            return "AST " + LogUtils.getTypeName(object) + " " + LogUtils.getAstName((ASTNode)object);
        }
        return null;
    }

    private static Package getClassPackage(Class clazz) {
        Element parent = clazz.getOwner();
        while (parent != null && !(parent instanceof Package)) {
            parent = parent.getOwner();
        }
        return (Package)parent;
    }

    private static Element getFirstClassOrPackageOwner(Element el) {
        Element parent = el.getOwner();
        while (parent != null && !(parent instanceof Package) && !(parent instanceof Class)) {
            parent = parent.getOwner();
        }
        return parent;
    }

    public static void logDiffMergeAnnotation(EModelElement diff, boolean isAdd) {
        if (diff instanceof Element) {
            StringBuffer msgBuffer = new StringBuffer(tabbedSpace);
            msgBuffer.append(LogUtils.getFullName(diff));
            msgBuffer.append(" is ");
            msgBuffer.append(isAdd ? "added " : "deleted ");
            Element el = LogUtils.getFirstClassOrPackageOwner((Element)diff);
            if (el != null) {
                msgBuffer.append("within ");
                msgBuffer.append(LogUtils.getFullName(el));
                if (el instanceof Class) {
                    Package pack = LogUtils.getClassPackage((Class)el);
                    msgBuffer.append("in " + LogUtils.getFullName(pack));
                }
            }
            LogUtils.doLog(1, msgBuffer.toString());
        }
    }

    public static void logCreation(Object sourceContainer, Object source, Object createdElement, String comment) {
        StringBuffer msgBuffer = new StringBuffer();
        if (source != null && createdElement != null) {
            String sourceName = LogUtils.getFullName(source);
            String createdFullName = LogUtils.getFullName(createdElement);
            if (sourceName != null && createdFullName != null) {
                String containerName;
                msgBuffer.append(String.valueOf(tabbedSpace) + sourceName);
                if (sourceContainer != null && (containerName = LogUtils.getFullName(sourceContainer)) != null) {
                    msgBuffer.append(" within " + containerName);
                }
                msgBuffer.append(" was translated as " + createdFullName);
                if (comment != null) {
                    msgBuffer.append(": " + comment);
                }
                LogUtils.doLog(1, msgBuffer.toString());
                return;
            }
        } else if (createdElement != null) {
            String containerName;
            String sourceName = LogUtils.getFullName(createdElement);
            msgBuffer.append(String.valueOf(tabbedSpace) + sourceName + " was created");
            if (sourceContainer != null && (containerName = LogUtils.getFullName(sourceContainer)) != null) {
                msgBuffer.append(" within " + containerName);
            }
            if (comment != null) {
                msgBuffer.append(": " + comment);
            }
            LogUtils.doLog(1, msgBuffer.toString());
            return;
        }
    }

    public static void logEntering(Object object, String comment) {
        StringBuffer msgBuffer = new StringBuffer();
        if (object != null) {
            String fullName = LogUtils.getFullName(object);
            if (fullName != null) {
                msgBuffer.append(String.valueOf(tabbedSpace) + "Entering " + fullName);
                if (comment != null) {
                    msgBuffer.append(": " + comment);
                }
                LogUtils.doLog(1, msgBuffer.toString());
                LogUtils.incrementTabbing();
            }
            return;
        }
    }

    public static void logExiting() {
        LogUtils.decreaseTabbing();
    }

    public static void logMessage(String comment) {
        if (comment != null) {
            LogUtils.doLog(2, comment);
        }
    }

    public static void logThrowable(Throwable throwable) {
        if (logLevel <= 1) {
            StackTraceElement[] stackTrace;
            String mess = throwable.getMessage();
            if (mess == null) {
                mess = "";
            }
            StringBuffer msgBuffer = new StringBuffer(mess);
            StackTraceElement[] stackTraceElementArray = stackTrace = throwable.getStackTrace();
            int n = stackTrace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement el = stackTraceElementArray[n2];
                msgBuffer.append("\n" + el.toString());
                ++n2;
            }
            LogUtils.doLog(4, msgBuffer.toString());
        } else {
            LogUtils.doLog(4, throwable.getMessage());
        }
    }

    private static void doLog(int level, String message) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        String date = dateFormat.format(Calendar.getInstance().getTime());
        if (message != null && level >= logLevel) {
            logger.log((IStatus)new Status(level, ReversePlugin.getId(), String.valueOf(date) + ": " + message));
        }
    }

    private static String getUMLName(Element createdElement) {
        if (createdElement instanceof NamedElement) {
            return ((NamedElement)createdElement).getName();
        }
        return "unnamed";
    }

    private static String getAstName(ASTNode node) {
        String name = null;
        switch (node.getNodeType()) {
            case 15: {
                name = ((CompilationUnit)node).getJavaElement().getElementName();
                break;
            }
            case 31: {
                name = ((MethodDeclaration)node).getName().getIdentifier();
                break;
            }
            case 32: {
                name = ((MethodInvocation)node).getName().getIdentifier();
                break;
            }
            case 60: {
                name = ((VariableDeclarationStatement)node).toString().trim();
                break;
            }
            case 21: {
                name = ((ExpressionStatement)node).toString().trim();
                break;
            }
            default: {
                name = node.toString().trim();
            }
        }
        return name;
    }

    private static String getTypeName(Object element) {
        String className = element.getClass().getSimpleName();
        return className == null ? "element" : className;
    }

    public static void setLogLevel(int iLogLevel) {
        logLevel = iLogLevel;
    }
}

