/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.java.ui.launch;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.umlgen.gen.java.main.Uml2java;
import org.eclipse.umlgen.gen.java.services.UML2JavaConfigurationHolder;
import org.eclipse.umlgen.gen.java.ui.UML2JavaUIActivator;

public class UML2JavaLaunchDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String umlModelPath = "";
        try {
            umlModelPath = configuration.getAttribute("uml_model_path", "");
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.umlgen.gen.java.ui", e.getMessage(), (Throwable)e);
            UML2JavaUIActivator.getDefault().getLog().log((IStatus)status);
        }
        if (umlModelPath == null || umlModelPath.length() == 0) {
            return;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(umlModelPath));
        IWorkspaceRoot container = ResourcesPlugin.getWorkspace().getRoot();
        if (file != null && container != null && file.isAccessible() && container.isAccessible()) {
            URI modelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            UML2JavaConfigurationHolder configurationHolder = this.createConfigurationHolder(configuration);
            configurationHolder.put("generation_root_path", (Object)container.getLocation().toFile().getAbsolutePath());
            try {
                Uml2java uml2java = new Uml2java(modelURI, container.getLocation().toFile(), new ArrayList());
                uml2java.setConfigurationHolder(configurationHolder);
                uml2java.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
                container.refreshLocal(2, monitor);
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.umlgen.gen.java.ui", e.getMessage(), (Throwable)e);
                UML2JavaUIActivator.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    private UML2JavaConfigurationHolder createConfigurationHolder(ILaunchConfiguration configuration) {
        UML2JavaConfigurationHolder configurationHolder = new UML2JavaConfigurationHolder();
        try {
            configurationHolder.put("uml_model_path", (Object)configuration.getAttribute("uml_model_path", ""));
            configurationHolder.put("default_project_name", (Object)configuration.getAttribute("default_project_name", ""));
            configurationHolder.put("source_folder_path", (Object)configuration.getAttribute("source_folder_path", ""));
            configurationHolder.put("output_folder_path", (Object)configuration.getAttribute("output_folder_path", ""));
            configurationHolder.put("jre_execution_environment", (Object)configuration.getAttribute("jre_execution_environment", ""));
            configurationHolder.put("packages_ignore_generation", (Object)configuration.getAttribute("packages_ignore_generation", ""));
            configurationHolder.put("packages_ignore_imports", (Object)configuration.getAttribute("packages_ignore_imports", ""));
            configurationHolder.put("generate_getters_setters", (Object)configuration.getAttribute("generate_getters_setters", false));
            configurationHolder.put("generate_getters_collections", (Object)configuration.getAttribute("generate_getters_collections", false));
            configurationHolder.put("generate_setters_collections", (Object)configuration.getAttribute("generate_setters_collections", false));
            configurationHolder.put("generate_advanced_accessors_collections", (Object)configuration.getAttribute("generate_advanced_accessors_collections", false));
            configurationHolder.put("author", (Object)configuration.getAttribute("author", ""));
            configurationHolder.put("version", (Object)configuration.getAttribute("version", ""));
            configurationHolder.put("copyright_license", (Object)configuration.getAttribute("copyright_license", ""));
            configurationHolder.put("components_ignore", (Object)configuration.getAttribute("components_ignore", ""));
            configurationHolder.put("components_architecture", (Object)configuration.getAttribute("components_architecture", ""));
            configurationHolder.put("bundle_provider", (Object)configuration.getAttribute("bundle_provider", ""));
            configurationHolder.put("ordered_unique", (Object)configuration.getAttribute("ordered_unique", ""));
            configurationHolder.put("ordered_not_unique", (Object)configuration.getAttribute("ordered_not_unique", ""));
            configurationHolder.put("not_ordered_unique", (Object)configuration.getAttribute("not_ordered_unique", ""));
            configurationHolder.put("not_ordered_not_unique", (Object)configuration.getAttribute("not_ordered_not_unique", ""));
            configurationHolder.put("ignore_java_types_during_generation_and_import", (Object)configuration.getAttribute("ignore_java_types_during_generation_and_import", false));
            configurationHolder.put("types_to_ignore_during_generation", (Object)configuration.getAttribute("types_to_ignore_during_generation", ""));
            configurationHolder.put("types_to_ignore_during_imports", (Object)configuration.getAttribute("types_to_ignore_during_imports", ""));
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.umlgen.gen.java.ui", e.getMessage(), (Throwable)e);
            UML2JavaUIActivator.getDefault().getLog().log((IStatus)status);
        }
        return configurationHolder;
    }
}

