/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.autojava.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTSJServices {
    private static final int NB_BYTES_2 = 2;
    private static final int NB_BYTES_4 = 4;
    private static final int NB_BYTES_8 = 8;
    private static final String RTSJ_LOSSY_BUFFER = "RTSJ::LossyBuffer";
    private static final String RTSJ_SPORADIC_PORT = "RTSJ::SporadicPort";
    private static final String PERIOD = "period";
    private static final String RTSJ_PERIODIC_PORT = "RTSJ::PeriodicPort";
    private static final String RTSJ_BURST_PORT = "RTSJ::BurstPort";
    private static final String NB_MSG_PER_PERIOD = "nbMsgPerPeriod";
    private static final String RTSJ_SPORADIC = "RTSJ::Sporadic";
    private static final String RTSJ_PERIODIC = "RTSJ::Periodic";
    private static final char[] VALID_OPERATORS = new char[]{'/', '*', '+', '-'};

    public int computeNbMsgsSize(Port prt) {
        ComputedData data = this.computeMBuffer(prt);
        return data.size;
    }

    public int computePortSize(Interface i) {
        return this.computePortSize(0, i);
    }

    public int getPortSize(Port p) {
        if (p.getAppliedStereotype(RTSJ_LOSSY_BUFFER) != null) {
            return (Integer)p.getValue(p.getAppliedStereotype(RTSJ_LOSSY_BUFFER), "bufSize");
        }
        int size = 0;
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        interfaces.addAll((Collection<Interface>)p.getProvideds());
        Type type = p.getType();
        if (type instanceof Interface) {
            interfaces.add((Interface)type);
        }
        for (Interface i : interfaces) {
            size = this.computePortSize(size, i);
        }
        return size;
    }

    public int computePortSize(int size, Interface i) {
        int result = size;
        for (Reception reception : i.getOwnedReceptions()) {
            Signal signal = reception.getSignal();
            int s = this.computeSignalSize(signal);
            if (s <= result) continue;
            result = s;
        }
        return result;
    }

    public int getMBuffer(Port aPort) {
        if (aPort.getAppliedStereotype(RTSJ_LOSSY_BUFFER) != null) {
            return (Integer)aPort.getValue(aPort.getAppliedStereotype(RTSJ_LOSSY_BUFFER), "mbufSize");
        }
        return this.computeNbMsgsSize(aPort);
    }

    public int getPortBuffer(Class aClass) {
        int result = 0;
        for (Port aPort : this.getAllInheritedPorts(aClass)) {
            if (aPort.getType() == null) continue;
            int mBuffSize = this.getMBuffer(aPort);
            result += mBuffSize;
        }
        return result;
    }

    private List<Port> getAllInheritedPorts(Class aClass) {
        ArrayList<Port> ports = new ArrayList<Port>();
        ports.addAll((Collection<Port>)aClass.getOwnedPorts());
        EObject parent = aClass.eContainer();
        if (parent instanceof Class) {
            ports.addAll(this.getAllInheritedPorts((Class)parent));
        }
        return ports;
    }

    public int computeSignalSize(Signal signal) {
        int taille = 0;
        if (signal != null) {
            for (Property property : signal.getAllAttributes()) {
                taille += this.computeTypeSize(property);
            }
        }
        return taille;
    }

    private int computeTypeSize(Property property) {
        int result = 0;
        if (property != null && property.getAppliedStereotype("RTSJ::NotSerialized") == null) {
            int multiplicity = property.getUpper();
            if (multiplicity == -1) {
                try {
                    multiplicity = Integer.parseInt(property.getDefault());
                }
                catch (NumberFormatException numberFormatException) {
                    multiplicity = this.parseDefaultValue(property);
                }
            }
            if (this.is4bytes(property)) {
                result = 4 * multiplicity;
            } else if (this.is8bytes(property)) {
                result = 8 * multiplicity;
            } else if (this.is2bytes(property)) {
                result = 2 * multiplicity;
            } else if (this.is1byte(property)) {
                result = multiplicity;
            } else if (property.getType() instanceof Class) {
                result = this.computeClassSize((Class)property.getType()) * multiplicity;
            }
        }
        return result;
    }

    private boolean is1byte(Property property) {
        return "EByte".equals(property.getType().getName()) || "Boolean".equals(property.getType().getName()) || "EBoolean".equals(property.getType().getName()) || "byte".equals(property.getType().getName()) || "boolean".equals(property.getType().getName());
    }

    private boolean is2bytes(Property property) {
        return "EShort".equals(property.getType().getName()) || "EChar".equals(property.getType().getName()) || "short".equals(property.getType().getName());
    }

    private boolean is4bytes(Property property) {
        return "EFloat".equals(property.getType().getName()) || "UnlimitedNatural".equals(property.getType().getName()) || "Integer".equals(property.getType().getName()) || "EInt".equals(property.getType().getName()) || property.getType() instanceof Enumeration || "int".equals(property.getType().getName()) || "float".equals(property.getType().getName());
    }

    private boolean is8bytes(Property property) {
        return "EDouble".equals(property.getType().getName()) || "ELong".equals(property.getType().getName()) || "double".equals(property.getType().getName()) || "long".equals(property.getType().getName());
    }

    private int parseDefaultValue(Property property) {
        return this.evaluate(property.getDefault().replaceAll(" ", ""), '+', "0", property.getModel());
    }

    private int computeClassSize(Class cl) {
        int size = 0;
        for (Generalization generalization : cl.getGeneralizations()) {
            if (!(generalization instanceof Class)) continue;
            size += this.computeClassSize((Class)generalization);
        }
        for (Property prop : cl.getAllAttributes()) {
            size += this.computeTypeSize(prop);
        }
        for (Association association : cl.getAssociations()) {
            for (Property prop : association.getNavigableOwnedEnds()) {
                size += this.computeTypeSize(prop);
            }
        }
        return size;
    }

    private int evaluate(String leftSide, char oper, String rightSide, Model model) throws IllegalArgumentException {
        int rightResult;
        int leftResult;
        int total;
        block15: {
            int operatorLoc;
            block14: {
                total = 0;
                leftResult = 0;
                rightResult = 0;
                operatorLoc = RTSJServices.findOperatorLocation(leftSide);
                if (operatorLoc > 0 && operatorLoc < leftSide.length() - 1) {
                    leftResult = this.evaluate(leftSide.substring(0, operatorLoc), leftSide.charAt(operatorLoc), leftSide.substring(operatorLoc + 1, leftSide.length()), model);
                } else {
                    try {
                        leftResult = Integer.parseInt(leftSide);
                    }
                    catch (NumberFormatException numberFormatException) {
                        leftResult = this.parseElementValue(leftSide, model);
                        if (leftResult != Integer.MAX_VALUE) break block14;
                        throw new IllegalArgumentException("Invalid value found in portion of equation: " + leftSide);
                    }
                }
            }
            operatorLoc = RTSJServices.findOperatorLocation(rightSide);
            if (operatorLoc > 0 && operatorLoc < rightSide.length() - 1) {
                rightResult = this.evaluate(rightSide.substring(0, operatorLoc), rightSide.charAt(operatorLoc), rightSide.substring(operatorLoc + 1, rightSide.length()), model);
            } else {
                try {
                    rightResult = Integer.parseInt(rightSide);
                }
                catch (NumberFormatException numberFormatException) {
                    rightResult = this.parseElementValue(rightSide, model);
                    if (rightResult != Integer.MAX_VALUE) break block15;
                    throw new IllegalArgumentException("Invalid value found in portion of equation: " + rightSide);
                }
            }
        }
        switch (oper) {
            case '/': {
                total = leftResult / rightResult;
                break;
            }
            case '*': {
                total = leftResult * rightResult;
                break;
            }
            case '+': {
                total = leftResult + rightResult;
                break;
            }
            case '-': {
                total = leftResult - rightResult;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator.");
            }
        }
        return total;
    }

    private static int findOperatorLocation(String string) {
        int index = -1;
        int i = VALID_OPERATORS.length - 1;
        while (i >= 0) {
            index = string.indexOf(VALID_OPERATORS[i]);
            if (index >= 0) {
                return index;
            }
            --i;
        }
        return index;
    }

    private int parseElementValue(String elementname, Model model) {
        String[] tosearch = elementname.split("\\.");
        NamedElement[] foundlist = new NamedElement[100];
        int foundnb = this.searchNamedElements(tosearch[0], (NamedElement)model, foundlist, 0, true);
        int cptsearch = 1;
        int i = 0;
        while (i < foundnb) {
            NamedElement[] foundlist2 = new NamedElement[2];
            int foundnb2 = this.searchNamedElements(tosearch[cptsearch], foundlist[i], foundlist2, 0, false);
            if (foundnb2 == 1) {
                foundlist = foundlist2;
                foundnb = foundnb2;
                i = 0;
                if (++cptsearch == tosearch.length) {
                    if (!(foundlist[0] instanceof Property)) break;
                    try {
                        return Integer.parseInt(((Property)foundlist[0]).getDefault());
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                }
            } else if (cptsearch != 1) break;
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    private int searchNamedElements(String name, NamedElement into, NamedElement[] listreturn, int cpt, boolean recursive) {
        int cpt2 = cpt;
        EList elements = into.getOwnedElements();
        int i = 0;
        while (i < elements.size()) {
            try {
                NamedElement obj = (NamedElement)elements.get(i);
                if (obj != null && obj.getName() != null) {
                    if (obj.getName().compareTo(name) == 0) {
                        listreturn[cpt2++] = obj;
                        if (cpt2 == listreturn.length) break;
                    }
                    if (recursive) {
                        cpt2 = this.searchNamedElements(name, obj, listreturn, cpt2, recursive);
                    }
                }
            }
            catch (ClassCastException classCastException) {}
            ++i;
        }
        return cpt2;
    }

    private ComputedData computeMBuffer(Port prt) {
        ComputedData result = new ComputedData(0, 0.0);
        Integer classPeriod = 0;
        EObject container = prt.eContainer();
        if (container instanceof Class) {
            Class myClass = (Class)container;
            if (myClass.getAppliedStereotype(RTSJ_PERIODIC) != null) {
                classPeriod = (Integer)myClass.getValue(myClass.getAppliedStereotype(RTSJ_PERIODIC), PERIOD);
            } else if (myClass.getAppliedStereotype(RTSJ_SPORADIC) != null) {
                classPeriod = (Integer)myClass.getValue(myClass.getAppliedStereotype(RTSJ_SPORADIC), PERIOD);
            }
            if (this.isPortAsynchronous(prt)) {
                int k = 1;
                int p = 1;
                boolean isPeriodSet = false;
                if (prt.getAppliedStereotype(RTSJ_BURST_PORT) != null) {
                    k = (Integer)prt.getValue(prt.getAppliedStereotype(RTSJ_BURST_PORT), NB_MSG_PER_PERIOD);
                    p = (Integer)prt.getValue(prt.getAppliedStereotype(RTSJ_BURST_PORT), PERIOD);
                    isPeriodSet = true;
                } else if (prt.getAppliedStereotype(RTSJ_PERIODIC_PORT) != null) {
                    p = (Integer)prt.getValue(prt.getAppliedStereotype(RTSJ_PERIODIC_PORT), PERIOD);
                    isPeriodSet = true;
                } else if (prt.getAppliedStereotype(RTSJ_SPORADIC_PORT) != null) {
                    p = (Integer)prt.getValue(prt.getAppliedStereotype(RTSJ_SPORADIC_PORT), PERIOD);
                    isPeriodSet = true;
                }
                if (isPeriodSet) {
                    result = new ComputedData(k * (1 + classPeriod / p), (double)k / (double)p);
                }
            }
        }
        return result;
    }

    public boolean isPortAsynchronous(Port port) {
        boolean result = false;
        Iterator interfaces = port.getProvideds().iterator();
        block0: while (!result && interfaces.hasNext()) {
            Interface i = (Interface)interfaces.next();
            if (i instanceof Signal) {
                result = true;
                break;
            }
            for (Classifier c : i.getNestedClassifiers()) {
                if (!(c instanceof Signal)) continue;
                result = true;
                break;
            }
            if (result) continue;
            for (NamedElement n : i.getMembers()) {
                if (!(n instanceof Reception)) continue;
                result = true;
                continue block0;
            }
        }
        return result;
    }

    private class ComputedData {
        private int size;
        private double freq;

        public ComputedData(int size, double freq) {
            this.size = size;
            this.freq = freq;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public double getFreq() {
            return this.freq;
        }

        public void setFreq(double freq) {
            this.freq = freq;
        }
    }
}

