/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.java;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.umlgen.reverse.java.AbstractJava2UMLConverter;
import org.eclipse.umlgen.reverse.java.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java2UMLConverter
extends AbstractJava2UMLConverter {
    private static final String SIGNAL_EVENT_PREFIX = "Event_";
    protected String userCodeStartTag = "// Start of user code";
    protected String userCodeStopTag = "// End of user code";
    protected String connectorCodeStartTag = "/**  CONNECTORS.  ***/";

    @Override
    protected void initializeModel(Package model) throws CoreException {
        if (this.importList != null && this.importList.length > 0) {
            String[] stringArray = this.importList;
            int n = this.importList.length;
            int n2 = 0;
            while (n2 < n) {
                String im = stringArray[n2];
                try {
                    URI uri = URI.createFileURI((String)im);
                    Package package1 = null;
                    try {
                        package1 = this.load(uri);
                    }
                    catch (WrappedException we) {
                        LogUtils.logThrowable(we);
                        this.throwCoreException(we.getMessage());
                    }
                    if (package1 instanceof Profile) {
                        Profile profile = (Profile)package1;
                        if (!model.isProfileApplied(profile)) {
                            model.applyProfile(profile);
                        }
                    } else {
                        PackageImport packImport = model.createPackageImport(package1, VisibilityKind.PUBLIC_LITERAL);
                        LogUtils.logCreation(null, null, packImport, null);
                    }
                }
                catch (Exception e) {
                    LogUtils.logThrowable(e);
                    this.throwCoreException(e.getMessage());
                }
                ++n2;
            }
        }
        this.umlLibrary = this.load(URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml"));
        this.javaLibrary = this.load(URI.createURI((String)"pathmap://UML_LIBRARIES/JavaPrimitiveTypes.library.uml"));
        PackageImport packImport = model.createPackageImport(this.umlLibrary, VisibilityKind.PUBLIC_LITERAL);
        LogUtils.logCreation(null, null, packImport, null);
        PackageImport packImport2 = model.createPackageImport(this.javaLibrary, VisibilityKind.PUBLIC_LITERAL);
        LogUtils.logCreation(null, null, packImport2, null);
        String[] stringArray = PRIMITIVE_TYPES;
        int n = PRIMITIVE_TYPES.length;
        int n3 = 0;
        while (n3 < n) {
            String type = stringArray[n3];
            if (model.getOwnedType(type) == null) {
                if (this.umlLibrary.getOwnedType(type) != null) {
                    model.createElementImport((PackageableElement)this.umlLibrary.getOwnedType(type));
                } else if (this.javaLibrary.getOwnedType(type) != null) {
                    model.createElementImport((PackageableElement)this.javaLibrary.getOwnedType(type));
                } else {
                    model.createOwnedPrimitiveType(type);
                }
            }
            ++n3;
        }
    }

    @Override
    protected void initializeTypes(HashMap<String, Type> allTypes, Package packageObject, IPackageFragment fragment) throws JavaModelException {
        IJavaElement[] iJavaElementArray = fragment.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement = iJavaElementArray[n2];
            try {
                if (javaElement instanceof IClassFile) {
                    LogUtils.logEntering(javaElement, "Initializing types");
                    this.handleType(allTypes, packageObject, fragment, null, new IImportDeclaration[0], ((IClassFile)javaElement).getType());
                    LogUtils.logExiting();
                } else if (javaElement instanceof ICompilationUnit) {
                    LogUtils.logEntering(javaElement, "Initializing types");
                    ICompilationUnit unit = (ICompilationUnit)javaElement;
                    IImportDeclaration[] importList = unit.getImports();
                    IType[] iTypeArray = unit.getAllTypes();
                    int n3 = iTypeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IType type = iTypeArray[n4];
                        this.handleType(allTypes, packageObject, fragment, unit, importList, type);
                        ++n4;
                    }
                    LogUtils.logExiting();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtils.logMessage("ERROR - unknown initializeTypes");
                LogUtils.logExiting();
                LogUtils.logThrowable(e);
            }
            ++n2;
        }
    }

    private void handleType(HashMap<String, Type> allTypes, Package packageObject, IPackageFragment fragment, ICompilationUnit unit, IImportDeclaration[] importList, IType type) {
        LogUtils.logEntering(type, null);
        String typeName = this.resolveTypeInContext((Element)packageObject, type, type.getElementName());
        NamedElement element = (NamedElement)allTypes.get(typeName);
        if (element instanceof Interface) {
            try {
                Interface interfaceObject = (Interface)element;
                String[] stringArray = type.getSuperInterfaceNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String interfaceName = stringArray[n2];
                    interfaceName = this.resolveTypeInContext((Element)element, type, interfaceName);
                    Type interfaceType = this.findOrCreateType(element.getNearestPackage(), interfaceName);
                    if (interfaceType != null && interfaceType instanceof Classifier) {
                        Generalization gen = interfaceObject.createGeneralization((Classifier)interfaceType);
                        LogUtils.logCreation(unit, null, gen, null);
                    }
                    ++n2;
                }
                if (!(!(type.getParent() instanceof ICompilationUnit) || this.avoidDependenciesComputing() && this.avoidImportElement())) {
                    this.createImports(importList, (Classifier)interfaceObject);
                }
                this.createProperties(type, interfaceObject);
                this.createOperations(type, interfaceObject);
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtils.logThrowable(e);
                LogUtils.logExiting();
            }
        } else if (element instanceof Enumeration) {
            try {
                Enumeration enumeration = (Enumeration)element;
                String[] stringArray = type.getSuperInterfaceNames();
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Classifier classifier;
                    String interfaceName = stringArray[n3];
                    interfaceName = this.resolveTypeInContext((Element)element, type, interfaceName);
                    Type interfaceType = this.findOrCreateType(element.getNearestPackage(), interfaceName);
                    if (interfaceType != null && interfaceType instanceof Interface && enumeration.getGeneralization(classifier = (Classifier)interfaceType) == null) {
                        Generalization gen = enumeration.createGeneralization(classifier);
                        LogUtils.logCreation(unit, null, gen, null);
                    }
                    ++n3;
                }
                if (!(!(type.getParent() instanceof ICompilationUnit) || this.avoidDependenciesComputing() && this.avoidImportElement())) {
                    this.createImports(importList, (Classifier)enumeration);
                }
                this.createProperties(type, enumeration);
                this.createOperations(type, enumeration);
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtils.logThrowable(e);
                LogUtils.logExiting();
            }
        } else if (element instanceof Class) {
            try {
                Class classObject = (Class)element;
                String[] stringArray = type.getSuperInterfaceNames();
                int n = stringArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Interface interf;
                    String interfaceName = stringArray[n4];
                    interfaceName = this.resolveTypeInContext((Element)element, type, interfaceName);
                    Type interfaceType = this.findOrCreateType(element.getNearestPackage(), interfaceName);
                    if (interfaceType != null && interfaceType instanceof Interface && classObject.getInterfaceRealization(interfaceName, interf = (Interface)interfaceType) == null) {
                        InterfaceRealization iRealization = classObject.createInterfaceRealization(interfaceName, interf);
                        LogUtils.logCreation(unit, null, iRealization, null);
                    }
                    ++n4;
                }
                String superClassName = null;
                if (type.getSuperclassName() != null) {
                    Classifier classifier;
                    superClassName = this.resolveTypeInContext((Element)element, type, type.getSuperclassName());
                    Type classType = this.findOrCreateType(element.getNearestPackage(), superClassName);
                    if (classType != null && classType instanceof Classifier && classObject.getGeneralization(classifier = (Classifier)classType) == null) {
                        Generalization gen = classObject.createGeneralization(classifier);
                        LogUtils.logCreation(unit, null, gen, null);
                    }
                }
                if (!(!(type.getParent() instanceof ICompilationUnit) || this.avoidDependenciesComputing() && this.avoidImportElement())) {
                    this.createImports(importList, (Classifier)classObject);
                }
                this.createProperties(type, classObject, fragment);
                this.createOperations(type, classObject);
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtils.logMessage("ERROR - unknown initializeTypes catched for class element " + element.getName());
                LogUtils.logExiting();
                LogUtils.logThrowable(e);
            }
        }
        LogUtils.logExiting();
    }

    protected void createProperties(IType type, Class classifier, IPackageFragment fragment) throws JavaModelException {
        IField[] iFieldArray = type.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if (this.canBeImported((IMember)field)) {
                LogUtils.logEntering(field, "creating property");
                Property propertyObject = this.findProperty((Classifier)classifier, field.getElementName());
                if (propertyObject != null) {
                    this.attachJavadoc((Element)propertyObject, (IMember)field);
                } else {
                    propertyObject = this.createProperty((Element)classifier, field);
                    classifier.getOwnedAttributes().add((Object)propertyObject);
                    LogUtils.logCreation(null, field, propertyObject, null);
                }
                LogUtils.logExiting();
            }
            ++n2;
        }
    }

    protected void createProperties(IType type, Interface interfaceObject) throws JavaModelException {
        IField[] fields;
        IField[] iFieldArray = fields = type.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            LogUtils.logEntering(field, "creating property");
            Property propertyObject = this.findProperty((Classifier)interfaceObject, field.getElementName());
            if (propertyObject != null) {
                this.attachJavadoc((Element)interfaceObject, (IMember)type);
            } else {
                propertyObject = this.createProperty((Element)interfaceObject, field);
                LogUtils.logCreation(null, field, propertyObject, null);
                if (propertyObject != null) {
                    interfaceObject.getOwnedAttributes().add((Object)propertyObject);
                }
            }
            LogUtils.logExiting();
            ++n2;
        }
    }

    protected void createProperties(IType type, Enumeration enumeration) throws JavaModelException {
        IField[] iFieldArray = type.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            LiteralInteger value;
            EnumerationLiteral lit;
            IField field = iFieldArray[n2];
            LogUtils.logEntering(field, "creating property");
            String typename = Signature.toString((String)Signature.getTypeErasure((String)Signature.getElementType((String)field.getTypeSignature())));
            if (typename.equals(type.getElementName())) {
                lit = enumeration.getOwnedLiteral(field.getElementName());
                if (lit == null) {
                    lit = enumeration.createOwnedLiteral(field.getElementName());
                    value = UMLFactory.eINSTANCE.createLiteralInteger();
                    if (field.getConstant() instanceof Integer) {
                        value.setValue(((Integer)field.getConstant()).intValue());
                    }
                    lit.setSpecification((ValueSpecification)value);
                    LogUtils.logCreation(null, field, lit, null);
                }
                this.attachJavadoc((Element)lit, (IMember)field);
            } else if (!type.isEnum()) {
                lit = enumeration.getOwnedLiteral(field.getElementName());
                if (lit == null) {
                    lit = enumeration.createOwnedLiteral(field.getElementName());
                }
                value = UMLFactory.eINSTANCE.createLiteralInteger();
                if (field.getConstant() instanceof Integer) {
                    value.setValue(((Integer)field.getConstant()).intValue());
                }
                lit.setSpecification((ValueSpecification)value);
                LogUtils.logCreation(null, field, lit, null);
                this.attachJavadoc((Element)lit, (IMember)field);
            } else {
                Property propertyObject = this.findProperty((Classifier)enumeration, field.getElementName());
                if (propertyObject == null) {
                    propertyObject = this.createProperty((Element)enumeration, field);
                    enumeration.getOwnedAttributes().add((Object)propertyObject);
                    LogUtils.logCreation(null, field, propertyObject, null);
                }
                this.attachJavadoc((Element)propertyObject, (IMember)field);
            }
            LogUtils.logExiting();
            ++n2;
        }
    }

    @Override
    protected HashMap<String, Type> processTypes(Namespace packageObject, IType[] types) throws JavaModelException {
        HashMap<String, Type> alltypes = new HashMap<String, Type>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            LogUtils.logEntering(type, "Processing types");
            if (this.canBeImported((IMember)type)) {
                Classifier createTypeInPackage = (Classifier)packageObject.getMember(type.getElementName(), false, UMLPackage.eINSTANCE.getClassifier());
                if (createTypeInPackage == null) {
                    createTypeInPackage = this.createTypeInPackage(packageObject, type);
                    LogUtils.logCreation(null, type, createTypeInPackage, null);
                }
                alltypes.put(type.getFullyQualifiedName('.'), (Type)createTypeInPackage);
                IType[] innerTypes = type.getTypes();
                if (innerTypes.length > 0) {
                    alltypes.putAll(this.processTypes((Namespace)createTypeInPackage, innerTypes));
                }
            }
            LogUtils.logExiting();
            ++n2;
        }
        return alltypes;
    }

    @Override
    protected Classifier createTypeInPackage(Namespace packageObject, IType type) throws JavaModelException {
        if (type.isInterface()) {
            Interface interfaceObject = UMLFactory.eINSTANCE.createInterface();
            if (type.isAnnotation()) {
                interfaceObject.setName("@" + type.getElementName());
            } else {
                interfaceObject.setName(type.getElementName());
            }
            this.createTemplateParameters(type, (Classifier)interfaceObject);
            this.update((NamedElement)interfaceObject, type.getFlags());
            this.attachJavadoc((Element)interfaceObject, (IMember)type);
            this.addToContainment(packageObject, (Classifier)interfaceObject);
            return interfaceObject;
        }
        if (this.isEnumeration(type)) {
            Enumeration enumeration = UMLFactory.eINSTANCE.createEnumeration();
            enumeration.setName(type.getElementName());
            this.update((NamedElement)enumeration, type.getFlags());
            this.attachJavadoc((Element)enumeration, (IMember)type);
            this.addToContainment(packageObject, (Classifier)enumeration);
            return enumeration;
        }
        Class classObject = UMLFactory.eINSTANCE.createClass();
        classObject.setName(type.getElementName());
        this.createTemplateParameters(type, (Classifier)classObject);
        this.update((NamedElement)classObject, type.getFlags());
        this.attachJavadoc((Element)classObject, (IMember)type);
        this.addToContainment(packageObject, (Classifier)classObject);
        return classObject;
    }

    @Override
    protected Package findOrCreateRootPackage() {
        Model model;
        for (EObject eObject : this.emfResource.getContents()) {
            if (!(eObject instanceof Package) || !(((Package)eObject).getName() == null ? this.modelName == null || "".equals(this.modelName) : ((Package)eObject).getName().equals(this.modelName))) continue;
            return (Package)eObject;
        }
        Model modelout = model = UMLFactory.eINSTANCE.createModel();
        this.emfResource.getContents().add((Object)modelout);
        modelout.setName(this.modelName);
        LogUtils.logCreation(null, null, modelout, null);
        return modelout;
    }

    protected void createOperations(IType type, Enumeration enumeration) throws JavaModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            LogUtils.logEntering(method, "Creating operation");
            if (this.canBeImported((IMember)method) && !this.isStrucDiag((IMember)method)) {
                Operation operationObject = this.findOperation((Classifier)enumeration, method);
                if (operationObject != null) {
                    this.attachJavadoc((Element)operationObject, (IMember)method);
                } else {
                    operationObject = this.createOperation((Element)enumeration, method);
                    LogUtils.logCreation(null, method, operationObject, null);
                    enumeration.getOwnedOperations().add((Object)operationObject);
                }
            }
            LogUtils.logExiting();
            ++n2;
        }
    }

    protected void createOperations(IType type, Interface interfaceObject) throws JavaModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            LogUtils.logEntering(method, "Creating operation");
            if (!this.isStrucDiag((IMember)method)) {
                Operation operationObject = this.findOperation((Classifier)interfaceObject, method);
                if (operationObject != null) {
                    this.attachJavadoc((Element)operationObject, (IMember)method);
                    LogUtils.logCreation(interfaceObject, method, operationObject, " method found");
                } else {
                    operationObject = this.createOperation((Element)interfaceObject, method);
                    LogUtils.logCreation(interfaceObject, method, operationObject, null);
                    interfaceObject.getOwnedOperations().add((Object)operationObject);
                }
            }
            LogUtils.logExiting();
            ++n2;
        }
    }

    private void createOperations(IType type, Class classifier) throws JavaModelException {
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            LogUtils.logEntering(method, "Creating operation");
            method.getFlags();
            if (this.canBeImported((IMember)method)) {
                String source = method.getSource().trim();
                if (method.isConstructor() && method.getParameterNames().length == 0 && source.length() == 0) {
                    LogUtils.logExiting();
                    return;
                }
                Operation operationObject = this.findOperation((Classifier)classifier, method);
                if (operationObject == null) {
                    operationObject = this.createOperation((Element)classifier, method);
                    LogUtils.logCreation(classifier, method, operationObject, null);
                    classifier.getOwnedOperations().add((Object)operationObject);
                } else {
                    LogUtils.logCreation(classifier, method, operationObject, " method found");
                }
                this.attachJavadoc((Element)operationObject, (IMember)method);
            }
            LogUtils.logExiting();
            ++n2;
        }
    }

    protected void createImports(IImportDeclaration[] importList, Classifier classifier) {
        LogUtils.logEntering(classifier, "Creating import");
        IImportDeclaration[] iImportDeclarationArray = importList;
        int n = importList.length;
        int n2 = 0;
        while (n2 < n) {
            IImportDeclaration importDecl = iImportDeclarationArray[n2];
            String importedName = importDecl.getElementName();
            if (importedName.endsWith(".*")) {
                Package importedPackage;
                String packageQName = importedName.substring(0, importedName.lastIndexOf(46));
                if (!packageQName.endsWith(classifier.getPackage().getName()) && (importedPackage = this.findOrCreatePackage((Package)classifier.getModel(), packageQName)) != null && classifier.getPackageImport(importedPackage) == null) {
                    PackageImport packImport = classifier.createPackageImport(importedPackage, VisibilityKind.PRIVATE_LITERAL);
                    LogUtils.logCreation(null, null, packImport, null);
                }
            } else {
                Type importedElement = this.findOrCreateType(classifier.getNearestPackage(), importedName);
                if (importedElement != null && classifier.getElementImport((PackageableElement)importedElement) == null) {
                    ElementImport elImport = classifier.createElementImport((PackageableElement)importedElement, VisibilityKind.PRIVATE_LITERAL);
                    LogUtils.logCreation(null, null, elImport, null);
                }
            }
            ++n2;
        }
        LogUtils.logExiting();
    }

    protected Port findPort(Classifier classifier, String name) {
        for (Property prop : classifier.getAllAttributes()) {
            if (!prop.getName().equals(name) || !(prop instanceof Port)) continue;
            return (Port)prop;
        }
        return null;
    }

    protected Port findPort2(Classifier classifier, String name) {
        NamedElement prop;
        Port port = this.findPort(classifier, name);
        if (port == null && (prop = classifier.getInheritedMember(name)) instanceof Port) {
            return (Port)prop;
        }
        return port;
    }

    protected Reception findReception(Classifier classifier, IMethod method) {
        BasicEList paramList = new BasicEList();
        BasicEList paramTypeList = new BasicEList();
        Reception rec = null;
        if (classifier instanceof Class) {
            rec = ((Class)classifier).getOwnedReception(method.getElementName(), (EList)paramList, (EList)paramTypeList, false, false);
            return rec;
        }
        if (classifier instanceof Interface) {
            rec = ((Interface)classifier).getOwnedReception(method.getElementName(), (EList)paramList, (EList)paramTypeList, false, false);
            return rec;
        }
        return null;
    }

    protected Reception createReception(Classifier classifier, IMethod method) throws JavaModelException {
        Reception receptionObject = null;
        BasicEList paramList = new BasicEList();
        BasicEList paramTypeList = new BasicEList();
        if (classifier instanceof Class) {
            receptionObject = ((Class)classifier).createOwnedReception(method.getElementName(), (EList)paramList, (EList)paramTypeList);
        } else if (classifier instanceof Interface) {
            receptionObject = ((Interface)classifier).createOwnedReception(method.getElementName(), (EList)paramList, (EList)paramTypeList);
        }
        this.attachJavadoc((Element)receptionObject, (IMember)method);
        this.update((NamedElement)receptionObject, method.getFlags());
        Signal signalObject = this.findSignal(classifier.getNearestPackage(), method.getElementName());
        if (signalObject == null) {
            signalObject = this.createSignal(classifier.getNearestPackage(), method);
            LogUtils.logCreation(null, null, signalObject, null);
        }
        receptionObject.setSignal(signalObject);
        return receptionObject;
    }

    protected Signal createSignal(Package signalPackage, IMethod method) throws JavaModelException {
        Signal signalObject = UMLFactory.eINSTANCE.createSignal();
        signalObject.setName(method.getElementName());
        BasicEList paramList = new BasicEList();
        String[] stringArray = method.getParameterNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            paramList.add((Object)param);
            ++n2;
        }
        BasicEList paramTypeList = new BasicEList();
        BasicEList upperList = new BasicEList();
        String[] stringArray2 = method.getParameterTypes();
        int n3 = stringArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            Type paramType;
            String param = stringArray2[n4];
            Integer upper = 1;
            String typeWithoutArray = Signature.getElementType((String)param);
            String typeName = Signature.toString((String)Signature.getTypeErasure((String)typeWithoutArray));
            if (param.contains("[")) {
                upper = -1;
            }
            if ((paramType = this.findOrCreateType(signalPackage, typeName = this.resolveTypeInContext((Element)signalPackage, method.getDeclaringType(), typeName))) != null) {
                paramTypeList.add((Object)paramType);
                upperList.add((Object)upper);
            }
            ++n4;
        }
        int i = 0;
        while (i < paramList.size()) {
            signalObject.createOwnedAttribute((String)paramList.get(i), (Type)paramTypeList.get(i), 1, ((Integer)upperList.get(i)).intValue());
            ++i;
        }
        LogUtils.logCreation(null, null, signalObject, null);
        SignalEvent signalEvent = this.findSignalEvent(signalPackage, SIGNAL_EVENT_PREFIX + method.getElementName());
        if (signalEvent == null) {
            signalEvent = this.createSignalEvent(signalPackage, SIGNAL_EVENT_PREFIX + method.getElementName());
        }
        signalEvent.setSignal(signalObject);
        this.addToContainment((Namespace)signalPackage, (Classifier)signalObject);
        return signalObject;
    }

    protected Signal findSignal(Package signalPackage, String signalName) {
        for (PackageableElement element : signalPackage.getPackagedElements()) {
            if (!element.getName().equals(signalName) || !(element instanceof Signal)) continue;
            return (Signal)element;
        }
        return null;
    }

    protected SignalEvent createSignalEvent(Package signalPackage, String signalEventName) throws JavaModelException {
        SignalEvent signalEventObject = UMLFactory.eINSTANCE.createSignalEvent();
        signalEventObject.setName(signalEventName);
        signalPackage.getPackagedElements().add((Object)signalEventObject);
        return signalEventObject;
    }

    protected SignalEvent findSignalEvent(Package signalPackage, String signalEventName) {
        for (PackageableElement element : signalPackage.getPackagedElements()) {
            if (!element.getName().equals(signalEventName) || !(element instanceof SignalEvent)) continue;
            return (SignalEvent)element;
        }
        return null;
    }

    @Override
    protected Package createPackage(Package model, String packageQName) {
        StringTokenizer tokenizer = new StringTokenizer(packageQName, ".");
        Package parent = model;
        Package packageObject = model;
        while (tokenizer.hasMoreTokens()) {
            String packageName = tokenizer.nextToken();
            packageObject = parent.getNestedPackage(packageName);
            if (packageObject == null) {
                packageObject = parent.createNestedPackage(packageName);
                LogUtils.logCreation(null, packageName, packageObject, " Created from Java2UMLConverter");
            }
            parent = packageObject;
        }
        return packageObject;
    }

    @Override
    protected Type createNotFoundDataType(Package packageObject, String typeName) {
        Type type = null;
        type = this.createDataType((Package)packageObject.getModel(), typeName);
        return type;
    }
}

