/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.c.common.util;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.umlgen.c.common.interactions.SynchronizersManager;
import org.eclipse.umlgen.c.common.interactions.extension.IDiagramSynchronizer;
import org.eclipse.umlgen.c.common.interactions.extension.IModelSynchronizer;
import org.eclipse.umlgen.c.common.util.AnnotationUtil;
import org.eclipse.umlgen.c.common.util.ModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelUtil {
    private static Set<String> primitiveTypes = Sets.newHashSet((Object[])new String[]{"void", "char", "unsigned char", "signed char", "short", "signed short", "unsigned short", "int", "unsigned", "unsigned int", "long", "unsigned long", "signed long", "long long", "unsigned long long", "signed long long", "float", "double", "long double", "Macro"});

    private ModelUtil() {
    }

    public static Set<String> getPrimitiveTypes() {
        return primitiveTypes;
    }

    public static String computeAnonymousTypeName(String unitName, String currentTypeName, IASTNode node) {
        if ("".equals(currentTypeName)) {
            int enumOffset = node.getFileLocation().getNodeOffset();
            StringBuilder sb = new StringBuilder("Anonymous__");
            sb.append(unitName);
            sb.append("_");
            return sb.append(String.valueOf(enumOffset)).toString();
        }
        return currentTypeName;
    }

    public static Classifier findClassifierInPackage(Package packageRef, final String name) {
        return (Classifier)UML2Util.findEObject((Iterator)packageRef.eAllContents(), (UML2Util.EObjectMatcher)new UML2Util.EObjectMatcher(){

            public boolean matches(EObject eObject) {
                if (eObject instanceof Classifier) {
                    return name.equals(((Classifier)eObject).getName());
                }
                return false;
            }
        });
    }

    public static Class findClassInPackage(Package packageRef, final String name) {
        return (Class)UML2Util.findEObject((Iterator)packageRef.eAllContents(), (UML2Util.EObjectMatcher)new UML2Util.EObjectMatcher(){

            public boolean matches(EObject eObject) {
                if (eObject instanceof Class) {
                    return name.equals(((Classifier)eObject).getName());
                }
                return false;
            }
        });
    }

    private static Type findTypeInClassifier(Classifier classifier, final String typeName) {
        return (Type)UML2Util.findEObject((Iterator)classifier.eAllContents(), (UML2Util.EObjectMatcher)new UML2Util.EObjectMatcher(){

            public boolean matches(EObject eObject) {
                if (eObject instanceof Type) {
                    Type candidate = (Type)eObject;
                    return typeName.equals(candidate.getName());
                }
                return false;
            }
        });
    }

    public static DataType findDataTypeInClassifier(Classifier classifier, final String dataTypeName) {
        return (DataType)UML2Util.findEObject((Iterator)classifier.eAllContents(), (UML2Util.EObjectMatcher)new UML2Util.EObjectMatcher(){

            public boolean matches(EObject eObject) {
                if (eObject instanceof DataType) {
                    DataType candidate = (DataType)eObject;
                    return dataTypeName.equals(candidate.getName()) && !candidate.getOwnedAttributes().isEmpty();
                }
                return false;
            }
        });
    }

    public static DataType findDataTypeRedefinitionInClassifier(Classifier classifier, final String redefinedDataType) {
        return (DataType)UML2Util.findEObject((Iterator)classifier.eAllContents(), (UML2Util.EObjectMatcher)new UML2Util.EObjectMatcher(){

            public boolean matches(EObject eObject) {
                if (eObject instanceof DataType) {
                    DataType candidate = (DataType)eObject;
                    return redefinedDataType.equals(candidate.getName()) && candidate.getOwnedAttributes().isEmpty();
                }
                return false;
            }
        });
    }

    public static Enumeration findEnumerationInClassifier(Classifier classifier, final String enumName) {
        return (Enumeration)UML2Util.findEObject((Iterator)classifier.eAllContents(), (UML2Util.EObjectMatcher)new UML2Util.EObjectMatcher(){

            public boolean matches(EObject eObject) {
                if (eObject instanceof Enumeration) {
                    Enumeration candidate = (Enumeration)eObject;
                    return enumName.equals(candidate.getName()) && !candidate.getOwnedLiterals().isEmpty();
                }
                return false;
            }
        });
    }

    public static Enumeration findEnumerationRedefinitionInClassifier(Classifier classifier, final String redefinedEnumName) {
        return (Enumeration)UML2Util.findEObject((Iterator)classifier.eAllContents(), (UML2Util.EObjectMatcher)new UML2Util.EObjectMatcher(){

            public boolean matches(EObject eObject) {
                if (eObject instanceof Enumeration) {
                    Enumeration candidate = (Enumeration)eObject;
                    return redefinedEnumName.equals(candidate.getName()) && candidate.getOwnedLiterals().isEmpty();
                }
                return false;
            }
        });
    }

    public static Usage findUsage(final Classifier classifier, final String distantClassifierName) {
        return (Usage)UML2Util.findEObject((Collection)classifier.getClientDependencies(), (UML2Util.EObjectMatcher)new UML2Util.EObjectMatcher(){

            public boolean matches(EObject eObject) {
                if (eObject instanceof Usage) {
                    Usage usage = (Usage)eObject;
                    return usage.getClient(classifier.getName()) != null && usage.getSupplier(distantClassifierName) != null;
                }
                return false;
            }
        });
    }

    public static Type getType(ModelManager manager, Classifier myClass, String typeName) {
        DataType myType = manager.findDataTypeInTypesPck(typeName);
        if (myType == null) {
            myType = ModelUtil.findTypeInClassifier(myClass, typeName);
        }
        if (myType == null) {
            return manager.getDataType(typeName);
        }
        return myType;
    }

    public static Operation getReferredOperation(Classifier classifier, String operationName, EList<Type> types, EList<Element> visited) {
        Operation operation = classifier.getOperation(operationName, null, types, true);
        if (operation != null) {
            return operation;
        }
        visited.add((Object)classifier);
        for (Classifier supplier : ModelUtil.getSupplierClassifiers(classifier)) {
            if (visited.contains((Object)supplier) || (operation = ModelUtil.getReferredOperation(supplier, operationName, types, visited)) == null || operation.getMethod(operationName) != null) continue;
            return operation;
        }
        return null;
    }

    public static OpaqueBehavior getReferredBehavior(Classifier classifier, String behaviorName, EList<Classifier> visited) {
        OpaqueBehavior behavior = null;
        if (classifier instanceof BehavioredClassifier && (behavior = (OpaqueBehavior)((BehavioredClassifier)classifier).getOwnedBehavior(behaviorName, false, UMLPackage.Literals.OPAQUE_BEHAVIOR, false)) != null) {
            return behavior;
        }
        visited.add((Object)classifier);
        for (Classifier client : ModelUtil.getClientClassifiers(classifier)) {
            if (!visited.contains((Object)client) && (behavior = ModelUtil.getReferredBehavior(client, behaviorName, visited)) != null && behavior.getSpecification() == null) break;
        }
        return behavior;
    }

    private static Collection<Classifier> getClientClassifiers(Classifier classifier) {
        BasicEList clients = new BasicEList();
        for (EStructuralFeature.Setting setting : UML2Util.getInverseReferences((EObject)classifier)) {
            if (!(setting.getEObject() instanceof Usage) || setting.getEStructuralFeature() != UMLPackage.Literals.DEPENDENCY__SUPPLIER) continue;
            Usage usage = (Usage)setting.getEObject();
            clients.addAll((Collection)usage.getClients());
        }
        return EcoreUtil.getObjectsByType((Collection)clients, (EClassifier)UMLPackage.Literals.CLASSIFIER);
    }

    private static Collection<Classifier> getSupplierClassifiers(Classifier classifier) {
        BasicEList suppliers = new BasicEList();
        for (Dependency dependency : classifier.getClientDependencies()) {
            suppliers.addAll((Collection)dependency.getSuppliers());
        }
        return EcoreUtil.getObjectsByType((Collection)suppliers, (EClassifier)UMLPackage.Literals.CLASSIFIER);
    }

    public static void setVisibility(NamedElement element, ITranslationUnit tu, EventType type) {
        if (element != null) {
            if (type == EventType.ADD) {
                element.setVisibility(tu.isHeaderUnit() ? VisibilityKind.PUBLIC_LITERAL : VisibilityKind.PRIVATE_LITERAL);
            } else if (type == EventType.REMOVE) {
                element.setVisibility(tu.isHeaderUnit() ? VisibilityKind.PRIVATE_LITERAL : VisibilityKind.PUBLIC_LITERAL);
            }
        }
    }

    public static void setVisibility(Classifier classifier) {
        if (AnnotationUtil.isSameTypeBetweenCandHUnits((Element)classifier)) {
            classifier.setVisibility(VisibilityKind.PRIVATE_LITERAL);
        } else {
            classifier.setVisibility(VisibilityKind.PUBLIC_LITERAL);
        }
    }

    public static boolean isRemovable(NamedElement element) {
        return !element.getVisibility().equals((Object)0);
    }

    public static void redefineType(Element existing, Element newElement) {
        ECrossReferenceAdapter crossAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)existing);
        if (crossAdapter != null) {
            for (EStructuralFeature.Setting aSetting : crossAdapter.getInverseReferences((EObject)existing, true)) {
                EReference ref;
                EObject eObject = aSetting.getEObject();
                if (aSetting.getEStructuralFeature() instanceof EReference) {
                    ref = (EReference)aSetting.getEStructuralFeature();
                    if (ref.isContainment() || ref.isUnsettable() || !ref.isChangeable()) continue;
                    if (ref.isMany() && !ref.isDerived()) {
                        BasicEList candidates = new BasicEList((Collection)((EList)eObject.eGet(aSetting.getEStructuralFeature(), true)));
                        if (!candidates.contains((Object)existing)) continue;
                        candidates.set(candidates.indexOf((Object)existing), (Object)newElement);
                        eObject.eSet((EStructuralFeature)ref, (Object)candidates);
                        continue;
                    }
                    if (!eObject.eGet(aSetting.getEStructuralFeature(), true).equals(existing)) continue;
                    eObject.eSet(aSetting.getEStructuralFeature(), (Object)newElement);
                    continue;
                }
                if (!(aSetting.getEStructuralFeature() instanceof EAttribute) || !eObject.eGet((EStructuralFeature)(ref = (EAttribute)aSetting.getEStructuralFeature()), true).equals(existing) || ref.isUnsettable() || !ref.isChangeable()) continue;
                eObject.eSet(aSetting.getEStructuralFeature(), (Object)newElement);
            }
        }
    }

    public static boolean isNotReferencedAnymore(Element existing) {
        for (EStructuralFeature.Setting aSetting : UML2Util.getInverseReferences((EObject)existing)) {
            if (aSetting.getEStructuralFeature() != UMLPackage.Literals.TYPED_ELEMENT__TYPE) continue;
            return false;
        }
        return true;
    }

    public static void destroy(Classifier classifier) {
        BasicEList toDestroy = new BasicEList();
        ModelUtil.destroy(classifier, (EList<Classifier>)toDestroy);
        for (Classifier c : toDestroy) {
            c.destroy();
        }
    }

    private static void destroy(Classifier classifier, EList<Classifier> selected) {
        for (Classifier c : classifier.getRedefinedClassifiers()) {
            if (!ModelUtil.isNotReferencedAnymore((Element)c)) continue;
            ModelUtil.destroy(c, selected);
        }
        selected.add((Object)classifier);
    }

    public static void deleteAllVisibleObjects(Classifier startingPoint, VisibilityKind visibility, ModelManager manager) {
        BasicEList elementsToDestroy = new BasicEList();
        IModelSynchronizer synchronizer = SynchronizersManager.getSynchronizer();
        if (synchronizer instanceof IDiagramSynchronizer) {
            for (DirectedRelationship link : startingPoint.getSourceDirectedRelationships()) {
                if (!((NamedElement)link).getVisibility().equals((Object)visibility)) continue;
                for (Element target : link.getTargets()) {
                    DirectedRelationship relation;
                    if (target.getTargetDirectedRelationships().size() != 1 || target.getTargetDirectedRelationships().size() <= 0 || (relation = (DirectedRelationship)target.getTargetDirectedRelationships().get(0)).getSources().size() <= 0 || !((Element)relation.getSources().get(0)).equals(startingPoint)) continue;
                    ((IDiagramSynchronizer)synchronizer).removeRepresentation((EObject)target, manager);
                    if (startingPoint.equals(target)) continue;
                    elementsToDestroy.add((Object)target);
                }
                ((IDiagramSynchronizer)synchronizer).removeRepresentation((EObject)link, manager);
                link.destroy();
            }
        }
        if (startingPoint instanceof Class) {
            for (Behavior function : ((Class)startingPoint).getOwnedBehaviors()) {
                if (!(function instanceof OpaqueBehavior)) continue;
                for (Parameter parameter : function.getOwnedParameters()) {
                    elementsToDestroy.add((Object)parameter);
                }
            }
        }
        if (startingPoint instanceof Class || startingPoint instanceof Interface) {
            for (Property property : startingPoint.getAttributes()) {
                elementsToDestroy.add((Object)property);
            }
            for (Operation operation : startingPoint.getOperations()) {
                for (Parameter parameter : operation.getOwnedParameters()) {
                    elementsToDestroy.add((Object)parameter);
                }
            }
        }
        int sizeList = elementsToDestroy.size();
        int i = sizeList - 1;
        while (i > -1) {
            ((Element)elementsToDestroy.get(i)).destroy();
            --i;
        }
        Package typesPackage = manager.getTypePackage();
        EList types = typesPackage.getOwnedElements();
        int size = types.size();
        int i2 = size - 1;
        while (i2 > -1) {
            if (types.get(i2) instanceof Type && ModelUtil.isNotReferencedAnymore((Element)types.get(i2))) {
                ((Element)types.get(i2)).destroy();
            }
            --i2;
        }
        if (synchronizer instanceof IDiagramSynchronizer) {
            for (NamedElement elt : EcoreUtil.getObjectsByType((Collection)startingPoint.eContents(), (EClassifier)UMLPackage.eINSTANCE.getNamedElement())) {
                if (!elt.getVisibility().equals((Object)visibility)) continue;
                ((IDiagramSynchronizer)synchronizer).removeRepresentation((EObject)elt, manager);
                elt.destroy();
            }
        }
    }

    public static Interface findInterfaceFromPackage(Package packageRef, final String classifierName) {
        return (Interface)UML2Util.findEObject((Iterator)packageRef.eAllContents(), (UML2Util.EObjectMatcher)new UML2Util.EObjectMatcher(){

            public boolean matches(EObject eObject) {
                if (eObject instanceof Interface) {
                    return classifierName.equals(((Classifier)eObject).getName());
                }
                return false;
            }
        });
    }

    public static Classifier findMatchingClassifier(ModelManager manager, ITranslationUnit translationUnit, String classifierName) {
        Package srcPackage = manager.getSourcePackage();
        Classifier matchingClassifier = ModelUtil.findClassifierInPackage(srcPackage, classifierName);
        if (translationUnit.isHeaderUnit() && matchingClassifier == null) {
            matchingClassifier = (Interface)srcPackage.getPackagedElement(classifierName, false, UMLPackage.Literals.INTERFACE, true);
        } else if (translationUnit.isSourceUnit() && (matchingClassifier == null || matchingClassifier instanceof Interface)) {
            matchingClassifier = (Class)srcPackage.getPackagedElement(classifierName, false, UMLPackage.Literals.CLASS, true);
        }
        return matchingClassifier;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        ADD,
        REMOVE,
        MODIFY;

    }
}

