/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTSignatureUtil;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.umlgen.reverse.c.internal.beans.FunctionParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ASTUtil {
    private ASTUtil() {
    }

    public static List<FunctionParameter> collectParameterInformation(IASTDeclarator declarator) {
        String[] paramSignature = ASTSignatureUtil.getParameterSignatureArray((IASTDeclarator)declarator);
        ArrayList<FunctionParameter> fctParams = new ArrayList<FunctionParameter>();
        int nbParams = 0;
        IASTNode[] iASTNodeArray = declarator.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode node = iASTNodeArray[n2];
            if (node instanceof IASTParameterDeclaration) {
                IASTParameterDeclaration paramDecl = (IASTParameterDeclaration)node;
                FunctionParameter newParam = new FunctionParameter();
                String type = paramSignature[nbParams];
                if (type.startsWith("const ")) {
                    type = type.replaceFirst("const\\s+", "");
                    newParam.setConst(true);
                }
                if ("".equals(type)) {
                    newParam.setType(paramDecl.getDeclarator().getName().toString());
                } else {
                    newParam.setName(paramDecl.getDeclarator().getName().toString());
                    newParam.setType(type.replaceAll("\\s", ""));
                }
                if (paramDecl.getDeclarator().getInitializer() != null) {
                    newParam.setInitializer(paramDecl.getDeclarator().getInitializer().getRawSignature());
                }
                fctParams.add(newParam);
                ++nbParams;
            }
            ++n2;
        }
        return fctParams;
    }

    public static String computeName(IASTPreprocessorMacroDefinition macro) {
        StringBuilder result = new StringBuilder();
        result.append(macro.getName().getSimpleID());
        if (macro instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
            IASTPreprocessorFunctionStyleMacroDefinition fctMacro = (IASTPreprocessorFunctionStyleMacroDefinition)macro;
            result.append('(');
            boolean needComma = false;
            IASTFunctionStyleMacroParameter[] iASTFunctionStyleMacroParameterArray = fctMacro.getParameters();
            int n = iASTFunctionStyleMacroParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTFunctionStyleMacroParameter param = iASTFunctionStyleMacroParameterArray[n2];
                if (needComma) {
                    result.append(", ");
                }
                result.append(param.getParameter());
                needComma = true;
                ++n2;
            }
            result.append(')');
        }
        return result.toString();
    }

    public static String computeName(IASTSimpleDeclaration declaration, String toMatch) {
        IASTDeclarator[] iASTDeclaratorArray = declaration.getDeclarators();
        int n = iASTDeclaratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclarator declarator = iASTDeclaratorArray[n2];
            if (declarator.getRawSignature().contains(toMatch)) {
                return ASTUtil.computeName(declarator);
            }
            ++n2;
        }
        return "";
    }

    public static String computeName(IASTDeclarator declarator) {
        String name = declarator.getRawSignature();
        if (name.indexOf("=") > -1) {
            name = name.substring(0, name.indexOf("="));
        }
        return name.replaceAll("\\*", "").trim();
    }

    public static String computeType(IASTSimpleDeclaration declaration) {
        String result = null;
        result = declaration == null ? "" : (declaration.getDeclSpecifier() instanceof IASTEnumerationSpecifier ? ((IASTEnumerationSpecifier)declaration.getDeclSpecifier()).getName().toString() : ASTUtil.computeType(declaration.getDeclarators()[0]));
        return result;
    }

    private static String computeType(IASTDeclarator declarator) {
        String type = ASTSignatureUtil.getSignature((IASTDeclarator)declarator);
        type = type.replaceAll("\\[\\]", "");
        type = type.replaceFirst("static\\s+", "");
        type = type.replaceFirst("register\\s+", "");
        type = type.replaceFirst("volatile\\s+", "");
        type = type.replaceFirst("extern\\s+", "");
        type = type.replaceFirst("const\\s+", "");
        type = type.replaceAll("\\s+\\*", "*");
        return type.trim();
    }
}

