/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.java;

import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ui.JavadocContentAccess;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.umlgen.reverse.java.Java2UMLConverter;
import org.eclipse.umlgen.reverse.java.JavaReverseCUVisitor;
import org.eclipse.umlgen.reverse.java.internal.ReversePlugin;
import org.eclipse.umlgen.reverse.java.logging.Java2UMLLogListener;
import org.eclipse.umlgen.reverse.java.logging.LogUtils;
import org.eclipse.umlgen.reverse.java.preferencesStore.Java2UMLPreferencesStoreManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJava2UMLConverter {
    protected static final String[] PRIMITIVE_TYPES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "Boolean", "Integer", "String", "UnlimitedNatural"};
    private static final String JAVA_REVERSER_DOC = "http://www.eclipse.org/umlgen/reverse/java/doc";
    private static final String BEHAVIOUR_LANGUAGE = "JAVA";
    protected String[] importList;
    protected Resource emfResource;
    protected String modelName;
    protected VisibilityKind visibility = VisibilityKind.PUBLIC_LITERAL;
    protected IJavaProject javaProject;
    protected HashMap<String, Type> typeMap = new HashMap();
    protected ILog logger = ReversePlugin.getDefault().getLog();
    protected List<String> portList;
    protected List<String> stateList;
    Package umlLibrary;
    Package javaLibrary;

    public void setVisibility(VisibilityKind visibility) {
        this.visibility = visibility;
    }

    public VisibilityKind getVisibility() {
        return this.visibility;
    }

    public void setImportList(String[] importList) {
        this.importList = importList;
    }

    public static boolean isPrimitiveType(String name) {
        String[] stringArray = PRIMITIVE_TYPES;
        int n = PRIMITIVE_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Package convert(IJavaElement javaElement, ActivityGeneration actGen) throws CoreException {
        String path = null;
        IResource res = javaElement.getResource();
        path = res != null ? res.getLocation().toOSString() : javaElement.getPath().toString();
        File dir = new File(path);
        Java2UMLLogListener listener = new Java2UMLLogListener(dir, this.modelName);
        this.logger.addLogListener((ILogListener)listener);
        LogUtils.resetTabbing();
        if (this.emfResource == null) {
            this.throwCoreException("The resource can't be null.");
        }
        switch (javaElement.getElementType()) {
            case 2: {
                this.javaProject = (IJavaProject)javaElement;
                return this.doConvertion((IJavaProject)javaElement, actGen);
            }
            case 4: {
                this.javaProject = ((IPackageFragment)javaElement).getJavaProject();
                return this.doConvertion((IPackageFragment)javaElement, actGen);
            }
            case 3: {
                this.javaProject = ((IPackageFragmentRoot)javaElement).getJavaProject();
                return this.doConvertion((IPackageFragmentRoot)javaElement, actGen);
            }
        }
        return null;
    }

    private Package doConvertion(IPackageFragmentRoot packageModel, ActivityGeneration actGen) {
        Model model = null;
        for (EObject eObject : this.emfResource.getContents()) {
            if (!(eObject instanceof Model)) continue;
            if (((Model)eObject).getName() == null) {
                if (!"".equals(this.modelName) && this.modelName != null) continue;
                model = (Model)eObject;
                continue;
            }
            if (!((Model)eObject).getName().equals(this.modelName)) continue;
            model = (Model)eObject;
        }
        if (model == null) {
            model = UMLFactory.eINSTANCE.createModel();
            model.setName(this.modelName);
            this.emfResource.getContents().add((Object)model);
            LogUtils.logCreation(null, packageModel, model, null);
        }
        LogUtils.logMessage("First conversion pass");
        try {
            List<IJavaElement> fragments = Arrays.asList(packageModel.getChildren());
            for (IPackageFragment f : Iterables.filter(fragments, IPackageFragment.class)) {
                this.convert(model, f, actGen);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            LogUtils.logThrowable(e);
        }
        catch (CoreException e) {
            e.printStackTrace();
            LogUtils.logThrowable(e);
        }
        LogUtils.logMessage("Second pass : generating package usages");
        this.generatePackageUsages((Package)model);
        return model;
    }

    protected Package convert2Profile(IJavaElement javaElement, ActivityGeneration actGen) throws CoreException {
        return this.convert(javaElement, actGen);
    }

    public Model convert(Model model, IPackageFragment fragment, ActivityGeneration actGen) throws CoreException {
        LogUtils.logEntering(fragment, null);
        this.initializeModel((Package)model);
        Package packageObject = this.findOrCreatePackage((Package)model, fragment);
        LogUtils.logEntering(packageObject, null);
        this.createTypes(packageObject, fragment);
        this.initializeTypes(this.typeMap, packageObject, fragment);
        this.createAssociations(packageObject);
        if (actGen == ActivityGeneration.ALL || actGen == ActivityGeneration.ANNOTATED) {
            LogUtils.logMessage("Generic post-process : Creating activities");
            this.generateActivities(packageObject, fragment, actGen == ActivityGeneration.ANNOTATED);
        }
        LogUtils.logExiting();
        LogUtils.logExiting();
        return model;
    }

    protected void generateActivities(Package packageObject, IPackageFragment fragment, boolean isAnnotatedOnly) {
        try {
            IJavaElement[] iJavaElementArray = fragment.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement javaElement = iJavaElementArray[n2];
                if (javaElement instanceof org.eclipse.jdt.internal.core.CompilationUnit) {
                    LogUtils.logEntering(javaElement, "Creating activities");
                    org.eclipse.jdt.internal.core.CompilationUnit unit = (org.eclipse.jdt.internal.core.CompilationUnit)javaElement;
                    ASTParser parser = ASTParser.newParser((int)3);
                    parser.setSource((ICompilationUnit)unit);
                    Hashtable options = JavaCore.getOptions();
                    JavaCore.setComplianceOptions((String)"1.5", (Map)options);
                    parser.setCompilerOptions((Map)options);
                    CompilationUnit result = (CompilationUnit)parser.createAST(null);
                    result.accept((ASTVisitor)new JavaReverseCUVisitor(packageObject, isAnnotatedOnly, null));
                    LogUtils.logExiting();
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            LogUtils.logThrowable(e);
            LogUtils.logExiting();
        }
    }

    protected abstract void initializeTypes(HashMap<String, Type> var1, Package var2, IPackageFragment var3) throws JavaModelException;

    protected abstract HashMap<String, Type> processTypes(Namespace var1, IType[] var2) throws JavaModelException;

    protected abstract Package findOrCreateRootPackage();

    protected abstract void initializeModel(Package var1) throws CoreException;

    private Package doConvertion(IJavaProject project, ActivityGeneration actGen) throws CoreException {
        Package packageObject;
        IPackageFragment fragment;
        IPackageFragment[] children;
        LogUtils.logEntering(project, null);
        Package model = this.findOrCreateRootPackage();
        this.initializeModel(model);
        LogUtils.logMessage("Creating types ");
        IPackageFragment[] iPackageFragmentArray = children = project.getPackageFragments();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            fragment = iPackageFragmentArray[n2];
            if (fragment.getCompilationUnits().length > 0) {
                LogUtils.logEntering(fragment, null);
                packageObject = this.findOrCreatePackage(model, fragment);
                if (packageObject != null) {
                    this.createTypes(packageObject, fragment);
                }
                LogUtils.logExiting();
            }
            ++n2;
        }
        LogUtils.logMessage("Initializing types");
        iPackageFragmentArray = children;
        n = children.length;
        n2 = 0;
        while (n2 < n) {
            fragment = iPackageFragmentArray[n2];
            if (fragment.getCompilationUnits().length > 0) {
                LogUtils.logEntering(fragment, null);
                packageObject = this.findOrCreatePackage(model, fragment);
                if (packageObject != null) {
                    this.initializeTypes(this.typeMap, packageObject, fragment);
                }
                LogUtils.logExiting();
            }
            ++n2;
        }
        LogUtils.logMessage("Generic post-process : Creating usages and associations");
        iPackageFragmentArray = children;
        n = children.length;
        n2 = 0;
        while (n2 < n) {
            fragment = iPackageFragmentArray[n2];
            if (fragment.getCompilationUnits().length > 0) {
                LogUtils.logEntering(fragment, null);
                packageObject = this.findOrCreatePackage(model, fragment);
                if (!this.avoidDependenciesComputing() && packageObject != null) {
                    this.createUsages(packageObject);
                }
                if (packageObject != null) {
                    this.createAssociations(packageObject);
                }
                LogUtils.logExiting();
            }
            ++n2;
        }
        LogUtils.logMessage("Generic post-process : Creating activities");
        if (actGen == ActivityGeneration.ALL || actGen == ActivityGeneration.ANNOTATED) {
            iPackageFragmentArray = children;
            n = children.length;
            n2 = 0;
            while (n2 < n) {
                fragment = iPackageFragmentArray[n2];
                if (fragment.getCompilationUnits().length > 0) {
                    LogUtils.logEntering(fragment, null);
                    packageObject = this.findOrCreatePackage(model, fragment);
                    if (packageObject != null) {
                        this.generateActivities(packageObject, fragment, actGen == ActivityGeneration.ANNOTATED);
                    }
                    LogUtils.logExiting();
                }
                ++n2;
            }
        }
        return model;
    }

    private Model doConvertion(IPackageFragment packageModel, ActivityGeneration actGen) throws CoreException {
        Model model = null;
        for (EObject eObject : this.emfResource.getContents()) {
            if (!(eObject instanceof Model)) continue;
            if (((Model)eObject).getName() == null) {
                if (this.modelName != null && !"".equals(this.modelName)) continue;
                model = (Model)eObject;
                continue;
            }
            if (!((Model)eObject).getName().equals(this.modelName)) continue;
            model = (Model)eObject;
        }
        if (model == null) {
            model = UMLFactory.eINSTANCE.createModel();
            model.setName(this.modelName);
            this.emfResource.getContents().add((Object)model);
            LogUtils.logCreation(null, packageModel, model, null);
        }
        LogUtils.logMessage("First conversion pass");
        this.convert(model, packageModel, actGen);
        LogUtils.logMessage("Second pass : generating package usages");
        this.generatePackageUsages((Package)model);
        return model;
    }

    private void generatePackageUsages(Package umlPack) {
        this.createUsages(umlPack);
        for (EObject obj : umlPack.getPackagedElements()) {
            if (!(obj instanceof Package)) continue;
            this.generatePackageUsages((Package)obj);
        }
    }

    protected String resolveTypeInContext(Element element, IType type, String fullyQualifiedName) {
        if (Java2UMLConverter.isPrimitiveType(fullyQualifiedName)) {
            return fullyQualifiedName;
        }
        try {
            IType parentType;
            String[][] ancestorType = type.resolveType(fullyQualifiedName);
            if (ancestorType != null && ancestorType[0] != null) {
                if (ancestorType[0][0] == null || ancestorType[0][0].length() == 0) {
                    return ancestorType[0][1];
                }
                return ancestorType[0][0].concat(".").concat(ancestorType[0][1]);
            }
            if (type.getParent().getElementType() == 7 && (ancestorType = (parentType = (IType)type.getParent()).resolveType(fullyQualifiedName)) != null && ancestorType[0] != null) {
                if (ancestorType[0][0] == null) {
                    return ancestorType[0][1];
                }
                return ancestorType[0][0].concat(".").concat(ancestorType[0][1]);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            LogUtils.logThrowable(e);
        }
        if (type.getCompilationUnit() != null) {
            try {
                IImportDeclaration[] allImports;
                IImportDeclaration[] iImportDeclarationArray = allImports = type.getCompilationUnit().getImports();
                int n = allImports.length;
                int n2 = 0;
                while (n2 < n) {
                    String importPackage;
                    String invisibleImport;
                    IImportDeclaration importDeclaration = iImportDeclarationArray[n2];
                    if (importDeclaration.getElementName().endsWith("*") && (invisibleImport = this.findPossibleExistingType(element, importPackage = importDeclaration.getElementName().substring(0, importDeclaration.getElementName().lastIndexOf(".")), fullyQualifiedName)) != null) {
                        return importPackage.concat(".").concat(invisibleImport);
                    }
                    if (importDeclaration.getElementName().endsWith(fullyQualifiedName)) {
                        return importDeclaration.getElementName();
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                LogUtils.logThrowable(e);
            }
        }
        return fullyQualifiedName;
    }

    private String findPossibleExistingType(Element element, String packageName, String typeName) {
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        Model parent = element.getModel();
        Package packageObject = null;
        int tokensCount = tokenizer.countTokens();
        int i = 0;
        while (i < tokensCount && parent != null) {
            String pathElementName = tokenizer.nextToken();
            packageObject = parent.getNestedPackage(pathElementName, false, UMLPackage.Literals.PACKAGE, false);
            parent = packageObject;
            ++i;
        }
        if (parent != null && parent.getOwnedType(typeName, false, UMLPackage.Literals.TYPE, false) != null) {
            return typeName;
        }
        return null;
    }

    protected Package findOrCreatePackage(Package model, IPackageFragment fragment) {
        String qualifiedName = fragment.getElementName();
        return this.findOrCreatePackage(model, qualifiedName);
    }

    protected Package findOrCreatePackage(Package model, String packageQName) {
        Package packageObject = this.findPackageInModel(model, packageQName);
        if (packageObject == null && model != null) {
            for (Package importedPackage : model.getImportedPackages()) {
                packageObject = this.findPackageInModel(importedPackage, packageQName);
                if (packageObject == null) continue;
                return packageObject;
            }
        }
        if (packageObject == null && model != null) {
            packageObject = this.createPackage(model, packageQName);
            LogUtils.logCreation(null, null, packageObject, null);
        }
        return packageObject;
    }

    protected Package findPackageInModel(Package model, String packageQName) {
        StringTokenizer tokenizer = new StringTokenizer(packageQName, ".");
        Package parent = model;
        Package packageObject = model;
        while (tokenizer.hasMoreTokens() && packageObject != null) {
            String packageName = tokenizer.nextToken();
            parent = packageObject = parent.getNestedPackage(packageName);
        }
        return packageObject;
    }

    protected Package createPackage(Package model, String packageQName) {
        StringTokenizer tokenizer = new StringTokenizer(packageQName, ".");
        Package parent = model;
        Package packageObject = model;
        while (tokenizer.hasMoreTokens()) {
            String packageName = tokenizer.nextToken();
            packageObject = parent.getNestedPackage(packageName);
            if (packageObject == null) {
                packageObject = parent.createNestedPackage(packageName);
                LogUtils.logCreation(null, packageName, packageObject, " Created from AbstractJava2UMLConverter");
            }
            parent = packageObject;
        }
        return packageObject;
    }

    protected Type createDataType(Package model, String qualifiedName) {
        Type type = model.getOwnedType(qualifiedName, false, UMLPackage.Literals.TYPE, false);
        if (AbstractJava2UMLConverter.isPrimitiveType(qualifiedName)) {
            if (type == null && this.umlLibrary != null) {
                type = this.umlLibrary.getOwnedType(qualifiedName);
            }
            if (type == null && this.javaLibrary != null) {
                type = this.javaLibrary.getOwnedType(qualifiedName);
            }
        }
        if (type != null) {
            return type;
        }
        StringTokenizer tokenizer = new StringTokenizer(qualifiedName, ".");
        Package parent = model;
        Package packageObject = model;
        Classifier classifier = null;
        int tokensCount = tokenizer.countTokens();
        int i = 0;
        while (i < tokensCount - 1) {
            String packageName = tokenizer.nextToken();
            if (i == tokensCount - 2) {
                classifier = (Classifier)parent.getMember(packageName, false, UMLPackage.Literals.CLASSIFIER);
            }
            if (classifier == null) {
                packageObject = parent.getNestedPackage(packageName, false, UMLPackage.Literals.PACKAGE, true);
            }
            parent = packageObject;
            ++i;
        }
        String dataTypeName = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1, qualifiedName.length());
        if (this.importList != null) {
            String[] stringArray = this.importList;
            int n = this.importList.length;
            int n2 = 0;
            while (n2 < n) {
                String imp = stringArray[n2];
                try {
                    Package lib = this.load(URI.createURI((String)imp));
                    if (lib instanceof Model) {
                        type = lib.getOwnedType(qualifiedName);
                        if (type != null) {
                            model.createElementImport((PackageableElement)type);
                            return type;
                        }
                        if (lib.getOwnedMember(dataTypeName) instanceof Type) {
                            return (Type)lib.getOwnedMember(dataTypeName);
                        }
                        EList liste = lib.getNestedPackages();
                        for (PackageableElement pack : liste) {
                            type = ((Package)pack).getOwnedType(dataTypeName);
                            if (type == null) continue;
                            if (model.getElementImport((PackageableElement)type) != null) {
                                model.createElementImport((PackageableElement)type);
                            }
                            return type;
                        }
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    LogUtils.logThrowable(e);
                }
                ++n2;
            }
        }
        if (type == null) {
            type = (DataType)parent.getOwnedType(dataTypeName, false, UMLPackage.Literals.DATA_TYPE, true);
        }
        return type;
    }

    protected Type findTypeInModel(Package model, String qualifiedName) {
        Type type = model.getOwnedType(qualifiedName, false, UMLPackage.Literals.TYPE, false);
        if (type != null) {
            return type;
        }
        StringTokenizer tokenizer = new StringTokenizer(qualifiedName, ".");
        Package parent = model;
        Package packageObject = model;
        Classifier classifier = null;
        int tokensCount = tokenizer.countTokens();
        int i = 0;
        while (i < tokensCount - 1) {
            String packageName = tokenizer.nextToken();
            if (i == tokensCount - 2) {
                classifier = (Classifier)parent.getMember(packageName, false, UMLPackage.Literals.CLASSIFIER);
            }
            if (classifier == null && (packageObject = parent.getNestedPackage(packageName, false, UMLPackage.Literals.PACKAGE, false)) == null) {
                return null;
            }
            parent = packageObject;
            ++i;
        }
        String dataTypeName = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1, qualifiedName.length());
        type = classifier != null ? (Type)classifier.getOwnedMember(dataTypeName, false, UMLPackage.Literals.TYPE) : parent.getOwnedType(dataTypeName, false, UMLPackage.Literals.CLASSIFIER, false);
        return type;
    }

    protected Package loadUML2Model(URI uri) throws CoreException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Package pPackage = null;
        try {
            Resource resource = resourceSet.getResource(uri, true);
            pPackage = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.eINSTANCE.getPackage());
        }
        catch (WrappedException we) {
            LogUtils.logThrowable(we);
            this.throwCoreException(we.getMessage());
        }
        return pPackage;
    }

    protected boolean isQualifiedName(String name) {
        return name.indexOf(".") != -1;
    }

    /*
     * Unable to fully structure code
     */
    protected Package findRootPackage(Package packageObject) {
        parentPackage = (Package)packageObject.getOwner();
        if (parentPackage != null) ** GOTO lbl5
        return packageObject;
lbl-1000:
        // 1 sources

        {
            parentPackage = (Package)parentPackage.getOwner();
lbl5:
            // 2 sources

            ** while (parentPackage.getOwner() != null)
        }
lbl6:
        // 1 sources

        return parentPackage;
    }

    protected Type findinImportPackages(Package model, String typeName) {
        String find = " findinImportPackages ";
        if ("void".equals(typeName) || model == null) {
            LogUtils.logCreation(null, model, typeName, String.valueOf(find) + typeName);
            return null;
        }
        PackageableElement importedMember = model.getImportedMember(typeName);
        if (importedMember instanceof Type) {
            LogUtils.logCreation(null, model, importedMember, String.valueOf(find) + typeName);
            return (Type)importedMember;
        }
        for (Package importedPackage : model.getImportedPackages()) {
            Type type = this.findTypeInModel(importedPackage, typeName);
            if (type != null) {
                LogUtils.logCreation(null, model, type, String.valueOf(find) + typeName);
                return type;
            }
            for (Package pack : importedPackage.getNestedPackages()) {
                NamedElement elt = pack.getOwnedMember(typeName);
                if (!(elt instanceof Type)) continue;
                LogUtils.logCreation(null, model, elt, String.valueOf(find) + typeName);
                return (Type)elt;
            }
        }
        LogUtils.logCreation(null, model, null, String.valueOf(find) + typeName);
        return null;
    }

    protected Type findOrCreateType(Package packageObject, String typeName) {
        Type type = this.typeMap.get(typeName);
        if (type == null && packageObject.getModel() != null) {
            type = this.findTypeInModel((Package)packageObject.getModel(), typeName);
        }
        if (type == null) {
            type = this.findinImportPackages((Package)packageObject.getModel(), typeName);
        }
        if (type == null) {
            type = this.findGenericType((Package)packageObject.getModel(), typeName);
        }
        if (typeName != null && !"void".equals(typeName)) {
            if (AbstractJava2UMLConverter.isPrimitiveType(typeName)) {
                if (type == null && this.umlLibrary != null) {
                    type = this.umlLibrary.getOwnedType(typeName);
                }
                if (type == null && this.javaLibrary != null) {
                    type = this.javaLibrary.getOwnedType(typeName);
                }
            }
            if (type == null) {
                type = this.createNotFoundDataType((Package)packageObject.getModel(), typeName);
            }
        }
        return type;
    }

    protected Type createNotFoundDataType(Package packageObject, String typeName) {
        Type type = this.createDataType((Package)packageObject.getModel(), typeName);
        return type;
    }

    public Type muteDataType(Type existing, Type newElement) {
        if (newElement instanceof DataType) {
            return (DataType)existing;
        }
        ECrossReferenceAdapter crossAdpater = CacheAdapter.getCrossReferenceAdapter((Notifier)existing);
        if (crossAdpater != null) {
            for (EStructuralFeature.Setting aSetting : crossAdpater.getInverseReferences((EObject)existing, true)) {
                EReference ref;
                EObject eObject = aSetting.getEObject();
                if (aSetting.getEStructuralFeature() instanceof EReference) {
                    ref = (EReference)aSetting.getEStructuralFeature();
                    if (ref.isContainment() || ref.isUnsettable() || !ref.isChangeable()) continue;
                    if (ref.isMany() && !ref.isDerived()) {
                        BasicEList candidates = new BasicEList((Collection)((EList)eObject.eGet(aSetting.getEStructuralFeature(), true)));
                        if (!candidates.contains((Object)existing)) continue;
                        candidates.set(candidates.indexOf((Object)existing), (Object)newElement);
                        eObject.eSet((EStructuralFeature)ref, (Object)candidates);
                        continue;
                    }
                    if (!eObject.eGet(aSetting.getEStructuralFeature(), true).equals(existing)) continue;
                    eObject.eSet(aSetting.getEStructuralFeature(), (Object)newElement);
                    continue;
                }
                if (!(aSetting.getEStructuralFeature() instanceof EAttribute) || !eObject.eGet((EStructuralFeature)(ref = (EAttribute)aSetting.getEStructuralFeature()), true).equals(existing) || ref.isUnsettable() || !ref.isChangeable()) continue;
                eObject.eSet(aSetting.getEStructuralFeature(), (Object)newElement);
            }
        }
        return newElement;
    }

    protected Type findGenericType(Package packageObject, String interfaceName) {
        int indexOf = interfaceName.indexOf(60);
        if (indexOf > 0) {
            String name = interfaceName.substring(0, indexOf);
            return this.findTypeInModel(packageObject, name);
        }
        return null;
    }

    protected void createAssociations(Package packageObject) throws JavaModelException {
        ArrayList workingCopy = new ArrayList(packageObject.getPackagedElements());
        for (PackageableElement element : workingCopy) {
            Type targetType;
            if (element instanceof Interface) {
                LogUtils.logEntering(element, "Creating associations");
                Interface interfaceObject = (Interface)element;
                for (Property property : interfaceObject.getOwnedAttributes()) {
                    targetType = property.getType();
                    if (!(targetType instanceof StructuredClassifier) && !(targetType instanceof Interface) || targetType.getOwner() instanceof TemplateParameter) continue;
                    this.createAssociation(property);
                }
                LogUtils.logExiting();
            }
            if (!(element instanceof StructuredClassifier)) continue;
            LogUtils.logEntering(element, "Creating associations");
            StructuredClassifier classifierObject = (StructuredClassifier)element;
            for (Property property : classifierObject.getOwnedAttributes()) {
                targetType = property.getType();
                if (!(targetType instanceof StructuredClassifier) && !(targetType instanceof Interface) || targetType.getOwner() instanceof TemplateParameter) continue;
                this.createAssociation(property);
            }
            LogUtils.logExiting();
        }
    }

    protected void createAssociation(Property property) {
        if (property.getAssociation() == null) {
            Property opposite = this.foundOpposite(property);
            Element propOwner = property.getOwner();
            Association association = UMLFactory.eINSTANCE.createAssociation();
            association.getMemberEnds().add((Object)property);
            if (opposite != null) {
                association.getMemberEnds().add((Object)opposite);
                association.setName(String.valueOf(property.getName()) + "_" + opposite.getName());
            } else {
                Property target = association.createOwnedEnd("target", (Type)propOwner);
                association.setName(String.valueOf(property.getName()) + "_" + target.getName());
            }
            property.getNearestPackage().getPackagedElements().add((Object)association);
            LogUtils.logCreation(null, null, property, null);
        }
    }

    protected Property foundOpposite(Property source) {
        Property target = null;
        Type propType = source.getType();
        Element propOwner = source.getOwner();
        if (propType instanceof StructuredClassifier || propType instanceof Interface) {
            EList properties = null;
            if (propType instanceof StructuredClassifier) {
                properties = ((StructuredClassifier)propType).getOwnedAttributes();
            }
            if (propType instanceof Interface) {
                properties = ((Interface)propType).getOwnedAttributes();
            }
            Iterator it = properties.iterator();
            while (it.hasNext() && target == null) {
                Property prop = (Property)it.next();
                if (prop == source || !propOwner.equals(prop.getType())) continue;
                target = prop;
            }
        }
        return target;
    }

    protected void createTypes(Package packageObject, IPackageFragment fragment) throws JavaModelException {
        IJavaElement[] iJavaElementArray = fragment.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            if (element instanceof ICompilationUnit) {
                LogUtils.logEntering(element, "Creating types");
                this.typeMap.putAll(this.processTypes((Namespace)packageObject, ((ICompilationUnit)element).getTypes()));
                LogUtils.logExiting();
            } else if (element instanceof IClassFile) {
                LogUtils.logEntering(element, "Creating types");
                IClassFile cf = (IClassFile)element;
                this.typeMap.putAll(this.processTypes((Namespace)packageObject, new IType[]{cf.getType()}));
                LogUtils.logExiting();
            }
            ++n2;
        }
    }

    protected Classifier createTypeInPackage(Namespace packageObject, IType type) throws JavaModelException {
        if (type.isInterface()) {
            Interface interfaceObject = UMLFactory.eINSTANCE.createInterface();
            if (type.isAnnotation()) {
                interfaceObject.setName("@" + type.getElementName());
            } else {
                interfaceObject.setName(type.getElementName());
            }
            LogUtils.logCreation(null, type, interfaceObject, null);
            this.createTemplateParameters(type, (Classifier)interfaceObject);
            this.update((NamedElement)interfaceObject, type.getFlags());
            this.addToContainment(packageObject, (Classifier)interfaceObject);
            return interfaceObject;
        }
        if (this.isEnumeration(type)) {
            Enumeration enumeration = UMLFactory.eINSTANCE.createEnumeration();
            enumeration.setName(type.getElementName());
            LogUtils.logCreation(null, type, enumeration, null);
            this.update((NamedElement)enumeration, type.getFlags());
            this.addToContainment(packageObject, (Classifier)enumeration);
            return enumeration;
        }
        Class classObject = UMLFactory.eINSTANCE.createClass();
        classObject.setName(type.getElementName());
        LogUtils.logCreation(null, type, classObject, null);
        this.createTemplateParameters(type, (Classifier)classObject);
        this.update((NamedElement)classObject, type.getFlags());
        this.addToContainment(packageObject, (Classifier)classObject);
        return classObject;
    }

    protected boolean isEnumeration(IType type) throws JavaModelException {
        if (type.isEnum()) {
            return true;
        }
        if (type.isClass() && type.getMethods().length == 0) {
            IField[] iFieldArray = type.getFields();
            int n = iFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IField enum0 = iFieldArray[n2];
                if (!Flags.isPublic((int)enum0.getFlags())) {
                    return false;
                }
                if (!Flags.isStatic((int)enum0.getFlags())) {
                    return false;
                }
                if (!Flags.isFinal((int)enum0.getFlags())) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    protected void createTemplateParameters(IType type, Classifier classObject) throws JavaModelException {
        LogUtils.logEntering(type, "Creating template parameters");
        ITypeParameter[] typeParameters = type.getTypeParameters();
        if (typeParameters.length > 0) {
            TemplateSignature templateSignature = classObject.createOwnedTemplateSignature();
            ITypeParameter[] iTypeParameterArray = typeParameters;
            int n = typeParameters.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeParameter typeParameter = iTypeParameterArray[n2];
                ClassifierTemplateParameter classifierTemplateParameter = UMLFactory.eINSTANCE.createClassifierTemplateParameter();
                templateSignature.getOwnedParameters().add((Object)classifierTemplateParameter);
                ParameterableElement parameteredElement = classifierTemplateParameter.createOwnedParameteredElement(UMLPackage.Literals.CLASS);
                if (parameteredElement instanceof Class) {
                    Class clazz = (Class)parameteredElement;
                    clazz.setName(typeParameter.getElementName());
                }
                LogUtils.logCreation(type, typeParameter, parameteredElement, null);
                ++n2;
            }
        }
        LogUtils.logExiting();
    }

    protected void addToContainment(Namespace packageObject, Classifier classifierObject) {
        if (packageObject instanceof Package) {
            Package po = (Package)packageObject;
            po.getPackagedElements().add((Object)classifierObject);
            return;
        }
        if (packageObject instanceof Class) {
            Class clazz = (Class)packageObject;
            clazz.getNestedClassifiers().add((Object)classifierObject);
            return;
        }
        if (packageObject instanceof Interface) {
            Interface i = (Interface)packageObject;
            i.getNestedClassifiers().add((Object)classifierObject);
            return;
        }
    }

    protected Type findTemplateParameter(Element element, String fieldName) {
        for (Element child : element.allOwnedElements()) {
            if (child instanceof Classifier) {
                Classifier classifier = (Classifier)child;
                if (!classifier.getName().equals(fieldName)) continue;
                return classifier;
            }
            if (!(child instanceof Operation)) continue;
            Operation cfr_ignored_0 = (Operation)child;
        }
        return null;
    }

    protected void update(NamedElement element, int flags) throws JavaModelException {
        Feature feature;
        BehavioralFeature bf;
        if (Flags.isAbstract((int)flags)) {
            if (element instanceof Classifier) {
                Classifier cl = (Classifier)element;
                cl.setIsAbstract(true);
            } else if (element instanceof BehavioralFeature) {
                bf = (BehavioralFeature)element;
                bf.setIsAbstract(true);
            }
        }
        if (Flags.isStatic((int)flags)) {
            if (element instanceof BehavioralFeature) {
                bf = (BehavioralFeature)element;
                bf.setIsStatic(true);
            } else if (element instanceof Feature) {
                feature = (Feature)element;
                feature.setIsStatic(true);
            }
        }
        if (Flags.isFinal((int)flags)) {
            if (element instanceof BehavioralFeature) {
                bf = (BehavioralFeature)element;
                bf.setIsLeaf(true);
            } else if (element instanceof Feature) {
                feature = (Feature)element;
                feature.setIsLeaf(true);
            }
        }
        if (Flags.isPrivate((int)flags)) {
            element.setVisibility(VisibilityKind.PRIVATE_LITERAL);
        } else if (Flags.isProtected((int)flags)) {
            element.setVisibility(VisibilityKind.PROTECTED_LITERAL);
        } else if (Flags.isPublic((int)flags)) {
            element.setVisibility(VisibilityKind.PUBLIC_LITERAL);
        } else if (Flags.isPackageDefault((int)flags)) {
            if (element instanceof Property) {
                Property property = (Property)element;
                if (property.getOwner() instanceof Interface) {
                    Interface i = (Interface)property.getOwner();
                    property.setVisibility(i.getVisibility());
                }
            } else if (element instanceof Operation) {
                Operation op = (Operation)element;
                if (op.getOwner() instanceof Interface) {
                    Interface i = (Interface)op.getOwner();
                    op.setVisibility(i.getVisibility());
                }
            } else {
                element.setVisibility(VisibilityKind.PACKAGE_LITERAL);
            }
        }
    }

    protected String getName(IPackageFragment fragment) {
        String name = "";
        String fullName = fragment.getElementName();
        int dotIndex = fullName.lastIndexOf(46);
        if (dotIndex > 0) {
            name = fullName.substring(dotIndex + 1);
        }
        return name;
    }

    protected boolean canBeImported(IMember member) throws JavaModelException {
        int flag = member.getFlags();
        switch (this.visibility) {
            case PRIVATE_LITERAL: {
                return true;
            }
            case PROTECTED_LITERAL: {
                return Flags.isPublic((int)flag) || Flags.isPackageDefault((int)flag) || Flags.isProtected((int)flag);
            }
            case PACKAGE_LITERAL: {
                return Flags.isPublic((int)flag) || Flags.isPackageDefault((int)flag);
            }
        }
        return Flags.isPublic((int)flag);
    }

    protected boolean isStrucDiag(IMember member) throws JavaModelException {
        boolean ret = false;
        if ("initPortsGenerator".equals(member.getElementName())) {
            ret = true;
        } else if ("makeConnections".equals(member.getElementName())) {
            ret = true;
        }
        return ret;
    }

    protected String getJavadoc(IMember member) throws JavaModelException {
        Reader lReader = JavadocContentAccess.getContentReader((IMember)member, (boolean)true);
        if (lReader != null) {
            try {
                int c;
                BufferedReader in = new BufferedReader(lReader);
                StringBuffer javadoc = new StringBuffer();
                boolean lReturnAdded = false;
                while ((c = in.read()) != -1) {
                    if (c == 10 || c == 13) {
                        if (lReturnAdded) continue;
                        javadoc.append(System.getProperty("line.separator"));
                        lReturnAdded = true;
                        continue;
                    }
                    lReturnAdded = false;
                    javadoc.append((char)c);
                }
                in.close();
                return javadoc.toString();
            }
            catch (IOException e) {
                LogUtils.logThrowable(e);
            }
        }
        return "";
    }

    protected Operation findOperation(Classifier classifier, IMethod method) {
        try {
            BasicEList paramList = new BasicEList();
            String[] stringArray = method.getParameterNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                paramList.add((Object)param);
                ++n2;
            }
            BasicEList paramTypeList = new BasicEList();
            String[] stringArray2 = method.getParameterTypes();
            int n3 = stringArray2.length;
            n = 0;
            while (n < n3) {
                String param = stringArray2[n];
                String typeWithoutArray = Signature.getElementType((String)param);
                String typeName = Signature.toString((String)Signature.getTypeErasure((String)typeWithoutArray));
                typeName = this.resolveTypeInContext((Element)classifier, method.getDeclaringType(), typeName);
                Type paramType = this.findOrCreateType(classifier.getNearestPackage(), typeName);
                if (paramType != null) {
                    paramTypeList.add((Object)paramType);
                }
                ++n;
            }
            Operation op = null;
            if (classifier instanceof Class) {
                op = ((Class)classifier).getOwnedOperation(method.getElementName(), (EList)paramList, (EList)paramTypeList, false, false);
                if (op != null) {
                    op.setClass_((Class)classifier);
                }
                return op;
            }
            if (classifier instanceof Interface) {
                op = ((Interface)classifier).getOwnedOperation(method.getElementName(), (EList)paramList, (EList)paramTypeList, false, false);
                if (op != null) {
                    op.setInterface((Interface)classifier);
                }
                return op;
            }
            if (classifier instanceof DataType) {
                op = ((DataType)classifier).getOwnedOperation(method.getElementName(), (EList)paramList, (EList)paramTypeList, false, false);
                if (op != null) {
                    op.setDatatype((DataType)classifier);
                }
                return op;
            }
            if (classifier instanceof PrimitiveType) {
                ReversePlugin.log("The operation was not stored in the content of a Primitive Type : " + classifier.getName(), 4);
                op = ((PrimitiveType)classifier).getOwnedOperation(method.getElementName(), (EList)paramList, (EList)paramTypeList, false, false);
                if (op != null) {
                    op.setDatatype((DataType)((PrimitiveType)classifier));
                }
                return op;
            }
            if (classifier instanceof Enumeration) {
                ReversePlugin.log("The operation was not stored in the content of an Enumeration : " + classifier.getName(), 4);
                op = ((Enumeration)classifier).getOwnedOperation(method.getElementName(), (EList)paramList, (EList)paramTypeList, false, false);
                if (op != null) {
                    op.setDatatype((DataType)((Enumeration)classifier));
                }
                return op;
            }
            ReversePlugin.log("The operation was not stored in the content of : " + classifier.getName(), 4);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            LogUtils.logThrowable(e);
        }
        return null;
    }

    protected OpaqueBehavior createOpaqueBehavior(Operation operation, IMethod sourceMethod) {
        OpaqueBehavior opaque = UMLFactory.eINSTANCE.createOpaqueBehavior();
        opaque.setName(operation.getName());
        for (Parameter parameter : operation.getOwnedParameters()) {
            opaque.createOwnedParameter(parameter.getName(), parameter.getType());
        }
        opaque.setSpecification((BehavioralFeature)operation);
        opaque.setVisibility(operation.getVisibility());
        opaque.getLanguages().add((Object)BEHAVIOUR_LANGUAGE);
        try {
            String body = sourceMethod.getSource();
            int beginIndex = body.indexOf(123);
            int endIndex = body.lastIndexOf(125);
            if (beginIndex != -1 && endIndex != -1 && endIndex > beginIndex) {
                body = body.substring(beginIndex + 1, endIndex);
            }
            body = body.replaceAll(">", "&gt;");
            opaque.getBodies().add((Object)body);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            LogUtils.logThrowable(e);
        }
        return opaque;
    }

    protected void updateOpaqueBehaviorBody(OpaqueBehavior opaque, IMethod sourceMethod) {
        try {
            opaque.getBodies().remove(0);
            String body = sourceMethod.getSource();
            int beginIndex = body.indexOf(123);
            int endIndex = body.lastIndexOf(125);
            if (beginIndex != -1 && endIndex != -1 && endIndex > beginIndex) {
                body = body.substring(beginIndex + 1, endIndex);
            }
            opaque.getBodies().add((Object)body);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            LogUtils.logThrowable(e);
        }
    }

    protected Operation createOperation(Element element, IMethod method) throws JavaModelException {
        String methodName = method.getElementName();
        Operation operationObject = UMLFactory.eINSTANCE.createOperation();
        operationObject.setName(methodName);
        this.update((NamedElement)operationObject, method.getFlags());
        int flags = method.getFlags();
        operationObject.setIsAbstract(Flags.isAbstract((int)flags));
        operationObject.setIsStatic(Flags.isStatic((int)flags));
        this.attachJavadoc((Element)operationObject, (IMember)method);
        this.createParameters(element, operationObject, method);
        if (method.exists() && !method.isConstructor()) {
            this.createTemplateParameters(method, operationObject);
            String returnTypeSig = method.getReturnType();
            int arrayCount = Signature.getArrayCount((String)returnTypeSig);
            String returnTypeWithoutArray = Signature.getElementType((String)returnTypeSig);
            String returnTypeName = Signature.toString((String)Signature.getTypeErasure((String)returnTypeWithoutArray));
            Type returnType = this.findTemplateParameter(element, returnTypeName);
            if (returnType == null) {
                returnType = this.findTemplateParameter((Element)operationObject, returnTypeName);
            }
            if (returnType == null) {
                returnTypeName = this.resolveTypeInContext(element, method.getDeclaringType(), returnTypeName);
                returnType = this.findOrCreateType(element.getNearestPackage(), returnTypeName);
            }
            if (returnType != null) {
                Parameter parameter = UMLFactory.eINSTANCE.createParameter();
                parameter.setDirection(ParameterDirectionKind.RETURN_LITERAL);
                parameter.setType(returnType);
                if (arrayCount == 1) {
                    parameter.setUpper(-1);
                }
                operationObject.getOwnedParameters().add((Object)parameter);
            }
        }
        if (element instanceof Class) {
            operationObject.setClass_((Class)element);
        }
        if (element instanceof Interface) {
            operationObject.setInterface((Interface)element);
        }
        if (element instanceof DataType) {
            operationObject.setDatatype((DataType)element);
        }
        if (element instanceof PrimitiveType) {
            operationObject.setDatatype((DataType)((PrimitiveType)element));
        }
        if (element instanceof Enumeration) {
            ReversePlugin.log("The operation was not stored in the content of an Enumeration : " + ((Enumeration)element).getName(), 4);
            operationObject.setDatatype((DataType)((Enumeration)element));
        }
        return operationObject;
    }

    private void createTemplateParameters(IMethod method, Operation operationObject) throws JavaModelException {
        ITypeParameter[] typeParameters;
        ITypeParameter[] iTypeParameterArray = typeParameters = method.getTypeParameters();
        int n = typeParameters.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeParameter typeParameter = iTypeParameterArray[n2];
            TemplateSignature templateSignature = operationObject.getOwnedTemplateSignature();
            if (templateSignature == null) {
                templateSignature = operationObject.createOwnedTemplateSignature();
                ClassifierTemplateParameter classifierTemplateParameter = UMLFactory.eINSTANCE.createClassifierTemplateParameter();
                templateSignature.getOwnedParameters().add((Object)classifierTemplateParameter);
                ParameterableElement parameteredElement = classifierTemplateParameter.createOwnedParameteredElement(UMLPackage.Literals.CLASS);
                if (parameteredElement instanceof Class) {
                    Class clazz = (Class)parameteredElement;
                    clazz.setName(typeParameter.getElementName());
                }
            }
            ++n2;
        }
    }

    protected void createParameters(Element element, Operation operation, IMethod method) throws JavaModelException {
        String[] paramNames = method.getParameterNames();
        String[] paramTypeSigs = method.getParameterTypes();
        int i = 0;
        while (i < paramNames.length) {
            String name = paramNames[i];
            String typeSig = paramTypeSigs[i];
            int arrayCount = Signature.getArrayCount((String)typeSig);
            Parameter parameter = UMLFactory.eINSTANCE.createParameter();
            parameter.setName(name);
            String typeWithoutArray = Signature.getElementType((String)typeSig);
            String typeName = Signature.toString((String)Signature.getTypeErasure((String)typeWithoutArray));
            Type paramType = this.findTemplateParameter(element, typeName);
            if (paramType == null) {
                typeName = this.resolveTypeInContext(element, method.getDeclaringType(), typeName);
                paramType = this.findOrCreateType(element.getNearestPackage(), typeName);
            }
            if (paramType != null) {
                parameter.setType(paramType);
            }
            if (arrayCount == 1) {
                parameter.setUpper(-1);
            }
            operation.getOwnedParameters().add((Object)parameter);
            ++i;
        }
    }

    protected Property createProperty(Element element, IField field) throws JavaModelException {
        LiteralString defaultValue;
        String[] typeArguments;
        boolean isCollection = false;
        boolean isSet = false;
        boolean isList = false;
        String fieldName = field.getElementName();
        String fieldTypeSig = field.getTypeSignature();
        String fieldTypeWithoutArray = Signature.getElementType((String)fieldTypeSig);
        Property propertyObject = null;
        int arrayCount = Signature.getArrayCount((String)fieldTypeSig);
        String fieldTypeName = Signature.toString((String)Signature.getTypeErasure((String)fieldTypeWithoutArray));
        Type fieldType = this.findTemplateParameter(element, fieldTypeName);
        if (fieldType == null) {
            fieldTypeName = this.resolveTypeInContext(element, field.getDeclaringType(), fieldTypeName);
            fieldType = this.findOrCreateType(element.getNearestPackage(), fieldTypeName);
        }
        if ((typeArguments = Signature.getTypeArguments((String)fieldTypeSig)) != null && typeArguments.length == 1) {
            java.lang.Class<?> mainClass = null;
            try {
                mainClass = java.lang.Class.forName(fieldTypeName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                LogUtils.logThrowable(e);
            }
            if (mainClass != null && Collection.class.isAssignableFrom(mainClass)) {
                isCollection = true;
                fieldTypeWithoutArray = typeArguments[0];
                String fieldTypeWithoutArrayName = Signature.toString((String)Signature.getTypeErasure((String)fieldTypeWithoutArray));
                fieldType = this.findTemplateParameter(element, fieldTypeWithoutArrayName);
                if (fieldType == null) {
                    fieldTypeWithoutArrayName = this.resolveTypeInContext(element, field.getDeclaringType(), fieldTypeWithoutArrayName);
                    fieldType = this.findOrCreateType(element.getNearestPackage(), fieldTypeWithoutArrayName);
                }
                if (mainClass != null && Set.class.isAssignableFrom(mainClass)) {
                    isSet = true;
                } else if (mainClass != null && List.class.isAssignableFrom(mainClass)) {
                    isList = true;
                }
            }
        }
        String affectation = this.retrieveFieldAffectation(field);
        propertyObject = null;
        String created = " created ";
        if (element instanceof Class) {
            propertyObject = ((Class)element).createOwnedAttribute(fieldName, fieldType);
            LogUtils.logCreation(element, null, propertyObject, created);
        } else if (element instanceof Enumeration) {
            propertyObject = ((Enumeration)element).createOwnedAttribute(fieldName, fieldType);
            LogUtils.logCreation(element, null, propertyObject, created);
        } else if (element instanceof Interface) {
            propertyObject = ((Interface)element).createOwnedAttribute(fieldName, fieldType);
            LogUtils.logCreation(element, null, propertyObject, created);
        }
        if (propertyObject == null) {
            ReversePlugin.log("The property can not be created.", 4);
            return null;
        }
        this.attachJavadoc((Element)propertyObject, (IMember)field);
        this.update((NamedElement)propertyObject, field.getFlags());
        if (field.getConstant() instanceof String) {
            defaultValue = (LiteralString)propertyObject.createDefaultValue("", propertyObject.getType(), UMLFactory.eINSTANCE.createLiteralString().eClass());
            defaultValue.setValue((String)field.getConstant());
        } else if (field.getConstant() instanceof Integer) {
            defaultValue = (LiteralInteger)propertyObject.createDefaultValue("", propertyObject.getType(), UMLFactory.eINSTANCE.createLiteralInteger().eClass());
            defaultValue.setValue(((Integer)field.getConstant()).intValue());
        } else if (field.getConstant() instanceof Boolean) {
            defaultValue = (LiteralBoolean)propertyObject.createDefaultValue("", propertyObject.getType(), UMLFactory.eINSTANCE.createLiteralBoolean().eClass());
            defaultValue.setValue(((Boolean)field.getConstant()).booleanValue());
        } else if (affectation != null && arrayCount == 0) {
            defaultValue = (LiteralString)propertyObject.createDefaultValue("", propertyObject.getType(), UMLFactory.eINSTANCE.createLiteralString().eClass());
            defaultValue.setValue(affectation);
        }
        if (arrayCount == 1) {
            String size;
            propertyObject.setUpper(-1);
            if (affectation != null && (size = this.retrieveInitDimSize(affectation, 1)) != null) {
                LiteralString defaultValue2 = (LiteralString)propertyObject.createDefaultValue("", propertyObject.getType(), UMLFactory.eINSTANCE.createLiteralString().eClass());
                defaultValue2.setValue(size);
            }
        } else if (arrayCount > 1) {
            String stringTypeName = this.resolveTypeInContext(element, field.getDeclaringType(), "String");
            Type stringType = this.findOrCreateType(element.getNearestPackage(), stringTypeName);
            int i = 1;
            while (i <= arrayCount) {
                String size;
                String qualifierName = "dimension_" + i;
                Property prop = propertyObject.createQualifier(qualifierName, stringType);
                prop.setUpper(-1);
                if (affectation != null && (size = this.retrieveInitDimSize(affectation, i)) != null) {
                    LiteralString defaultValue3 = (LiteralString)prop.createDefaultValue("", prop.getType(), UMLFactory.eINSTANCE.createLiteralString().eClass());
                    defaultValue3.setValue(size);
                }
                ++i;
            }
        }
        if (isCollection) {
            if (propertyObject.getUpper() < 2) {
                propertyObject.setUpper(-1);
            }
            propertyObject.setIsOrdered(false);
            propertyObject.setIsUnique(false);
        }
        if (isSet) {
            if (propertyObject.getUpper() < 2) {
                propertyObject.setUpper(-1);
            }
            propertyObject.setIsUnique(true);
            propertyObject.setIsOrdered(true);
        } else if (isList) {
            if (propertyObject.getUpper() < 2) {
                propertyObject.setUpper(-1);
            }
            propertyObject.setIsOrdered(true);
            propertyObject.setIsUnique(false);
        }
        return propertyObject;
    }

    private String retrieveInitDimSize(String initialization, int dim) {
        if (initialization == null) {
            return null;
        }
        int i = 1;
        while (initialization.indexOf(91) != -1) {
            int end = initialization.indexOf(93);
            if (dim == i) {
                int begin = initialization.indexOf(91);
                if (end != -1 && begin != -1 && end - begin >= 2) {
                    return initialization.substring(begin + 1, end);
                }
                return null;
            }
            if (end == -1) {
                return null;
            }
            initialization = initialization.substring(end + 1);
            ++i;
        }
        return null;
    }

    private String retrieveFieldAffectation(IField field) {
        String intialization = null;
        try {
            String source = field.getSource();
            int equalIndex = source.indexOf(61);
            int dotIndex = source.lastIndexOf(59);
            if (equalIndex != -1 && dotIndex > equalIndex) {
                intialization = source.substring(equalIndex + 1, dotIndex).trim();
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            LogUtils.logThrowable(e);
        }
        return intialization;
    }

    protected Property findProperty(Classifier classifier, String name) {
        for (Property prop : classifier.getAllAttributes()) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    protected void attachJavadoc(Element element, IMember member) throws JavaModelException {
        String javadoc = this.getJavadoc(member);
        if (!"".equals(javadoc)) {
            EAnnotation annotation = element.getEAnnotation(JAVA_REVERSER_DOC);
            if (annotation == null) {
                annotation = element.createEAnnotation(JAVA_REVERSER_DOC);
            }
            annotation.getDetails().put((Object)"documentation", (Object)javadoc);
        }
    }

    private void createUsages(Package packageObject) {
        ArrayList<Package> usedPackageList = new ArrayList<Package>();
        LogUtils.logEntering(packageObject, "Creating usages");
        for (PackageableElement elementInPackage : packageObject.getPackagedElements()) {
            Package importedPackage;
            if (elementInPackage instanceof Interface) {
                Interface interfaceObject = (Interface)elementInPackage;
                for (Package importedPackage2 : interfaceObject.getImportedPackages()) {
                    if (usedPackageList.contains(importedPackage2)) continue;
                    usedPackageList.add(importedPackage2);
                }
                for (PackageableElement element : interfaceObject.getImportedElements()) {
                    importedPackage = element.getNearestPackage();
                    if (usedPackageList.contains(importedPackage)) continue;
                    usedPackageList.add(importedPackage);
                }
                if (this.avoidImportElement()) continue;
                interfaceObject.getElementImports().clear();
                interfaceObject.getPackageImports().clear();
                continue;
            }
            if (!(elementInPackage instanceof StructuredClassifier)) continue;
            StructuredClassifier classifierObject = (StructuredClassifier)elementInPackage;
            for (Package importedPackage2 : classifierObject.getImportedPackages()) {
                if (usedPackageList.contains(importedPackage2)) continue;
                usedPackageList.add(importedPackage2);
            }
            for (PackageableElement element : classifierObject.getImportedElements()) {
                importedPackage = element.getNearestPackage();
                if (usedPackageList.contains(importedPackage)) continue;
                usedPackageList.add(importedPackage);
            }
            if (!this.avoidImportElement()) continue;
            classifierObject.getElementImports().clear();
            classifierObject.getPackageImports().clear();
        }
        for (Package usedPackage : usedPackageList) {
            Usage tmprel = packageObject.createUsage((NamedElement)usedPackage);
            tmprel.setName(String.valueOf(packageObject.getName()) + "_" + usedPackage.getName());
            LogUtils.logCreation(null, null, packageObject, null);
        }
        LogUtils.logExiting();
    }

    protected boolean avoidImportElement() {
        if (this.javaProject == null) {
            return true;
        }
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.javaProject.getElementName());
        IPreferenceStore store = Java2UMLPreferencesStoreManager.getPreferenceStore(iProject);
        return store.getBoolean("REVERSE_INDICATOR");
    }

    protected boolean avoidDependenciesComputing() {
        if (this.javaProject == null) {
            return true;
        }
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.javaProject.getElementName());
        IPreferenceStore store = Java2UMLPreferencesStoreManager.getPreferenceStore(iProject);
        return store.getBoolean("COMPUTE_DEPENDENCIES_INDICATOR");
    }

    protected void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, ReversePlugin.getId(), 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public Package convert(IJavaElement javaElement, Resource pEmfResource) throws CoreException {
        return this.convert(javaElement, pEmfResource, ActivityGeneration.NONE);
    }

    public Package convert(IJavaElement javaElement, Resource pEmfResource, ActivityGeneration actGen) throws CoreException {
        this.emfResource = pEmfResource;
        return this.convert(javaElement, actGen);
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    protected Package load(URI uri) throws CoreException {
        Package vPackage = null;
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(uri, true);
            vPackage = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        }
        catch (WrappedException we) {
            LogUtils.logThrowable(we);
            this.throwCoreException(we.getMessage());
        }
        return vPackage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActivityGeneration {
        NONE,
        ANNOTATED,
        ALL;

    }
}

