/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.java.ui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.umlgen.gen.java.ui.UML2JavaUIActivator;
import org.eclipse.umlgen.gen.java.ui.common.ConfigurationServices;

public class GenerateJavaHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            IResource model = null;
            Object selectedObj = selection.getFirstElement();
            if (selectedObj instanceof IResource) {
                model = (IResource)selectedObj;
            } else if (selectedObj instanceof EObject) {
                model = ResourcesPlugin.getWorkspace().getRoot().findMember(((EObject)selectedObj).eResource().getURI().toPlatformString(true));
            }
            if (model != null) {
                String configName = ConfigurationServices.getConfigurationProperty(model);
                if (configName != null) {
                    ILaunchConfiguration config = ConfigurationServices.getStoredLaunchConfiguration(configName);
                    if (config != null) {
                        String computedModelPath = model.getFullPath().toString();
                        String modelPath = config.getAttribute("uml_model_path", "");
                        if (modelPath != null && modelPath.equals(computedModelPath)) {
                            ILaunchGroup group = ConfigurationServices.getLaunchGroup();
                            if (group != null) {
                                DebugUITools.launch((ILaunchConfiguration)config, (String)group.getMode());
                            }
                        } else {
                            Status status = new Status(4, "org.eclipse.umlgen.gen.java.ui", "No configuration matches with this model.");
                            UML2JavaUIActivator.getDefault().getLog().log((IStatus)status);
                        }
                    } else {
                        Status status = new Status(1, "org.eclipse.umlgen.gen.java.ui", "The launch configuration \"" + configName + "\" does not exist. Maybe it has been removed. You may define this in the properties of the model: \"" + model.getFullPath().toString() + "\"");
                        UML2JavaUIActivator.getDefault().getLog().log((IStatus)status);
                    }
                } else {
                    Status status = new Status(1, "org.eclipse.umlgen.gen.java.ui", "No Java generation launch configuration has been chosen for the model: \"" + model.getFullPath().toString() + "\"");
                    UML2JavaUIActivator.getDefault().getLog().log((IStatus)status);
                }
            }
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (CoreException e2) {
            e2.printStackTrace();
        }
        return null;
    }
}

