/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.java.ui.properties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupViewer;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.umlgen.gen.java.ui.common.ConfigurationServices;

public class LaunchConfigurationPropertiesPage
extends PropertyPage {
    private LaunchConfigurationsCombo combo;
    private CustomLaunchConfigurationTabGroupViewer viewer;

    public LaunchConfigurationPropertiesPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        composite.setLayoutData((Object)data);
        this.combo = new LaunchConfigurationsCombo(composite, 8);
        String configNameToSelect = ConfigurationServices.getConfigurationProperty((IResource)this.getElement());
        List<ILaunchConfiguration> configs = ConfigurationServices.getStoredJavaGenerationLaunchConfigurations((IResource)this.getElement());
        if (configs.isEmpty() || configNameToSelect == null) {
            Label isStoredLabel = new Label(composite, 0);
            isStoredLabel.setForeground(new Color((Device)composite.getDisplay(), new RGB(255, 0, 0)));
            isStoredLabel.setText("No favourite configuration for this model. Click on OK to choose the selected one.");
        }
        this.viewer = this.createViewer(composite);
        if (this.viewer != null) {
            this.combo.setLaunchConfigurations(configs);
            this.combo.setViewer(this.viewer);
            if (!(configNameToSelect != null && configNameToSelect.compareTo("") != 0 && this.combo.contains(configNameToSelect) || this.combo.isEmpty())) {
                configNameToSelect = this.combo.getItem(0);
            } else if (this.combo.isEmpty()) {
                try {
                    ILaunchConfigurationWorkingCopy newLaunchConfig = this.createLaunchConfigurationWorkingCopy();
                    this.combo.add((ILaunchConfiguration)newLaunchConfig);
                    configNameToSelect = newLaunchConfig.getName();
                    newLaunchConfig.setAttribute("uml_model_path", ((IResource)this.getElement()).getFullPath().toString());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            this.combo.select(configNameToSelect);
        }
        return composite;
    }

    public boolean performOk() {
        try {
            if (this.combo.getSelectedLaunchConfiguration() instanceof ILaunchConfigurationWorkingCopy && ((ILaunchConfigurationWorkingCopy)this.combo.getSelectedLaunchConfiguration()).getOriginal() == null) {
                ((ILaunchConfigurationWorkingCopy)this.combo.getSelectedLaunchConfiguration()).doSave();
            } else if (this.viewer != null) {
                this.viewer.doApply();
            }
            ConfigurationServices.saveConfigurationProperty((IResource)this.getElement(), this.combo.getSelectedLaunchConfiguration().getName());
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    private CustomLaunchConfigurationTabGroupViewer createViewer(Composite parent) {
        ILaunchGroup launchGroup = ConfigurationServices.getLaunchGroup();
        if (launchGroup instanceof LaunchGroupExtension) {
            CustomLaunchConfigurationsDialog dialog = new CustomLaunchConfigurationsDialog(this.getShell(), (LaunchGroupExtension)launchGroup);
            return new CustomLaunchConfigurationTabGroupViewer(parent, dialog);
        }
        return null;
    }

    private ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy() throws CoreException {
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.umlgen.gen.java.ui.launchConfigurationType");
        return type.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(LaunchConfigurationsMessages.CreateLaunchConfigurationAction_New_configuration_2));
    }

    private class CustomLaunchConfigurationTabGroupViewer
    extends LaunchConfigurationTabGroupViewer {
        private static final String MSG_REVERT_BUTTON = "Revert the last changes";
        private static final String MSG_APPLY_BUTTON = "Save the changes in the related launch configuration";

        public CustomLaunchConfigurationTabGroupViewer(Composite parent, CustomLaunchConfigurationsDialog dialog) {
            super(parent, (ILaunchConfigurationDialog)dialog);
            dialog.setViewer(this);
            this.getApplyButton().setToolTipText(MSG_APPLY_BUTTON);
            this.getRevertButton().setToolTipText(MSG_REVERT_BUTTON);
        }

        public void doInputChanged(ILaunchConfiguration config) {
            this.inputChanged(config);
        }

        public void doApply() {
            this.handleApplyPressed();
        }

        protected ILaunchConfiguration handleApplyPressed() {
            ILaunchConfiguration launchConfig = super.handleApplyPressed();
            if (launchConfig != null && !LaunchConfigurationPropertiesPage.this.combo.getText().equals(launchConfig.getName())) {
                ILaunchConfiguration storedLaunchConfig = ConfigurationServices.getStoredLaunchConfiguration(launchConfig.getName());
                LaunchConfigurationPropertiesPage.this.combo.select(storedLaunchConfig);
                LaunchConfigurationPropertiesPage.this.combo.updateCurrentItem(storedLaunchConfig);
                launchConfig = storedLaunchConfig;
            }
            return launchConfig;
        }
    }

    private class CustomLaunchConfigurationsDialog
    extends LaunchConfigurationsDialog {
        public CustomLaunchConfigurationsDialog(Shell shell, LaunchGroupExtension group) {
            super(shell, group);
        }

        public boolean isTreeSelectionEmpty() {
            return true;
        }

        public void updateButtons() {
            this.getTabViewer().refresh();
        }

        public void updateMessage() {
        }

        public void setViewer(LaunchConfigurationTabGroupViewer viewer) {
            this.setTabViewer(viewer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LaunchConfigurationsCombo
    extends Combo {
        private Map<String, ILaunchConfiguration> mConfigsRegistry;
        private ILaunchConfiguration mSelectedConfig;
        private CustomLaunchConfigurationTabGroupViewer mViewer;
        private SelectionListener selectionListener;

        public LaunchConfigurationsCombo(Composite parent, int style) {
            super(parent, style);
            this.mConfigsRegistry = new HashMap<String, ILaunchConfiguration>();
        }

        public void setLaunchConfigurations(List<ILaunchConfiguration> configs) {
            for (ILaunchConfiguration config : configs) {
                this.add(config);
            }
        }

        protected void checkSubclass() {
        }

        public void add(ILaunchConfiguration configuration) {
            this.add(configuration.getName());
            this.mConfigsRegistry.put(configuration.getName(), configuration);
        }

        public void setViewer(CustomLaunchConfigurationTabGroupViewer viewer) {
            this.mViewer = viewer;
            if (this.selectionListener == null) {
                this.selectionListener = new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        String selection = LaunchConfigurationsCombo.this.getText();
                        ILaunchConfiguration selectedConfig = (ILaunchConfiguration)LaunchConfigurationsCombo.this.mConfigsRegistry.get(selection);
                        LaunchConfigurationsCombo.this.mViewer.doInputChanged(selectedConfig);
                        LaunchConfigurationsCombo.this.mSelectedConfig = selectedConfig;
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                };
                this.addSelectionListener(this.selectionListener);
            }
        }

        public void select(String text) {
            ILaunchConfiguration configToSelect = this.mConfigsRegistry.get(text);
            if (configToSelect != null && configToSelect != this.mSelectedConfig) {
                this.select(configToSelect);
            }
        }

        public void select(ILaunchConfiguration configuration) {
            if (!configuration.getName().equals(this.getText())) {
                this.setText(configuration.getName());
            }
            this.mConfigsRegistry.put(configuration.getName(), configuration);
            this.mSelectedConfig = configuration;
            this.mViewer.doInputChanged(configuration);
        }

        public void updateCurrentItem(ILaunchConfiguration configuration) {
            this.mConfigsRegistry.remove(this.getText());
            this.mConfigsRegistry.put(configuration.getName(), configuration);
            this.mSelectedConfig = configuration;
            int indexToUpdate = this.indexOf(this.getText());
            this.setItem(indexToUpdate, configuration.getName());
            this.setText(configuration.getName());
            this.pack(true);
        }

        public ILaunchConfiguration getSelectedLaunchConfiguration() {
            return this.mSelectedConfig;
        }

        public boolean contains(String text) {
            return this.mConfigsRegistry.containsKey(text);
        }

        public boolean isEmpty() {
            return this.mConfigsRegistry.isEmpty();
        }
    }
}

