/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.autojava.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLServices {
    public boolean hasStereotype(Element elt, String stereotype) {
        boolean result = false;
        Stereotype stereotypeFound = elt.getAppliedStereotype(stereotype);
        if (stereotypeFound == null) {
            if (elt.hasKeyword(stereotype)) {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    public String getStereotypeProperty(Element element, String stereotypeName, String propertyName) {
        String result = null;
        Stereotype stereotype = element.getAppliedStereotype(stereotypeName);
        if (stereotype != null) {
            Object value = element.getValue(stereotype, propertyName);
            if (value instanceof String) {
                result = (String)value;
            } else if (value instanceof Boolean) {
                result = ((Boolean)value).toString();
            } else if (value instanceof Integer) {
                result = ((Integer)value).toString();
            } else if (value instanceof EnumerationLiteral) {
                result = ((EnumerationLiteral)value).getName();
            }
        }
        return result;
    }

    public List<NamedElement> minimizeByName(List<NamedElement> list) {
        ArrayList<NamedElement> result = new ArrayList<NamedElement>();
        for (NamedElement el : list) {
            if (this.contain(result, el)) continue;
            result.add(el);
        }
        return result;
    }

    public List<Element> getEmptyStereotypeAttribute(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Stereotype stereotype : element.getAppliedStereotypes()) {
            for (Property property : stereotype.getAllAttributes()) {
                if (property.getName().startsWith("base_") || element.getValue(stereotype, property.getName()) != null) continue;
                result.add((Element)property);
            }
        }
        return result;
    }

    private boolean contain(List<NamedElement> receiver, NamedElement el) {
        for (NamedElement element : receiver) {
            if (!el.getName().equals(element.getName())) continue;
            return true;
        }
        return false;
    }
}

