/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.reconciler;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorObjectStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.umlgen.reverse.c.event.AbstractCModelChangedEvent;
import org.eclipse.umlgen.reverse.c.event.CommentAdded;
import org.eclipse.umlgen.reverse.c.event.CommentRemoved;
import org.eclipse.umlgen.reverse.c.event.FunctionBodyChanged;
import org.eclipse.umlgen.reverse.c.internal.reconciler.SameFileLocation;
import org.eclipse.umlgen.reverse.c.reconciler.AbstractReconciler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTCommentReconciler
extends AbstractReconciler {
    private boolean includeInactiveNodes;
    private final int decalage = 1;
    private TreeMap<Integer, IASTNode> originalMap;
    private TreeMap<Integer, IASTNode> newMap;
    private IASTTranslationUnit originalAst;
    private IASTTranslationUnit newAst;

    public void reconcile(ITranslationUnit originalUnit, ITranslationUnit newUnit) throws CoreException {
        this.originalAst = originalUnit.getAST();
        Object[] originalDecls = this.originalAst.getDeclarations(this.includeInactiveNodes);
        Collection originalDeclsFiltered = Collections2.filter((Collection)Lists.newArrayList((Object[])originalDecls), (Predicate)new SameFileLocation(this.originalAst));
        this.originalMap = this.fillMap(originalUnit, originalDeclsFiltered);
        this.reconcile(newUnit, originalUnit, (IASTDeclaration[])originalDecls);
    }

    public void reconcile(ITranslationUnit newUnit, ITranslationUnit originalUnit, IASTDeclaration[] originalDecls) throws CoreException {
        this.newAst = newUnit.getAST();
        Object[] newDecls = this.newAst.getDeclarations(this.includeInactiveNodes);
        Collection newDeclsFiltered = Collections2.filter((Collection)Lists.newArrayList((Object[])newDecls), (Predicate)new SameFileLocation(newUnit.getAST()));
        this.newMap = this.fillMap(newUnit, newDeclsFiltered);
        if (this.originalMap == null) {
            this.originalMap = new TreeMap();
        }
        AbstractCModelChangedEvent event = null;
        String body = "";
        IASTNode parent = null;
        IASTNode oldparent = null;
        boolean addOrRemove = true;
        IASTComment comment = this.findCommentAdded(this.originalMap, this.newMap);
        IASTComment oldComment = this.findCommentRemoved(this.originalMap, this.newMap);
        while (comment != null || oldComment != null) {
            addOrRemove = true;
            if (this.originalMap.size() == this.newMap.size()) {
                addOrRemove = false;
            }
            if (addOrRemove && comment != null) {
                parent = this.findParentOfComment(this.newMap, this.newAst, comment);
                if (!(parent instanceof IASTFunctionDefinition) && !(parent instanceof IASTInitializerList)) {
                    body = this.computeStartOfComment(this.newMap, comment).concat(this.computeEndOfComment(this.newMap, comment, parent));
                    if (body.trim().length() > 0) {
                        event = (AbstractCModelChangedEvent)CommentAdded.builder().setBody(body).setParent(parent).setSource(comment).translationUnit(newUnit).build();
                    }
                } else if (parent instanceof IASTFunctionDefinition && comment.getFileLocation().getNodeOffset() < parent.getFileLocation().getNodeOffset() && (body = this.computeStartOfComment(this.newMap, comment).concat(this.computeEndOfComment(this.newMap, comment, parent))).trim().length() > 0) {
                    event = (AbstractCModelChangedEvent)CommentAdded.builder().setBody(body).setParent(parent).setSource(comment).translationUnit(newUnit).build();
                }
            } else if (addOrRemove && oldComment != null) {
                oldparent = this.findParentOfComment(this.originalMap, this.originalAst, oldComment);
                if (!(oldparent instanceof IASTFunctionDefinition) && !(parent instanceof IASTInitializerList) && (body = this.computeStartOfComment(this.originalMap, oldComment).concat(this.computeEndOfComment(this.originalMap, oldComment, parent))).trim().length() > 0) {
                    event = (AbstractCModelChangedEvent)CommentRemoved.builder().setBody(body).setParent(oldparent).setSource(oldComment).translationUnit(newUnit).build();
                }
            } else if (!addOrRemove && comment != null) {
                oldparent = this.findParentOfComment(this.originalMap, this.originalAst, oldComment);
                parent = this.findParentOfComment(this.newMap, this.newAst, comment);
                if (!(oldparent instanceof IASTFunctionDefinition) && !(parent instanceof IASTInitializerList) && (body = this.computeStartOfComment(this.originalMap, oldComment).concat(this.computeEndOfComment(this.originalMap, oldComment, parent))).trim().length() > 0) {
                    event = (AbstractCModelChangedEvent)CommentRemoved.builder().setBody(body).setParent(oldparent).setSource(oldComment).translationUnit(originalUnit).build();
                    this.notifyListeners(event, false);
                }
                if (!(parent instanceof IASTFunctionDefinition) && !(parent instanceof IASTInitializerList)) {
                    body = this.computeStartOfComment(this.newMap, comment).concat(this.computeEndOfComment(this.newMap, comment, parent));
                    if (body.trim().length() > 0) {
                        event = (AbstractCModelChangedEvent)CommentAdded.builder().setBody(body).setParent(parent).setSource(comment).translationUnit(newUnit).build();
                    }
                } else if (parent instanceof IASTFunctionDefinition) {
                    String newbody = ((IASTFunctionDefinition)parent).getBody().getRawSignature();
                    String oldBody = ((IASTFunctionDefinition)oldparent).getBody().getRawSignature();
                    String currentName = ((IASTFunctionDefinition)parent).getDeclarator().getName().toString();
                    event = (AbstractCModelChangedEvent)FunctionBodyChanged.builder().setBody(newbody).setOldBody(oldBody).currentName(currentName).translationUnit(newUnit).build();
                }
            }
            if (event != null) {
                this.notifyListeners(event, false);
                event = null;
            }
            if (comment != null) {
                this.newMap = this.removeCommentsFrom(this.newMap, comment, parent);
                comment = this.findCommentAdded(this.originalMap, this.newMap);
            }
            if (comment != null || oldComment == null) continue;
            this.originalMap = this.removeCommentsFrom(this.originalMap, oldComment, parent);
            oldComment = this.findCommentRemoved(this.originalMap, this.newMap);
        }
    }

    private boolean isBeforeOrInsideParent(IASTComment comment, IASTNode parent) {
        boolean result = false;
        if (comment.getFileLocation().getNodeOffset() < parent.getFileLocation().getNodeOffset()) {
            result = true;
        } else if (comment.getFileLocation().getStartingLineNumber() == parent.getFileLocation().getStartingLineNumber()) {
            result = true;
        } else if (comment.getFileLocation().getEndingLineNumber() == parent.getFileLocation().getEndingLineNumber()) {
            result = true;
        } else if (comment.getFileLocation().getNodeOffset() < parent.getFileLocation().getNodeOffset() + parent.getFileLocation().getNodeLength()) {
            result = true;
        }
        return result;
    }

    private TreeMap<Integer, IASTNode> removeCommentsFrom(TreeMap<Integer, IASTNode> treeMap, IASTComment comment, IASTNode parent) {
        boolean notEnd = true;
        Iterator<Integer> iterator = treeMap.keySet().iterator();
        HashMap<Integer, Integer> removalMap = new HashMap<Integer, Integer>();
        while (iterator.hasNext() && notEnd) {
            Integer integer = iterator.next();
            if (integer > 0 && integer <= comment.getFileLocation().getNodeOffset() + 1 && treeMap.get(integer) instanceof IASTComment && this.isBeforeOrInsideParent(comment, parent)) {
                removalMap.put(integer, integer);
            }
            if (integer <= comment.getFileLocation().getNodeOffset() + 1) continue;
            if (treeMap.get(integer) instanceof IASTComment) {
                if (this.isBeforeOrInsideParent((IASTComment)treeMap.get(integer), parent)) {
                    removalMap.put(integer, integer);
                    continue;
                }
                notEnd = false;
                continue;
            }
            notEnd = false;
        }
        for (Integer integer : removalMap.keySet()) {
            treeMap.remove(integer);
        }
        return treeMap;
    }

    public String computeStartOfComment(TreeMap<Integer, IASTNode> map, IASTComment comment) {
        StringBuilder returnString = new StringBuilder();
        for (Integer integer : map.keySet()) {
            IASTComment currentComment;
            IASTNode element = map.get(integer);
            if (!(element instanceof IASTComment) || (currentComment = (IASTComment)element) == comment) continue;
            if (currentComment.getFileLocation().getNodeOffset() < comment.getFileLocation().getNodeOffset()) {
                returnString = returnString.append(new String(((IASTComment)element).getComment())).append("\n");
                continue;
            }
            if (currentComment.getFileLocation().getNodeOffset() != comment.getFileLocation().getNodeOffset()) continue;
            return returnString.toString();
        }
        return returnString.toString();
    }

    public String computeEndOfComment(TreeMap<Integer, IASTNode> map, IASTComment comment, IASTNode parent) {
        StringBuilder returnString = new StringBuilder();
        boolean notReached = true;
        boolean notEnd = true;
        Iterator<Integer> iterator = map.keySet().iterator();
        while (iterator.hasNext() && (notReached || notEnd)) {
            Integer key = iterator.next();
            IASTNode element = map.get(key);
            if (element instanceof IASTComment) {
                if (parent instanceof IASTTranslationUnit || element instanceof IASTTranslationUnit || element.getFileLocation().getEndingLineNumber() <= parent.getFileLocation().getStartingLineNumber()) {
                    if (!notReached) {
                        returnString = returnString.append(new String(((IASTComment)element).getComment())).append("\n");
                    }
                    if ((IASTComment)element != comment) continue;
                    returnString = returnString.append(new String(((IASTComment)element).getComment()));
                    notReached = false;
                    continue;
                }
                if (notReached) continue;
                notEnd = false;
                continue;
            }
            if (notReached) continue;
            notEnd = false;
        }
        return returnString.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IASTNode findParentOfComment(TreeMap<Integer, IASTNode> map, IASTTranslationUnit astTranslationUnitNode, IASTComment comment) {
        Iterator<Integer> iterator = map.keySet().iterator();
        IASTTranslationUnit previousNode = astTranslationUnitNode;
        IASTTranslationUnit followingNode = astTranslationUnitNode;
        boolean endOfCompare = false;
        while (iterator.hasNext() && followingNode.getFileLocation().getNodeOffset() < comment.getFileLocation().getNodeOffset()) {
            Integer key = iterator.next();
            IASTNode element = map.get(key);
            if (endOfCompare || element instanceof IASTComment || key <= 0) continue;
            if (element.getFileLocation().getNodeOffset() > comment.getFileLocation().getNodeOffset()) {
                followingNode = element;
                endOfCompare = true;
                continue;
            }
            previousNode = element;
            followingNode = element;
        }
        if (previousNode instanceof IASTTranslationUnit) {
            return astTranslationUnitNode;
        }
        if (previousNode instanceof IASTParameterDeclaration) {
            if (previousNode.getFileLocation().getStartingLineNumber() == comment.getFileLocation().getStartingLineNumber() || previousNode.getFileLocation().getEndingLineNumber() == comment.getFileLocation().getEndingLineNumber()) {
                return previousNode;
            }
            if (comment.getFileLocation().getNodeOffset() > previousNode.getParent().getFileLocation().getNodeOffset() && comment.getFileLocation().getNodeOffset() < previousNode.getParent().getFileLocation().getNodeOffset() + previousNode.getParent().getFileLocation().getNodeLength()) {
                if (!(previousNode.getParent() instanceof IASTFunctionDeclarator)) return null;
                return ((IASTFunctionDeclarator)previousNode.getParent()).getParent();
            }
            if (!(previousNode.getParent() instanceof IASTFunctionDeclarator)) return followingNode;
            IASTNode parentParameter = ((IASTFunctionDeclarator)previousNode.getParent()).getParent();
            if (comment.getFileLocation().getNodeOffset() <= parentParameter.getFileLocation().getNodeOffset() || comment.getFileLocation().getNodeOffset() >= parentParameter.getFileLocation().getNodeOffset() + parentParameter.getFileLocation().getNodeLength()) return followingNode;
            return ((IASTFunctionDeclarator)previousNode.getParent()).getParent();
        }
        if (previousNode instanceof IASTPreprocessorObjectStyleMacroDefinition && followingNode instanceof IASTPreprocessorIncludeStatement) {
            return followingNode.getParent();
        }
        if (previousNode instanceof IASTTranslationUnit && followingNode instanceof IASTPreprocessorIncludeStatement) {
            return astTranslationUnitNode;
        }
        if (previousNode.getFileLocation().getStartingLineNumber() == comment.getFileLocation().getStartingLineNumber() && previousNode.getFileLocation().getEndingLineNumber() == comment.getFileLocation().getEndingLineNumber()) {
            if (previousNode.getFileLocation().getNodeOffset() > comment.getFileLocation().getNodeOffset()) return followingNode;
            return previousNode;
        }
        if (previousNode instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)previousNode).getDeclSpecifier() instanceof IASTEnumerationSpecifier) {
            if (comment.getFileLocation().getStartingLineNumber() == previousNode.getFileLocation().getEndingLineNumber()) {
                return previousNode;
            }
            if (comment.getFileLocation().getNodeOffset() < previousNode.getFileLocation().getNodeOffset() + previousNode.getFileLocation().getNodeLength()) {
                return this.getParentEnumerator((IASTEnumerationSpecifier)((IASTSimpleDeclaration)previousNode).getDeclSpecifier(), comment);
            }
        }
        if (!(followingNode instanceof IASTTranslationUnit)) return followingNode;
        return astTranslationUnitNode;
    }

    private IASTEnumerationSpecifier.IASTEnumerator getParentEnumerator(IASTEnumerationSpecifier enumeration, IASTComment comment) {
        IASTEnumerationSpecifier.IASTEnumerator enumerator = null;
        IASTEnumerationSpecifier.IASTEnumerator[] iASTEnumeratorArray = enumeration.getEnumerators();
        int n = iASTEnumeratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTEnumerationSpecifier.IASTEnumerator enumLiteral = iASTEnumeratorArray[n2];
            if (enumLiteral != null) {
                if (enumLiteral.getFileLocation().getStartingLineNumber() == comment.getFileLocation().getStartingLineNumber() && enumLiteral.getFileLocation().getEndingLineNumber() == comment.getFileLocation().getEndingLineNumber()) {
                    enumerator = enumLiteral;
                    break;
                }
                if (enumLiteral.getFileLocation().getStartingLineNumber() > comment.getFileLocation().getEndingLineNumber()) {
                    enumerator = enumLiteral;
                    break;
                }
            }
            ++n2;
        }
        return enumerator;
    }

    private IASTComment findCommentRemoved(TreeMap<Integer, IASTNode> oldMap, TreeMap<Integer, IASTNode> pNewMap) {
        return this.findCommentAdded(pNewMap, oldMap);
    }

    private IASTComment findCommentAdded(TreeMap<Integer, IASTNode> oldMap, TreeMap<Integer, IASTNode> pNewMap) {
        Integer oldKey = null;
        IASTNode element = null;
        IASTNode oldElement = null;
        Integer index = new Integer(0);
        boolean found = false;
        IASTNode fromNode = null;
        StringBuilder newComment = null;
        StringBuilder oldComment = null;
        Iterator<Integer> newIterator = pNewMap.keySet().iterator();
        while (newIterator.hasNext() && !found) {
            found = false;
            index = newIterator.next();
            element = pNewMap.get(index);
            if (!(element instanceof IASTComment)) {
                fromNode = element;
                newComment = new StringBuilder();
                continue;
            }
            if (!(element instanceof IASTComment)) continue;
            newComment = newComment.append(new String(((IASTComment)element).getComment()));
            Iterator<Integer> originalIterator = oldMap.keySet().iterator();
            IASTNode fromOldElement = null;
            while (originalIterator.hasNext() && index != null) {
                oldKey = originalIterator.next();
                oldElement = oldMap.get(oldKey);
                if (!(oldElement instanceof IASTComment)) {
                    fromOldElement = oldElement;
                    oldComment = new StringBuilder();
                    continue;
                }
                if (fromNode instanceof IASTTranslationUnit && fromOldElement instanceof IASTTranslationUnit) {
                    if (element.getRawSignature().equals(oldElement.getRawSignature())) {
                        index = null;
                    } else if (oldElement.getFileLocation().getNodeOffset() >= element.getFileLocation().getNodeOffset()) {
                        return (IASTComment)pNewMap.get(index);
                    }
                }
                if (fromOldElement != null && fromNode != null && fromOldElement.getRawSignature().equals(fromNode.getRawSignature())) {
                    if (!(oldComment = oldComment.append(new String(((IASTComment)oldElement).getComment()))).toString().equals(newComment.toString())) continue;
                    index = null;
                    continue;
                }
                oldComment = oldComment.append(new String(((IASTComment)oldElement).getComment()));
                if (!(fromOldElement instanceof IASTTranslationUnit) || !(fromNode instanceof IASTTranslationUnit) || !(oldElement instanceof IASTComment) || !oldComment.toString().equals(newComment.toString())) continue;
                index = null;
            }
            if (index == null) continue;
            found = true;
        }
        if (found) {
            return (IASTComment)pNewMap.get(index);
        }
        return null;
    }

    public TreeMap<Integer, IASTNode> fillMap(ITranslationUnit tu, Collection<IASTDeclaration> declarations) throws CoreException {
        IASTTranslationUnit astTU = tu.getAST();
        IASTTranslationUnit emptyAst = astTU.getASTNodeFactory().newTranslationUnit(null);
        TreeMap<Integer, IASTNode> map = new TreeMap<Integer, IASTNode>();
        map.put(0, (IASTNode)emptyAst);
        Object[] originalComments = astTU.getComments();
        Collection originalCommentsFiltered = Collections2.filter((Collection)Lists.newArrayList((Object[])originalComments), (Predicate)new SameFileLocation(astTU));
        for (IASTComment originalComment : originalCommentsFiltered) {
            map.put(originalComment.getFileLocation().getNodeOffset() + 1, (IASTNode)originalComment);
        }
        Object[] originalPreProcessorStatements = astTU.getAllPreprocessorStatements();
        Collection originalPreProcessorStatementsFiltered = Collections2.filter((Collection)Lists.newArrayList((Object[])originalPreProcessorStatements), (Predicate)new SameFileLocation(astTU));
        for (IASTPreprocessorStatement originalPreProcessorStatement : originalPreProcessorStatementsFiltered) {
            map.put(originalPreProcessorStatement.getFileLocation().getNodeOffset() + 1, (IASTNode)originalPreProcessorStatement);
        }
        IASTNode[] children = null;
        for (IASTDeclaration declaration : declarations) {
            map.put(new Integer(declaration.getFileLocation().getNodeOffset() + 1), (IASTNode)declaration);
            if (!(declaration instanceof IASTFunctionDefinition) && !(declaration instanceof IASTSimpleDeclaration)) continue;
            if (declaration instanceof IASTFunctionDefinition) {
                children = ((IASTFunctionDefinition)declaration).getDeclarator().getChildren();
            } else if (declaration instanceof IASTSimpleDeclaration) {
                IASTDeclSpecifier specifier = ((IASTSimpleDeclaration)declaration).getDeclSpecifier();
                if (specifier instanceof IASTEnumerationSpecifier) {
                    children = ((IASTEnumerationSpecifier)specifier).getEnumerators();
                } else if (specifier instanceof IASTCompositeTypeSpecifier) {
                    children = ((IASTCompositeTypeSpecifier)specifier).getMembers();
                } else if (specifier instanceof IASTElaboratedTypeSpecifier) {
                    children = ((IASTElaboratedTypeSpecifier)specifier).getChildren();
                } else if (((IASTSimpleDeclaration)declaration).getDeclarators().length > 0) {
                    IASTInitializer initializer;
                    IASTDeclarator declarator = ((IASTSimpleDeclaration)declaration).getDeclarators()[0];
                    if (declarator instanceof IASTFunctionDeclarator) {
                        children = declarator.getChildren();
                    } else if (declarator instanceof IASTArrayDeclarator && (initializer = declarator.getInitializer()) != null) {
                        IASTNode[] initializerLists;
                        IASTNode[] iASTNodeArray = initializerLists = initializer.getChildren();
                        int n = initializerLists.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IASTNode initializerList = iASTNodeArray[n2];
                            if (initializerList instanceof IASTInitializerList) {
                                IASTNode[] iASTNodeArray2 = ((IASTInitializerList)initializerList).getChildren();
                                int n3 = iASTNodeArray2.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IASTNode init = iASTNodeArray2[n4];
                                    map.put(init.getFileLocation().getNodeOffset() + 1, init);
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                    }
                }
            }
            if (children == null) continue;
            IASTNode[] iASTNodeArray = children;
            int n = children.length;
            int n5 = 0;
            while (n5 < n) {
                IASTNode child = iASTNodeArray[n5];
                if (!(child instanceof IASTName) && child instanceof IASTParameterDeclaration) {
                    map.put(child.getFileLocation().getNodeOffset() + 1, child);
                }
                ++n5;
            }
        }
        while (map.get(map.lastKey()) instanceof IASTComment) {
            map.remove(map.lastKey());
        }
        return map;
    }
}

