/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.autojava.services;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilServices {
    private static final String ELSE_CONDITION = "else";

    public List<NamedElement> minimizeByString(List<NamedElement> elts, List<String> strings) {
        ArrayList<String> distinct = new ArrayList<String>();
        ArrayList<NamedElement> result = new ArrayList<NamedElement>();
        if (elts.size() == strings.size()) {
            int i = 0;
            while (i < elts.size()) {
                if (!distinct.contains(strings.get(i))) {
                    distinct.add(strings.get(i));
                    result.add(elts.get(i));
                }
                ++i;
            }
        } else {
            return elts;
        }
        return result;
    }

    public Set<String> getSimilarBehaviorFeatures(Interface myInterface) {
        ArrayList<String> distinctNames = new ArrayList<String>();
        HashSet<String> similarNames = new HashSet<String>();
        for (Element elt : myInterface.getOwnedElements()) {
            if (!(elt instanceof BehavioralFeature)) continue;
            BehavioralFeature feature = (BehavioralFeature)elt;
            String name = feature.getName();
            if (!distinctNames.contains(name)) {
                distinctNames.add(name);
                continue;
            }
            similarNames.add(name);
        }
        return similarNames;
    }

    public boolean contains(Set<Object> objects, Object object) {
        for (Object obj : objects) {
            if (!obj.equals(object)) continue;
            return true;
        }
        return false;
    }

    public Integer multiply(Integer a, Integer b) {
        return new Integer(a * b);
    }

    public List<Object> call(EObject receiver, String opName) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (receiver != null && opName != null && receiver != null && opName != null) {
            EOperation myOp = null;
            for (EOperation op : receiver.eClass().getEAllOperations()) {
                if (op.getName() == null || !op.getName().equals(opName)) continue;
                myOp = op;
                break;
            }
            if (myOp != null) {
                Object obj = null;
                try {
                    obj = receiver.eInvoke(myOp, ECollections.EMPTY_ELIST);
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.out.println("**DEBUG** " + receiver + " " + receiver.eClass() + " " + myOp);
                }
                if (obj instanceof List) {
                    result.addAll((List)obj);
                } else if (obj != null) {
                    result.add(obj);
                }
            }
        }
        return result;
    }

    public List<EObject> minimize(List<EObject> objs) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject obj : objs) {
            if (obj == null || result.contains(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    public List<Object> get(EObject receiver, String feature) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (receiver != null && feature != null) {
            EStructuralFeature sFeature = receiver.eClass().getEStructuralFeature(feature);
            Object obj = receiver.eGet(sFeature);
            if (obj instanceof List) {
                result.addAll((List)obj);
            } else if (obj != null) {
                result.add(obj);
            }
        }
        return result;
    }

    public List<Transition> sortByCondition(List<Transition> list) {
        ArrayList<Transition> result = new ArrayList<Transition>();
        ArrayList<Transition> elseCondition = new ArrayList<Transition>();
        for (Transition tr : list) {
            for (Constraint constraint : tr.getOwnedRules()) {
                ValueSpecification specification = constraint.getSpecification();
                if (specification instanceof OpaqueExpression && !((OpaqueExpression)specification).getBodies().isEmpty() && ((String)((OpaqueExpression)specification).getBodies().get(0)).equalsIgnoreCase(ELSE_CONDITION)) {
                    elseCondition.add(tr);
                    continue;
                }
                result.add(tr);
            }
        }
        result.addAll(elseCondition);
        return result;
    }

    public boolean exclusiveChoice(Element el, List<Transition> transitions) {
        ArrayList<String> bodies = new ArrayList<String>();
        for (Transition tr : transitions) {
            for (Constraint constraint : tr.getOwnedRules()) {
                ValueSpecification specification = constraint.getSpecification();
                if (!(specification instanceof OpaqueExpression) || ((OpaqueExpression)specification).getBodies().isEmpty()) continue;
                bodies.add((String)((OpaqueExpression)specification).getBodies().get(0));
            }
        }
        return this.exclusiveBody(bodies) && bodies.contains(ELSE_CONDITION);
    }

    private boolean exclusiveBody(List<String> bodies) {
        int i = 0;
        while (i < bodies.size()) {
            int j = i + 1;
            while (j < bodies.size()) {
                if (bodies.get(i).equalsIgnoreCase(bodies.get(j))) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }
}

