/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.activity.beans;

import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;

public class LoopStatementWrapper {
    private IASTStatement wrappedStatement;
    private IASTForStatement forStatement;
    private IASTWhileStatement whileStatement;
    private IASTDoStatement doStatement;
    private LoopType loopType;

    public LoopStatementWrapper(IASTStatement wrappedStatement) {
        this.wrappedStatement = wrappedStatement;
        if (wrappedStatement instanceof IASTForStatement) {
            this.forStatement = (IASTForStatement)wrappedStatement;
            this.loopType = LoopType.FOR;
        } else if (wrappedStatement instanceof IASTWhileStatement) {
            this.whileStatement = (IASTWhileStatement)wrappedStatement;
            this.loopType = LoopType.WHILE;
        } else if (wrappedStatement instanceof IASTDoStatement) {
            this.doStatement = (IASTDoStatement)wrappedStatement;
            this.loopType = LoopType.DO;
        }
    }

    public IASTStatement getWrappedStatement() {
        return this.wrappedStatement;
    }

    public IASTStatement getInitializerStatement() {
        if (this.isFor()) {
            return this.forStatement.getInitializerStatement();
        }
        return null;
    }

    public IASTExpression getConditionExpression() {
        IASTExpression condition = null;
        switch (this.loopType) {
            case FOR: {
                condition = this.forStatement.getConditionExpression();
                break;
            }
            case DO: {
                condition = this.doStatement.getCondition();
                break;
            }
            case WHILE: {
                condition = this.whileStatement.getCondition();
            }
        }
        return condition;
    }

    public IASTExpression getIterationExpression() {
        if (this.isFor()) {
            return this.forStatement.getIterationExpression();
        }
        return null;
    }

    public IASTStatement getBody() {
        IASTStatement body = null;
        switch (this.loopType) {
            case FOR: {
                body = this.forStatement.getBody();
                break;
            }
            case DO: {
                body = this.doStatement.getBody();
                break;
            }
            case WHILE: {
                body = this.whileStatement.getBody();
            }
        }
        return body;
    }

    public String getLoopNodeName() {
        String nodeName = this.wrappedStatement.getRawSignature();
        int bodyOffset = 0;
        int loopOffset = this.wrappedStatement.getFileLocation().getNodeOffset();
        switch (this.loopType) {
            case FOR: {
                bodyOffset = this.forStatement.getBody().getFileLocation().getNodeOffset();
                nodeName = nodeName.substring(0, bodyOffset - loopOffset);
                break;
            }
            case WHILE: {
                bodyOffset = this.whileStatement.getBody().getFileLocation().getNodeOffset();
                nodeName = nodeName.substring(0, bodyOffset - loopOffset);
                break;
            }
            case DO: {
                bodyOffset = this.doStatement.getBody().getFileLocation().getNodeOffset() + this.doStatement.getBody().getFileLocation().getNodeLength();
                nodeName = "do ..." + nodeName.substring(bodyOffset - loopOffset);
                break;
            }
        }
        return nodeName.trim();
    }

    public boolean isTestedFirst() {
        return this.loopType == LoopType.FOR || this.loopType == LoopType.WHILE;
    }

    public boolean isFor() {
        return this.loopType == LoopType.FOR;
    }

    public boolean isDo() {
        return this.loopType == LoopType.DO;
    }

    public boolean isWhile() {
        return this.loopType == LoopType.WHILE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LoopType {
        FOR,
        DO,
        WHILE;

    }
}

