/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.AddVariableValueAction;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.FinalNode;
import org.eclipse.uml2.uml.InitialNode;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.MergeNode;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Variable;
import org.eclipse.umlgen.reverse.java.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaReverseCUVisitor
extends ASTVisitor {
    private static final String ANNOTATION_ACTIVITY = "@activity";
    protected Package packageObject;
    protected String currentCUName;
    protected Activity currentActivity;
    protected InitialNode initNode;
    protected FinalNode finalNode;
    protected Statement lastStatement;
    protected ActivityNode lastActivityNode;
    protected Map<Statement, ActivityNode> entryNodeMap;
    protected Map<Statement, ActivityNode> exitNodeMap;
    protected Map<Statement, ActivityNode> innerExitMap;
    protected Map<Statement, ActivityNode> innerEntryMap;
    protected Map<Statement, ActivityNode> choiceMap;
    protected Map<Statement, Statement> choiceThenFMap;
    protected Map<Statement, Statement> choiceElseFMap;
    protected Map<Statement, Statement> choiceElseMap;
    protected Map<Statement, Statement> choiceThenMap;
    protected Map<Statement, ActivityNode> choiceOutMap;
    protected LiteralString lastGuard;
    protected List<Statement> parentStatements;
    protected String nextComment = "";
    protected boolean addcomment;
    protected String userCodeStartTag = "Start of user code";
    protected String userCodeStopTag = "End of user code";
    private boolean isAnnotatedOnly;
    private int countLoopStatment;
    private int countChoiceStatment;
    private String[] sources;
    private List<int[]> userCodeRanges;
    private boolean novisit;

    public JavaReverseCUVisitor(Package packageObject, boolean isAnnotatedOnly, String[] source) {
        this.packageObject = packageObject;
        this.isAnnotatedOnly = isAnnotatedOnly;
        this.currentCUName = null;
        this.sources = source;
    }

    private List<int[]> getRanges(CompilationUnit node) {
        ArrayList<int[]> userCodeRange = new ArrayList<int[]>();
        int range1 = -1;
        int range2 = -1;
        List listc = node.getCommentList();
        for (Comment com : listc) {
            if (!(com instanceof LineComment)) continue;
            LineComment linecom = (LineComment)com;
            int startpos = linecom.getStartPosition();
            int linepos = node.getLineNumber(startpos) - 1;
            String text = this.sources[linepos];
            if (text.indexOf(this.userCodeStartTag) > 0 && range1 < 0) {
                range1 = linecom.getStartPosition();
            }
            if (text.indexOf(this.userCodeStopTag) <= 0) continue;
            range2 = linecom.getStartPosition();
            int[] range = new int[]{range1, range2};
            userCodeRange.add(range);
            range1 = -1;
        }
        if (range1 > range2) {
            range2 = node.getLength() + 1;
            int[] range = new int[]{range1, range2};
            userCodeRange.add(range);
        }
        return userCodeRange;
    }

    public boolean preVisit2(ASTNode node) {
        if (this.userCodeRanges != null) {
            int r1 = node.getStartPosition();
            int r2 = node.getLength() + r1;
            for (int[] pair : this.userCodeRanges) {
                if (r1 <= pair[0] || r2 >= pair[1]) continue;
                this.novisit = true;
                return false;
            }
        }
        return true;
    }

    public void postVisit(ASTNode node) {
        if (this.currentActivity == null || this.novisit) {
            this.novisit = false;
            return;
        }
        if (node instanceof Statement && !this.exitNodeMap.containsKey(node)) {
            this.visitUnknownStat((Statement)node);
        }
        boolean ok1 = node.getParent() instanceof IfStatement;
        boolean ok2 = node.getParent() instanceof Block && node.getParent().getParent() instanceof IfStatement;
        boolean dolink = true;
        if (node instanceof Statement && (ok1 || ok2)) {
            IfStatement parent = ok2 ? (IfStatement)node.getParent().getParent() : (IfStatement)node.getParent();
            ArrayList<Statement> thenstat = new ArrayList<Statement>();
            if (this.isKindofBlock(parent.getThenStatement())) {
                thenstat.addAll(((Block)parent.getThenStatement()).statements());
            } else if (parent.getThenStatement() != null) {
                thenstat.add(parent.getThenStatement());
            }
            int nthen = 0;
            if (thenstat != null) {
                nthen = thenstat.size();
            }
            ArrayList<Statement> elsestat = new ArrayList<Statement>();
            if (this.isKindofBlock(parent.getElseStatement())) {
                elsestat.addAll(((Block)parent.getElseStatement()).statements());
            } else if (parent.getElseStatement() != null) {
                elsestat.add(parent.getElseStatement());
            }
            int nelse = elsestat.size();
            if (this.choiceThenFMap != null && this.choiceThenFMap.containsKey(parent) && this.choiceThenFMap.get(parent).equals((Object)node)) {
                ActivityNode source = this.innerExitMap.get(this.choiceThenFMap.get(parent));
                ActivityNode target = this.innerEntryMap.get(node);
                if (source != null && target != null) {
                    ControlFlow flow = this.createControlFlow(source, target);
                    flow.setName(String.valueOf(source.getName()) + "_toElse_" + target.getName());
                }
                this.choiceThenFMap.remove(node);
                dolink = false;
            } else if (this.choiceElseFMap != null && this.choiceElseFMap.containsKey(parent) && this.choiceElseFMap.get(parent).equals((Object)node)) {
                ActivityNode source = this.innerExitMap.get(this.choiceElseFMap.get(parent));
                ActivityNode target = this.innerEntryMap.get(node);
                if (source != null && target != null) {
                    ControlFlow flow = this.createControlFlow(source, target);
                    flow.setName(String.valueOf(source.getName()) + "_toThen_" + target.getName());
                }
                this.choiceElseFMap.remove(node);
                dolink = false;
            } else if (nthen > 0 && ((Statement)thenstat.get(nthen - 1)).equals((Object)node)) {
                this.choiceThenMap.put((Statement)parent, (Statement)node);
            } else if (nelse > 0 && ((Statement)elsestat.get(nelse - 1)).equals((Object)node)) {
                this.choiceElseMap.put((Statement)parent, (Statement)node);
            }
        }
        ActivityNode act = null;
        if (node instanceof Statement && "".equals(this.nextComment)) {
            this.nextComment = ((Statement)node).getLeadingComment();
            if (this.nextComment == null) {
                this.nextComment = "";
            }
            act = this.entryNodeMap.get(node);
        }
        if (act != null && !"".equals(this.nextComment)) {
            act.createOwnedComment().setBody(this.nextComment);
            this.addcomment = false;
            LogUtils.logCreation(null, null, node, "add comment" + this.nextComment);
            this.nextComment = "";
        }
        if (this.parentStatements != null && this.parentStatements.contains(node) && dolink) {
            this.linkToLastChild(node);
            this.parentStatements.remove(node);
            this.innerEntryMap.remove(node);
            this.innerExitMap.remove(node);
            this.lastStatement = (Statement)node;
        }
    }

    private boolean isKindofBlock(Statement stat) {
        if (stat == null) {
            return false;
        }
        try {
            Block cfr_ignored_0 = (Block)stat;
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean visit(CompilationUnit node) {
        if (node == null) {
            return false;
        }
        if (this.sources != null) {
            this.userCodeRanges = this.getRanges(node);
        }
        LogUtils.logEntering(null, null);
        this.currentCUName = node.getJavaElement().getElementName();
        LogUtils.logCreation(null, node, null, "Visit " + this.currentCUName + " for activity");
        LogUtils.logExiting();
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        boolean ret = false;
        this.entryNodeMap = new HashMap<Statement, ActivityNode>();
        this.exitNodeMap = new HashMap<Statement, ActivityNode>();
        this.innerExitMap = new HashMap<Statement, ActivityNode>();
        this.innerEntryMap = new HashMap<Statement, ActivityNode>();
        this.choiceMap = new HashMap<Statement, ActivityNode>();
        this.choiceThenFMap = new HashMap<Statement, Statement>();
        this.choiceElseFMap = new HashMap<Statement, Statement>();
        this.choiceThenMap = new HashMap<Statement, Statement>();
        this.choiceElseMap = new HashMap<Statement, Statement>();
        this.choiceOutMap = new HashMap<Statement, ActivityNode>();
        this.parentStatements = new ArrayList<Statement>();
        String methodname = node.getName().toString();
        TypeDeclaration classnode = null;
        String classname = "";
        NamedElement specObject = null;
        if (node.getParent() instanceof TypeDeclaration) {
            classnode = (TypeDeclaration)node.getParent();
            classname = classnode.getName().toString();
            specObject = this.packageObject.getOwnedMember(classname);
        }
        if (specObject != null && specObject instanceof Class) {
            Operation op;
            List params = node.parameters();
            ArrayList<String> paramTypeNames = new ArrayList<String>();
            EList pset = null;
            for (SingleVariableDeclaration p : params) {
                paramTypeNames.add(p.getType().toString());
            }
            if (paramTypeNames.size() == 0) {
                paramTypeNames = null;
            }
            if ((op = ((Class)specObject).getOwnedOperation(methodname, null, null)) != null) {
                pset = op.getOwnedParameters();
                boolean pnok = this.ctrlParamTypes(paramTypeNames, (EList<Parameter>)pset);
                EList ops2 = ((Class)specObject).getOperations();
                ArrayList<Operation> ops = new ArrayList<Operation>();
                for (Operation oo : ops2) {
                    if (!oo.getName().toString().equals(methodname)) continue;
                    ops.add(oo);
                }
                while (!pnok && ops.size() > 1) {
                    ops.remove(op);
                    op = (BehavioralFeature)ops.get(0);
                    pset = op.getOwnedParameters();
                    pnok = this.ctrlParamTypes(paramTypeNames, (EList<Parameter>)pset);
                }
                if (!pnok) {
                    op = null;
                }
            }
            if (op == null && (op = ((Class)specObject).getOwnedReception(methodname, null, null)) != null) {
                EList ops2 = ((Class)specObject).getOwnedReceptions();
                ArrayList<Reception> ops = new ArrayList<Reception>();
                for (Reception oo : ops2) {
                    if (!oo.getName().toString().equals(methodname)) continue;
                    ops.add(oo);
                }
                pset = op.getOwnedParameters();
                boolean pnok = this.ctrlParamTypes(paramTypeNames, (EList<Parameter>)pset);
                while (!pnok && ops.size() > 1) {
                    ops.remove(op);
                    op = (BehavioralFeature)ops.get(0);
                    pset = op.getOwnedParameters();
                    pnok = this.ctrlParamTypes(paramTypeNames, (EList<Parameter>)pset);
                }
                if (!pnok) {
                    op = null;
                }
            }
            if (op != null && this.isAnnotatedOnly) {
                List modifiers = node.modifiers();
                if (modifiers.isEmpty()) {
                    op = null;
                } else {
                    ArrayList<String> flags = new ArrayList<String>();
                    for (IExtendedModifier flag : modifiers) {
                        if (!flag.isAnnotation()) continue;
                        flags.add(flag.toString());
                    }
                    if (!flags.contains(ANNOTATION_ACTIVITY)) {
                        op = null;
                    }
                }
            }
            if (op != null) {
                this.currentActivity = UMLFactory.eINSTANCE.createActivity();
                this.currentActivity.setName(node.getName().toString());
                LogUtils.logEntering(this.currentActivity, "Activity for " + methodname);
                this.currentActivity.setSpecification((BehavioralFeature)op);
                ((BehavioredClassifier)specObject).getOwnedBehaviors().add((Object)this.currentActivity);
                for (Parameter paramOp : pset) {
                    ActivityParameterNode paramu = UMLFactory.eINSTANCE.createActivityParameterNode();
                    paramu.setName(paramOp.getName());
                    paramu.setActivity(this.currentActivity);
                    paramu.setType(paramOp.getType());
                    paramu.setParameter(paramOp);
                }
                this.initNode = UMLFactory.eINSTANCE.createInitialNode();
                this.initNode.setName("InitNode");
                this.initNode.setActivity(this.currentActivity);
                this.finalNode = UMLFactory.eINSTANCE.createActivityFinalNode();
                this.finalNode.setName("FinalNode");
                this.finalNode.setActivity(this.currentActivity);
                ret = true;
            }
        }
        return ret;
    }

    private boolean ctrlParamTypes(List<String> paramNames, EList<Parameter> pset) {
        boolean pnok = true;
        if (paramNames == null) {
            return pnok;
        }
        if (pset == null) {
            return false;
        }
        if (pset.size() < paramNames.size() || pset.size() > paramNames.size() + 1) {
            return false;
        }
        int ii = 0;
        while (ii < paramNames.size()) {
            String typename;
            Parameter pp = (Parameter)pset.get(ii);
            if (!(pp == null && pp.getType() == null || (typename = pp.getType().getName()).equals(paramNames.get(ii)))) {
                pnok = false;
            }
            ++ii;
        }
        return pnok;
    }

    public void endVisit(MethodDeclaration node) {
        if (!(this.lastStatement instanceof ReturnStatement) && this.currentActivity != null) {
            ActivityNode sourceNode = null;
            if (this.lastActivityNode != null) {
                sourceNode = this.lastActivityNode;
                this.lastActivityNode = null;
            } else if (this.lastStatement == null || !this.exitNodeMap.containsKey(this.lastStatement)) {
                sourceNode = this.initNode;
            } else if (this.exitNodeMap.containsKey(this.lastStatement)) {
                sourceNode = this.exitNodeMap.get(this.lastStatement);
            }
            this.createControlFlow((ActivityNode)this.finalNode, sourceNode);
        }
        LogUtils.logExiting();
        this.currentActivity = null;
    }

    public void visitUnknownStat(Statement node) {
        if (node instanceof DoStatement || node instanceof EnhancedForStatement || node instanceof BreakStatement || node instanceof SwitchStatement || node instanceof SwitchCase || node instanceof Block) {
            return;
        }
        OpaqueAction act = UMLFactory.eINSTANCE.createOpaqueAction();
        LogUtils.logCreation(null, null, act, null);
        act.setActivity(this.currentActivity);
        act.setName(node.toString().trim());
        this.entryNodeMap.put(node, (ActivityNode)act);
        this.exitNodeMap.put(node, (ActivityNode)act);
        this.linkToLastStatement(node);
        this.lastStatement = node;
        act.getLanguages().add((Object)"JAVA");
        act.getBodies().add((Object)node.toString());
    }

    public boolean visit(ReturnStatement node) {
        if (this.currentActivity == null) {
            return false;
        }
        this.entryNodeMap.put((Statement)node, (ActivityNode)this.finalNode);
        this.exitNodeMap.put((Statement)node, (ActivityNode)this.finalNode);
        this.linkToLastStatement((Statement)node);
        this.lastStatement = node;
        return false;
    }

    public boolean visit(BlockComment node) {
        this.nextComment = String.valueOf(this.nextComment) + node.toString();
        this.addcomment = true;
        return false;
    }

    public boolean visit(LineComment node) {
        this.nextComment = String.valueOf(this.nextComment) + node.toString();
        this.addcomment = true;
        return false;
    }

    public boolean visit(Javadoc node) {
        this.nextComment = String.valueOf(this.nextComment) + node.toString();
        this.addcomment = true;
        return false;
    }

    public boolean visit(WhileStatement node) {
        if (this.currentActivity == null) {
            return false;
        }
        MergeNode mergeNode = UMLFactory.eINSTANCE.createMergeNode();
        mergeNode.setActivity(this.currentActivity);
        DecisionNode decisionNode = UMLFactory.eINSTANCE.createDecisionNode();
        decisionNode.setActivity(this.currentActivity);
        LogUtils.logCreation(null, null, mergeNode, "Create while loop");
        this.entryNodeMap.put((Statement)node, (ActivityNode)mergeNode);
        this.exitNodeMap.put((Statement)node, (ActivityNode)decisionNode);
        this.parentStatements.add((Statement)node);
        this.innerExitMap.put((Statement)node, (ActivityNode)decisionNode);
        this.innerEntryMap.put((Statement)node, (ActivityNode)mergeNode);
        String name = node.toString();
        name = "While_" + this.countLoopStatment++;
        mergeNode.setName(String.valueOf(name) + "_merge");
        decisionNode.setName(String.valueOf(name) + "_cond");
        ControlFlow flow = this.createControlFlow((ActivityNode)decisionNode, (ActivityNode)mergeNode);
        LiteralString stringGuard = UMLFactory.eINSTANCE.createLiteralString();
        stringGuard.setValue(node.getExpression().toString());
        flow.setName(String.valueOf(name) + "_merge_cond");
        this.linkToLastStatement((Statement)node);
        this.lastStatement = node;
        this.lastGuard = stringGuard;
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(IfStatement node) {
        if (this.currentActivity == null) {
            return false;
        }
        DecisionNode decisionNode = UMLFactory.eINSTANCE.createDecisionNode();
        decisionNode.setActivity(this.currentActivity);
        MergeNode mergeNode = UMLFactory.eINSTANCE.createMergeNode();
        mergeNode.setActivity(this.currentActivity);
        String name = node.toString();
        name = "If_" + this.countChoiceStatment++;
        mergeNode.setName(String.valueOf(name) + "_merge");
        decisionNode.setName(String.valueOf(name) + "_cond");
        LogUtils.logCreation(null, null, decisionNode, "Create if structure");
        this.choiceMap.put((Statement)node, (ActivityNode)decisionNode);
        this.choiceOutMap.put((Statement)node, (ActivityNode)mergeNode);
        this.entryNodeMap.put((Statement)node, (ActivityNode)decisionNode);
        this.exitNodeMap.put((Statement)node, (ActivityNode)mergeNode);
        this.parentStatements.add((Statement)node);
        this.innerExitMap.put((Statement)node, (ActivityNode)decisionNode);
        this.innerEntryMap.put((Statement)node, (ActivityNode)mergeNode);
        this.linkToLastStatement((Statement)node);
        LiteralString stringGuard = UMLFactory.eINSTANCE.createLiteralString();
        stringGuard.setValue(node.getExpression().toString());
        if (node.getThenStatement() == null) {
            this.lastGuard = stringGuard;
            ControlFlow flow = this.createControlFlow((ActivityNode)mergeNode, (ActivityNode)decisionNode);
            flow.setGuard((ValueSpecification)stringGuard);
            this.lastGuard = null;
            flow.setName(String.valueOf(name) + "_then");
        } else {
            this.choiceThenFMap.put((Statement)node, node.getThenStatement());
            this.lastGuard = stringGuard;
        }
        if (node.getElseStatement() == null) {
            LiteralString elseGuard = UMLFactory.eINSTANCE.createLiteralString();
            elseGuard.setValue("else");
            ControlFlow flow = this.createControlFlow((ActivityNode)mergeNode, (ActivityNode)decisionNode);
            flow.setGuard((ValueSpecification)elseGuard);
            flow.setName(String.valueOf(name) + "_else");
            this.lastGuard = stringGuard;
        } else {
            this.choiceElseFMap.put((Statement)node, node.getElseStatement());
        }
        this.lastStatement = node;
        return true;
    }

    public void endVisit(IfStatement node) {
        ActivityNode act;
        ControlFlow flow;
        Statement lastThenNode;
        if (this.currentActivity == null) {
            return;
        }
        ActivityNode mergeNode = this.exitNodeMap.get(node);
        if (node.getThenStatement() != null && node.getElseStatement() != null && mergeNode != null && this.exitNodeMap.containsKey(lastThenNode = this.choiceThenMap.get(node)) && (flow = this.createControlFlow(mergeNode, act = this.exitNodeMap.get(lastThenNode))) != null) {
            flow.setName("thenPathTo_" + mergeNode.getName());
        }
    }

    public boolean visit(ForStatement node) {
        if (this.currentActivity == null) {
            return false;
        }
        MergeNode mergeNode = UMLFactory.eINSTANCE.createMergeNode();
        mergeNode.setActivity(this.currentActivity);
        String name = "For_" + this.countLoopStatment++;
        mergeNode.setName(String.valueOf(name) + "_merge");
        DecisionNode decisionNode = UMLFactory.eINSTANCE.createDecisionNode();
        decisionNode.setActivity(this.currentActivity);
        mergeNode.setName(String.valueOf(name) + "_cond");
        LogUtils.logCreation(null, null, mergeNode, "Create for loop");
        Variable index = UMLFactory.eINSTANCE.createVariable();
        index.setActivityScope(this.currentActivity);
        AddVariableValueAction indexNode = UMLFactory.eINSTANCE.createAddVariableValueAction();
        indexNode.setActivity(this.currentActivity);
        Expression expr = node.getExpression();
        List init = node.initializers();
        List incr = node.updaters();
        if (init.size() > 0) {
            String myName = init.size() > 0 ? init.get(0).toString() : init.toString();
            indexNode.setName(myName);
        } else {
            indexNode.setName("");
        }
        indexNode.setVariable(index);
        ControlFlow flow1 = this.createControlFlow((ActivityNode)mergeNode, (ActivityNode)indexNode);
        LiteralString stringGuard = UMLFactory.eINSTANCE.createLiteralString();
        flow1.setName(String.valueOf(indexNode.getName()) + "_merge");
        ControlFlow flow = this.createControlFlow((ActivityNode)decisionNode, (ActivityNode)mergeNode);
        if (expr != null) {
            stringGuard.setValue(expr.toString());
        }
        flow.setName(String.valueOf(name) + "_merge_cond");
        AddVariableValueAction incrNode = UMLFactory.eINSTANCE.createAddVariableValueAction();
        incrNode.setActivity(this.currentActivity);
        if (incr.size() > 0) {
            incrNode.setName(((Expression)incr.get(0)).toString());
        } else {
            incrNode.setName("");
        }
        flow = this.createControlFlow((ActivityNode)mergeNode, (ActivityNode)incrNode);
        flow.setName(String.valueOf(incrNode.getName()) + "_merge");
        this.entryNodeMap.put((Statement)node, (ActivityNode)indexNode);
        this.exitNodeMap.put((Statement)node, (ActivityNode)decisionNode);
        this.parentStatements.add((Statement)node);
        this.innerExitMap.put((Statement)node, (ActivityNode)decisionNode);
        this.innerEntryMap.put((Statement)node, (ActivityNode)incrNode);
        mergeNode.setName(String.valueOf(name) + "_merge");
        decisionNode.setName(String.valueOf(name) + "_cond");
        flow.setName(String.valueOf(name) + "_cond_merge");
        this.linkToLastStatement((Statement)node);
        this.lastStatement = node;
        this.lastGuard = stringGuard;
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public ActivityNode visitMethod(MethodInvocation node) {
        CallOperationAction act = UMLFactory.eINSTANCE.createCallOperationAction();
        act.setActivity(this.currentActivity);
        act.setName(node.getName().toString());
        LogUtils.logCreation(null, null, act, "Create method invocation");
        List args = node.arguments();
        for (Object arg : args) {
            act.createArgument(arg.toString(), null);
        }
        return act;
    }

    public boolean visit(ExpressionStatement node) {
        OpaqueAction act;
        if (this.currentActivity == null) {
            return false;
        }
        Expression expr = node.getExpression();
        Expression exprvar = null;
        Expression exprmeth = null;
        if (expr instanceof Assignment) {
            exprvar = ((Assignment)expr).getLeftHandSide();
            exprmeth = ((Assignment)expr).getRightHandSide();
        }
        if (expr instanceof MethodInvocation) {
            MethodInvocation callmeth = (MethodInvocation)expr;
            act = this.visitMethod(callmeth);
        } else if (expr instanceof Assignment && exprmeth instanceof MethodInvocation) {
            MethodInvocation callmeth = (MethodInvocation)exprmeth;
            act = this.visitMethod(callmeth);
            ((CallOperationAction)act).createResult(exprvar.toString(), null);
        } else {
            act = UMLFactory.eINSTANCE.createOpaqueAction();
            act.getLanguages().add((Object)"JAVA");
            act.getBodies().add((Object)node.toString());
        }
        act.setActivity(this.currentActivity);
        act.setName(node.toString().trim());
        LogUtils.logCreation(null, null, act, "Create expression declaration");
        this.entryNodeMap.put((Statement)node, (ActivityNode)act);
        this.exitNodeMap.put((Statement)node, (ActivityNode)act);
        this.linkToLastStatement((Statement)node);
        this.lastStatement = node;
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationStatement node) {
        if (this.currentActivity == null) {
            return false;
        }
        AddVariableValueAction act = UMLFactory.eINSTANCE.createAddVariableValueAction();
        act.setActivity(this.currentActivity);
        act.setName(node.toString().trim());
        this.entryNodeMap.put((Statement)node, (ActivityNode)act);
        this.exitNodeMap.put((Statement)node, (ActivityNode)act);
        this.linkToLastStatement((Statement)node);
        this.lastStatement = node;
        LogUtils.logCreation(null, null, act, "Create variable declaration");
        Variable var = UMLFactory.eINSTANCE.createVariable();
        var.setActivityScope(this.currentActivity);
        act.setVariable(var);
        act.setValue(null);
        return super.visit(node);
    }

    protected void linkToLastChild(ASTNode node) {
        ActivityNode targetNode = null;
        ActivityNode sourceNode = null;
        if (this.innerEntryMap.containsKey(node) && this.exitNodeMap.containsKey(this.lastStatement)) {
            targetNode = this.innerEntryMap.get(node);
            sourceNode = this.exitNodeMap.get(this.lastStatement);
        }
        this.createControlFlow(targetNode, sourceNode);
    }

    protected void linkToLastStatement(Statement node) {
        ActivityNode targetNode = null;
        ActivityNode sourceNode = null;
        if (this.lastStatement != null && this.parentStatements.contains(this.lastStatement)) {
            if (this.innerExitMap.containsKey(this.lastStatement)) {
                sourceNode = this.innerExitMap.get(this.lastStatement);
            }
        } else {
            IfStatement parent;
            LiteralString stringuard = UMLFactory.eINSTANCE.createLiteralString();
            stringuard.setValue("else");
            if (node.getParent().getNodeType() == 25 && this.choiceMap.containsKey(parent = (IfStatement)node.getParent()) && parent.getElseStatement() != null && parent.getElseStatement().equals((Object)node)) {
                sourceNode = this.choiceMap.get(parent);
                this.choiceMap.remove(parent);
                if (this.lastGuard == null) {
                    this.lastGuard = stringuard;
                }
            }
            if (node.getParent().getNodeType() == 8 && node.getParent().getParent().getNodeType() == 25) {
                Block block;
                parent = (IfStatement)node.getParent().getParent();
                if (parent.getElseStatement() instanceof IfStatement) {
                    AST ast = new AST();
                    block = (Block)ast.createInstance(8);
                    ArrayList<Statement> elseblock = new ArrayList<Statement>();
                    elseblock.add(parent.getElseStatement());
                } else {
                    block = (Block)parent.getElseStatement();
                }
                if (this.choiceMap.containsKey(parent) && block != null && block.statements().size() > 0 && block.statements().get(0).equals(node)) {
                    sourceNode = this.choiceMap.get(parent);
                    this.choiceMap.remove(parent);
                    if (this.lastGuard == null) {
                        this.lastGuard = stringuard;
                    }
                }
            }
        }
        if (this.entryNodeMap.containsKey(node)) {
            targetNode = this.entryNodeMap.get(node);
            if (sourceNode == null) {
                if (this.lastActivityNode != null) {
                    sourceNode = this.lastActivityNode;
                    this.lastActivityNode = null;
                } else if (this.lastStatement == null || !this.exitNodeMap.containsKey(this.lastStatement)) {
                    sourceNode = this.initNode;
                } else if (this.exitNodeMap.containsKey(this.lastStatement)) {
                    sourceNode = this.exitNodeMap.get(this.lastStatement);
                }
            }
        }
        this.createControlFlow(targetNode, sourceNode);
    }

    protected ControlFlow createControlFlow(ActivityNode targetNode, ActivityNode sourceNode) {
        if (sourceNode != null && targetNode != null) {
            if (sourceNode == targetNode || sourceNode instanceof FinalNode) {
                return null;
            }
            ControlFlow flow = UMLFactory.eINSTANCE.createControlFlow();
            flow.setSource(sourceNode);
            flow.setTarget(targetNode);
            flow.setActivity(this.currentActivity);
            String name = sourceNode.getName();
            if (name.length() > 30) {
                name = name.substring(0, 30);
            }
            if ((name = String.valueOf(name) + "_" + targetNode.getName()).length() > 60) {
                name = name.substring(0, 60);
            }
            flow.setName(name);
            LogUtils.logCreation(null, null, flow, null);
            if (sourceNode instanceof DecisionNode) {
                if (this.lastGuard != null) {
                    flow.setGuard((ValueSpecification)this.lastGuard);
                    this.lastGuard = null;
                } else {
                    LiteralString sGuard = UMLFactory.eINSTANCE.createLiteralString();
                    sGuard.setValue("else");
                    flow.setGuard((ValueSpecification)sGuard);
                }
            }
            return flow;
        }
        return null;
    }

    protected Type getUMLType(org.eclipse.jdt.core.dom.Type asttype) {
        String typeName = asttype.toString();
        DataType umltype = UMLFactory.eINSTANCE.createDataType();
        umltype.setName(typeName);
        return umltype;
    }
}

