/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.activity.comments;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.umlgen.reverse.c.activity.beans.CommentInfo;
import org.eclipse.umlgen.reverse.c.activity.util.UMLActivityFactory;

public class CommentBuilder {
    private static final String KEY_BEFORE = "COMMENT_BEFORE";
    private static final String KEY_INLINE = "COMMENT_INLINE";
    private static final String KEY_LAST_LINE = "COMMENT_LAST_LINE";
    private static final String KEY_SAME_LINE = "COMMENT_SAME_LINE";
    private UMLActivityFactory factory;

    public CommentBuilder(UMLActivityFactory factory) {
        this.factory = factory;
    }

    public void buildComment(OpaqueAction action, CommentInfo commentInfo) {
        if (commentInfo == null) {
            return;
        }
        if (commentInfo.hasBefore()) {
            action.getBodies().set(0, (Object)(String.valueOf(commentInfo.getBefore()) + "\n" + (String)action.getBodies().get(0)));
        }
        if (commentInfo.hasSameLine()) {
            action.getBodies().set(0, (Object)(String.valueOf((String)action.getBodies().get(0)) + " " + commentInfo.getSameLine()));
        }
        if (commentInfo.hasLastLine()) {
            action.getBodies().set(0, (Object)(String.valueOf((String)action.getBodies().get(0)) + "\n" + commentInfo.getLastLine()));
        }
    }

    public void buildComment(Element umlElement, CommentInfo commentInfo) {
        if (commentInfo == null) {
            return;
        }
        EAnnotation ann = this.createCommentAnnotation(commentInfo);
        umlElement.getEAnnotations().add((Object)ann);
    }

    private EAnnotation createCommentAnnotation(CommentInfo commentInfo) {
        EAnnotation ann = this.factory.createEAnnotation("http://www.eclipse.org/umlgen/c/documentation");
        if (commentInfo.hasBefore()) {
            ann.getDetails().put((Object)KEY_BEFORE, (Object)commentInfo.getBefore());
        }
        if (commentInfo.hasSameLine()) {
            ann.getDetails().put((Object)KEY_SAME_LINE, (Object)commentInfo.getSameLine());
        }
        if (commentInfo.hasInline()) {
            ann.getDetails().put((Object)KEY_INLINE, (Object)commentInfo.getInline());
        }
        if (commentInfo.hasLastLine()) {
            ann.getDetails().put((Object)KEY_LAST_LINE, (Object)commentInfo.getLastLine());
        }
        return ann;
    }
}

