/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.java.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.VisibilityKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassifierServices {
    public List<Operation> getAllInheritedOperations(Class aClass) {
        Object operations;
        LinkedHashSet<Operation> inheritedOperations = new LinkedHashSet<Operation>();
        List<Class> allGeneralizedClasses = this.getAllGeneralizedClasses(aClass);
        for (Class aGeneralizedClass : allGeneralizedClasses) {
            operations = aGeneralizedClass.getOperations();
            Iterator iterator = operations.iterator();
            while (iterator.hasNext()) {
                Operation operation = (Operation)iterator.next();
                if (!operation.isAbstract()) continue;
                inheritedOperations.add(operation);
            }
        }
        EList implementedInterfaces = aClass.getImplementedInterfaces();
        for (Interface anInterface : implementedInterfaces) {
            inheritedOperations.addAll((Collection<Operation>)anInterface.getAllOperations());
        }
        ArrayList<Operation> operationsToRemove = new ArrayList<Operation>();
        for (Operation inheritedOperation : inheritedOperations) {
            boolean shouldRemoveOperation = false;
            EList ownedOperations = aClass.getOwnedOperations();
            for (Operation ownedOperation : ownedOperations) {
                if (!this.areEqual(ownedOperation, inheritedOperation)) continue;
                shouldRemoveOperation = true;
                break;
            }
            if (!shouldRemoveOperation) {
                block5: for (Class aGeneralizedClass : allGeneralizedClasses) {
                    EList generalizedClassOperations = aGeneralizedClass.getOwnedOperations();
                    for (Operation generalizedClassOperation : generalizedClassOperations) {
                        if (generalizedClassOperation == inheritedOperation || !this.canOverride(generalizedClassOperation, inheritedOperation) || !this.areEqual(generalizedClassOperation, inheritedOperation)) continue;
                        shouldRemoveOperation = true;
                        continue block5;
                    }
                }
            }
            if (!shouldRemoveOperation) {
                for (Operation otherInheritedOperation : inheritedOperations) {
                    if (!this.areEqual(inheritedOperation, otherInheritedOperation)) continue;
                    if (VisibilityKind.PUBLIC_LITERAL.equals((Object)otherInheritedOperation.getVisibility()) && !VisibilityKind.PUBLIC_LITERAL.equals((Object)inheritedOperation.getVisibility())) {
                        shouldRemoveOperation = true;
                        break;
                    }
                    if (VisibilityKind.PACKAGE_LITERAL.equals((Object)otherInheritedOperation.getVisibility()) && !VisibilityKind.PUBLIC_LITERAL.equals((Object)inheritedOperation.getVisibility())) {
                        shouldRemoveOperation = true;
                        break;
                    }
                    if (!VisibilityKind.PROTECTED_LITERAL.equals((Object)otherInheritedOperation.getVisibility()) || !VisibilityKind.PRIVATE_LITERAL.equals((Object)inheritedOperation.getVisibility())) continue;
                    shouldRemoveOperation = true;
                    break;
                }
            }
            if (!shouldRemoveOperation) continue;
            operationsToRemove.add(inheritedOperation);
        }
        inheritedOperations.removeAll(operationsToRemove);
        operations = new ArrayList();
        operations.addAll(inheritedOperations);
        return operations;
    }

    private boolean canOverride(Operation generalizedClassOperation, Operation inheritedOperation) {
        return !generalizedClassOperation.isAbstract() && !VisibilityKind.PRIVATE_LITERAL.equals((Object)generalizedClassOperation.getVisibility());
    }

    private boolean areEqual(Operation generalizedClassOperation, Operation inheritedOperation) {
        if (generalizedClassOperation.getName() != null && generalizedClassOperation.getName().equals(inheritedOperation.getName())) {
            EList generalizedClassOperationParameters = generalizedClassOperation.getOwnedParameters();
            int generalizedClassOperationParametersSize = generalizedClassOperationParameters.size();
            EList inheritedOperationParameters = inheritedOperation.getOwnedParameters();
            EList returnResult = generalizedClassOperation.returnResult();
            int returnResultSize = returnResult.size();
            EList inheritedOperationReturnResult = inheritedOperation.returnResult();
            if (generalizedClassOperationParametersSize == inheritedOperationParameters.size() && returnResultSize == inheritedOperationReturnResult.size()) {
                int i = 0;
                while (i < generalizedClassOperationParametersSize) {
                    Type inheritedOperationParameterType = ((Parameter)inheritedOperationParameters.get(i)).getType();
                    Type generalizedClassOperationParameterType = ((Parameter)generalizedClassOperationParameters.get(i)).getType();
                    if (inheritedOperationParameterType == null ? generalizedClassOperationParameterType != null : !inheritedOperationParameterType.conformsTo(generalizedClassOperationParameterType)) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < returnResultSize) {
                    Type inheritedOperationReturnResultType = ((Parameter)inheritedOperationReturnResult.get(i)).getType();
                    Type returnResultType = ((Parameter)returnResult.get(i)).getType();
                    if (inheritedOperationReturnResultType == null ? returnResultType != null : !inheritedOperationReturnResultType.conformsTo(returnResultType)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    private List<Class> getAllGeneralizedClasses(Class aClass) {
        ArrayList<Class> generalizedClass = new ArrayList<Class>();
        EList generalizations = aClass.getGeneralizations();
        for (Generalization generalization : generalizations) {
            Classifier aClassifier = generalization.getGeneral();
            if (!(aClassifier instanceof Class)) continue;
            Class anInheritedClass = (Class)aClassifier;
            generalizedClass.add(anInheritedClass);
            generalizedClass.addAll(this.getAllGeneralizedClasses(anInheritedClass));
        }
        return generalizedClass;
    }
}

