/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.java.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.umlgen.gen.java.services.UML2JavaConfigurationHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportServices {
    private static final String IMPORT = "import ";
    private static final String END_IMPORT = ";" + System.getProperty("line.separator");
    private static final List<String> JAVA_LANG_TYPES = Arrays.asList("Boolean", "boolean", "Integer", "int", "String", "char", "Char", "long", "Long", "double", "Double", "Float", "float", "Byte", "byte");
    private static final List<String> JAVA_UTIL_TYPES = Arrays.asList("Date");

    public String reqImport(Classifier aClassifier) {
        Set<String> importedTypes = this.typeToImports(aClassifier);
        ArrayList<String> sortedImportedTypes = new ArrayList<String>(importedTypes);
        Collections.sort(sortedImportedTypes);
        ArrayList<String> importedTypesToRemove = new ArrayList<String>();
        List<String> packagesToIgnoreDuringImports = UML2JavaConfigurationHolder.getPackagesToIgnoreDuringImports((EObject)aClassifier);
        for (String packageToIgnoreDuringImports : packagesToIgnoreDuringImports) {
            for (String string : sortedImportedTypes) {
                String sortedImportedTypePackage;
                int lastIndexOfDot = string.lastIndexOf(46);
                if (lastIndexOfDot == -1 || !(sortedImportedTypePackage = string.substring(0, lastIndexOfDot)).equals(packageToIgnoreDuringImports)) continue;
                importedTypesToRemove.add(string);
            }
        }
        sortedImportedTypes.removeAll(importedTypesToRemove);
        importedTypesToRemove.clear();
        List<String> typesToIgnoreDuringTheImports = UML2JavaConfigurationHolder.getTypesToIgnoreDuringTheImports((EObject)aClassifier);
        for (String typeToIgnoreDuringTheImports : typesToIgnoreDuringTheImports) {
            for (String sortedImportedType : sortedImportedTypes) {
                if (!sortedImportedType.equals(typeToIgnoreDuringTheImports) && !sortedImportedType.endsWith(String.valueOf('.') + typeToIgnoreDuringTheImports)) continue;
                importedTypesToRemove.add(sortedImportedType);
            }
        }
        sortedImportedTypes.removeAll(importedTypesToRemove);
        importedTypesToRemove.clear();
        String qualifiedName = this.qualifiedName((Type)aClassifier, false);
        if (qualifiedName != null) {
            int n = qualifiedName.lastIndexOf(46);
            if (n == -1) {
                for (String sortedImportedType : sortedImportedTypes) {
                    if (sortedImportedType.indexOf(46) != -1) continue;
                    importedTypesToRemove.add(sortedImportedType);
                }
            } else {
                String packageName = qualifiedName.substring(0, n);
                for (String sortedImportedType : sortedImportedTypes) {
                    if (!sortedImportedType.startsWith(packageName) || sortedImportedType.indexOf(46, packageName.length()) != -1) continue;
                    importedTypesToRemove.add(sortedImportedType);
                }
            }
        }
        sortedImportedTypes.removeAll(importedTypesToRemove);
        StringBuilder stringBuilder = new StringBuilder();
        for (String importedType : sortedImportedTypes) {
            stringBuilder.append(IMPORT + importedType + END_IMPORT);
        }
        return stringBuilder.toString();
    }

    private Set<String> typeToImports(Classifier aClassifier) {
        LinkedHashSet<String> importedTypes;
        block14: {
            EList nestedClassifiers;
            block13: {
                Class aClass;
                importedTypes = new LinkedHashSet<String>();
                boolean ignoreJavaTypes = UML2JavaConfigurationHolder.shouldIgnoreJavaTypes((EObject)aClassifier);
                EList attributes = aClassifier.getAttributes();
                for (Property property : attributes) {
                    String collectionQualifiedName;
                    String qualifiedName = this.qualifiedName(property.getType(), ignoreJavaTypes);
                    if (qualifiedName != null) {
                        importedTypes.add(qualifiedName);
                    }
                    if (property.getUpper() == 1 || (collectionQualifiedName = this.collectionQualifiedName(aClassifier, property.isOrdered(), property.isUnique())) == null) continue;
                    importedTypes.add(collectionQualifiedName);
                }
                EList operations = aClassifier.getOperations();
                for (Operation operation : operations) {
                    String collectionQualifiedName;
                    Object qualifiedName = this.qualifiedName(operation.getType(), ignoreJavaTypes);
                    if (qualifiedName != null) {
                        importedTypes.add((String)qualifiedName);
                    }
                    if (operation.getUpper() != 1 && (collectionQualifiedName = this.collectionQualifiedName(aClassifier, operation.isOrdered(), operation.isUnique())) != null) {
                        importedTypes.add(collectionQualifiedName);
                    }
                    EList ownedParameters = operation.getOwnedParameters();
                    for (Parameter parameter : ownedParameters) {
                        String collectionQualifiedName2;
                        qualifiedName = this.qualifiedName(parameter.getType(), ignoreJavaTypes);
                        if (qualifiedName != null) {
                            importedTypes.add((String)qualifiedName);
                        }
                        if (parameter.getUpper() == 1 || (collectionQualifiedName2 = this.collectionQualifiedName(aClassifier, parameter.isOrdered(), parameter.isUnique())) == null) continue;
                        importedTypes.add(collectionQualifiedName2);
                    }
                    EList raisedExceptions = operation.getRaisedExceptions();
                    for (Type type : raisedExceptions) {
                        String exceptionQualifiedName = this.qualifiedName(type, ignoreJavaTypes);
                        if (exceptionQualifiedName == null) continue;
                        importedTypes.add(exceptionQualifiedName);
                    }
                }
                EList generalizations = aClassifier.getGeneralizations();
                for (Generalization generalization : generalizations) {
                    importedTypes.add(this.qualifiedName((Type)generalization.getGeneral(), ignoreJavaTypes));
                }
                if (aClassifier instanceof Class) {
                    aClass = (Class)aClassifier;
                    EList interfaceRealizations = aClass.getInterfaceRealizations();
                    for (InterfaceRealization interfaceRealization : interfaceRealizations) {
                        importedTypes.add(this.qualifiedName((Type)interfaceRealization.getContract(), ignoreJavaTypes));
                    }
                }
                if (!(aClassifier instanceof Class)) break block13;
                aClass = (Class)aClassifier;
                nestedClassifiers = aClass.getNestedClassifiers();
                for (Classifier aNestedClassifier : nestedClassifiers) {
                    importedTypes.addAll(this.typeToImports(aNestedClassifier));
                }
                break block14;
            }
            if (!(aClassifier instanceof Interface)) break block14;
            Interface anInterface = (Interface)aClassifier;
            nestedClassifiers = anInterface.getNestedClassifiers();
            for (Classifier aNestedClassifier : nestedClassifiers) {
                importedTypes.addAll(this.typeToImports(aNestedClassifier));
            }
        }
        return importedTypes;
    }

    private String collectionQualifiedName(Classifier aClassifier, boolean ordered, boolean unique) {
        String result = "";
        if (ordered && unique) {
            result = UML2JavaConfigurationHolder.getOrderedUniqueCollectionsType((EObject)aClassifier);
        } else if (ordered && !unique) {
            result = UML2JavaConfigurationHolder.getOrderedNotUniqueCollectionsType((EObject)aClassifier);
        } else if (!ordered && unique) {
            result = UML2JavaConfigurationHolder.getNotOrderedUniqueCollectionsType((EObject)aClassifier);
        } else if (!ordered && !unique) {
            result = UML2JavaConfigurationHolder.getNotOrderedNotUniqueCollectionsType((EObject)aClassifier);
        }
        return result;
    }

    private String qualifiedName(Type type, boolean ignoreJavaTypes) {
        String result = null;
        if (type != null && !(type instanceof PrimitiveType)) {
            ArrayList<String> packagesName = new ArrayList<String>();
            EObject eContainer = type.eContainer();
            while (eContainer != null && eContainer instanceof Package && !(eContainer instanceof Model)) {
                Package umlPackage = (Package)eContainer;
                packagesName.add(umlPackage.getName());
                eContainer = umlPackage.eContainer();
            }
            Collections.reverse(packagesName);
            StringBuilder stringBuilder = new StringBuilder();
            for (String packageName : packagesName) {
                stringBuilder.append(packageName);
                stringBuilder.append('.');
            }
            stringBuilder.append(type.getName());
            result = stringBuilder.toString();
            if (ignoreJavaTypes && JAVA_LANG_TYPES.contains(type.getName())) {
                result = null;
            } else if (JAVA_UTIL_TYPES.contains(type.getName())) {
                result = "java.util." + type.getName();
            }
        } else if (type instanceof PrimitiveType && JAVA_UTIL_TYPES.contains(type.getName())) {
            result = "java.util." + type.getName();
        }
        return result;
    }
}

