/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.c.modeler.interactions.templates;

import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;

public abstract class AbstractExtensionManager
implements IRegistryChangeListener {
    private String extensionPointId;

    protected AbstractExtensionManager(String extensionPointId) {
        if (extensionPointId == null || extensionPointId.length() == 0) {
            throw new IllegalArgumentException("extensionPointId cannot be null or empty.");
        }
        this.extensionPointId = extensionPointId;
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void dispose() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    protected abstract void addExtension(IExtension var1);

    protected abstract void removeExtension(IExtension var1);

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] delta;
        if (!Platform.isRunning()) {
            return;
        }
        IExtensionDelta[] iExtensionDeltaArray = delta = event.getExtensionDeltas(this.extensionPointId);
        int n = delta.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionDelta element = iExtensionDeltaArray[n2];
            switch (element.getKind()) {
                case 1: {
                    this.addExtension(element.getExtension());
                    break;
                }
                case 2: {
                    this.removeExtension(element.getExtension());
                    break;
                }
            }
            ++n2;
        }
    }

    protected void readRegistry() {
        IExtension[] extensions;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(this.extensionPointId);
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.addExtension(extension);
            ++n2;
        }
    }
}

