/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.c.modeler.interactions.model;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.umlgen.c.common.Activator;
import org.eclipse.umlgen.c.common.interactions.extension.IModelSynchronizer;
import org.eclipse.umlgen.c.common.ui.PreferenceStoreManager;
import org.eclipse.umlgen.c.common.util.ModelManager;
import org.eclipse.umlgen.c.modeler.interactions.Messages;
import org.eclipse.umlgen.c.modeler.interactions.templates.Template;
import org.eclipse.umlgen.c.modeler.interactions.templates.TemplatesManager;
import org.eclipse.umlgen.reverse.c.resource.ProjectUtil;

public class ModelSynchronizer
implements IModelSynchronizer {
    protected static final String NAME = "name";
    protected static final String ESCAPED_NAME = "escapedName";
    protected static final String CHARSET = "charset";
    private static final String TEMPLATE_ID = "org.eclipse.umlgen.c.modeler.interactions.template";

    public ModelManager createModelManager(IResource model) {
        return new ModelManager(model);
    }

    public IFile createModel(IProject project) throws CoreException {
        String modelFileName;
        IFile modelFile;
        IFolder modelFolder = project.getFolder("Models");
        if (!modelFolder.isAccessible()) {
            modelFolder.create(false, true, null);
        }
        if (ProjectUtil.hasNature((IProject)project, (String)"org.eclipse.umlgen.reverse.c.syncNature")) {
            ICProjectDescription description = CoreModel.getDefault().createProjectDescription(project, true);
            ICConfigurationDescription defaultConfiguration = description.getActiveConfiguration();
            try {
                ICSourceEntry[] newEntries = CDataUtil.setExcluded((IPath)modelFolder.getFullPath(), (boolean)(modelFolder instanceof IFolder), (boolean)true, (ICSourceEntry[])defaultConfiguration.getSourceEntries());
                defaultConfiguration.setSourceEntries(newEntries);
                description.setActiveConfiguration(defaultConfiguration);
                CoreModel.getDefault().setProjectDescription(project, description);
            }
            catch (CoreException e) {
                Activator.log((Throwable)e);
            }
        }
        if ((modelFile = modelFolder.getFile(modelFileName = project.getFullPath().addFileExtension("uml").lastSegment())).exists()) {
            boolean result = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)this.getString("C2UMLSyncNature.dialog.title"), (String)this.getString("C2UMLSyncNature.dialog.question"));
            if (!result) {
                return null;
            }
        } else {
            this.createModel(project, modelFolder);
        }
        return modelFile;
    }

    protected void createModel(IProject project, IFolder modelFolder) throws CoreException {
        Template template = TemplatesManager.getInstance().find(TEMPLATE_ID).getTemplateModel();
        template.setDestination((IContainer)modelFolder);
        template.addVariable(NAME, project.getName());
        template.addVariable(ESCAPED_NAME, URI.encodeFragment((String)project.getName(), (boolean)false));
        template.addVariable(CHARSET, project.getDefaultCharset(true));
        template.generate((IProgressMonitor)new NullProgressMonitor());
    }

    protected String getString(String key) {
        return Messages.getString(key);
    }

    public void setDefaultValues(IProject project) {
        PreferenceStoreManager.setDefaultValues((IProject)project);
    }

    public void setInitialValues(IProject project) {
        PreferenceStoreManager.setInitialValues((IProject)project);
    }
}

