/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.c.modeler.interactions.templates;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.umlgen.c.modeler.interactions.templates.Template;
import org.osgi.framework.Bundle;

public class TemplateDescriptor {
    public static final String TAG_TEMPLATE = "template";
    public static final String ATT_ID = "id";
    public static final String ATT_MODEL = "model";
    private String id;
    private String model;
    private IConfigurationElement configElement;

    TemplateDescriptor(IConfigurationElement element) throws CoreException {
        this.configElement = element;
        this.load();
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    private void load() throws CoreException {
        this.id = this.configElement.getAttribute(ATT_ID);
        this.model = this.configElement.getAttribute(ATT_MODEL);
        if (this.id == null || this.model == null) {
            throw new CoreException((IStatus)new Status(4, this.configElement.getNamespace(), 0, "Invalid extension (missing id, name, editorId, model or di attribute): " + this.id, null));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getModel() {
        return this.model;
    }

    public Template getTemplateModel() {
        return new Template(this.getFile(this.model));
    }

    private File getFile(String relativePath) {
        try {
            Bundle extensionBundle = Platform.getBundle((String)this.configElement.getDeclaringExtension().getNamespace());
            URL templateFileURL = extensionBundle.getEntry(relativePath);
            return new File(Platform.asLocalURL((URL)templateFileURL).getFile());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

