/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.c.builder;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.umlgen.c.common.util.ModelManager;
import org.eclipse.umlgen.gen.c.builder.internal.UML2CBuilderBundle;
import org.eclipse.umlgen.gen.c.files.Generate;
import org.eclipse.umlgen.reverse.c.event.AbstractCModelChangedEvent;
import org.eclipse.umlgen.reverse.c.resource.C2UMLSyncNature;

public class UML2CBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.umlgen.gen.c.builder";
    private static final int TICKS = 50;
    private ModelManager manager;

    private void doBuild(IResource resource, Resource umlResource) throws IOException {
        this.doBuild(resource, umlResource, (IProgressMonitor)new NullProgressMonitor());
    }

    private void doBuild(IResource resource, Resource umlResource, IProgressMonitor monitor) throws IOException {
        File rootFolder = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        Generate gen = new Generate((EObject)umlResource.getContents().get(0), rootFolder, Collections.emptyList());
        gen.doGenerate((Monitor)new BasicMonitor.EclipseSubProgress(monitor, 50));
        try {
            try {
                resource.getProject().refreshLocal(2, (IProgressMonitor)new BasicMonitor.EclipseSubProgress(monitor, 50));
            }
            catch (CoreException coreException) {
                this.manager.dispose();
                this.manager = null;
            }
        }
        finally {
            this.manager.dispose();
            this.manager = null;
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 10 || kind == 9) {
            BuilderDeltaVisitor visitor = new BuilderDeltaVisitor(monitor);
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)visitor);
            }
        }
        return null;
    }

    public void build(IResource modelFile) {
        ModelManager modelManager = this.getModelManager(modelFile);
        Resource umlResource = modelManager.getModelResource();
        try {
            this.doBuild(modelFile, umlResource);
        }
        catch (IOException e) {
            UML2CBuilderBundle.log(e);
        }
    }

    protected ModelManager getModelManager(AbstractCModelChangedEvent event) {
        if (this.manager == null || !this.manager.getProject().equals((Object)event.getTranslationUnit().getResource().getProject())) {
            this.manager = new ModelManager(event.getTranslationUnit().getResource());
        }
        return this.manager;
    }

    protected ModelManager getModelManager(IResource rsc) {
        if (this.manager == null || !this.manager.getProject().equals((Object)rsc.getProject())) {
            this.manager = new ModelManager(rsc);
        }
        return this.manager;
    }

    protected ModelManager getModelManager() {
        return this.manager;
    }

    private final class BuilderDeltaVisitor
    implements IResourceDeltaVisitor {
        private final IProgressMonitor monitor;

        private BuilderDeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta.getKind() == 4) {
                IResource resource = delta.getResource();
                IProject project = resource.getProject();
                if ("uml".equalsIgnoreCase(resource.getFileExtension()) && project != null && C2UMLSyncNature.isC2UMLSynchProject((IProject)project)) {
                    ModelManager modelManager = UML2CBuilder.this.getModelManager(resource);
                    if (URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true).equals(modelManager.getModelResource().getURI())) {
                        Resource umlResource = modelManager.getModelResource();
                        try {
                            UML2CBuilder.this.doBuild(resource, umlResource, this.monitor);
                        }
                        catch (IOException e) {
                            UML2CBuilderBundle.log(e);
                        }
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

