/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.activity.builder;

import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.uml2.uml.ActivityFinalNode;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.FlowFinalNode;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.umlgen.reverse.c.activity.UMLActivityBuilder;
import org.eclipse.umlgen.reverse.c.activity.beans.ActivityContext;
import org.eclipse.umlgen.reverse.c.activity.beans.ActivityNodesPins;
import org.eclipse.umlgen.reverse.c.activity.builder.AbstractBuilder;
import org.eclipse.umlgen.reverse.c.activity.comments.CommentBuilder;
import org.eclipse.umlgen.reverse.c.activity.util.UMLActivityFactory;

public class FlowControlStatementBuilder
extends AbstractBuilder {
    public FlowControlStatementBuilder(UMLActivityBuilder activityBuilder, UMLActivityFactory factory, CommentBuilder commentBuilder) {
        super(activityBuilder, factory, commentBuilder);
    }

    public ActivityNodesPins buildBreakStatement(IASTBreakStatement stmt, ActivityContext currentContext) {
        FlowFinalNode flowFinal = this.factory.getFlowFinalNodeForBreak(currentContext);
        this.commentBuilder.buildComment((Element)flowFinal, this.getCommentInfo((IASTNode)stmt));
        return new ActivityNodesPins((ActivityNode)flowFinal, (ActivityNode)flowFinal);
    }

    public ActivityNodesPins buildContinueStatement(IASTContinueStatement stmt, ActivityContext currentContext) {
        FlowFinalNode flowFinal = this.factory.getFlowFinalNodeForContinue(currentContext);
        this.commentBuilder.buildComment((Element)flowFinal, this.getCommentInfo((IASTNode)stmt));
        return new ActivityNodesPins((ActivityNode)flowFinal, (ActivityNode)flowFinal);
    }

    public ActivityNodesPins buildReturnStatement(IASTReturnStatement stmt, ActivityContext currentContext) {
        OpaqueAction returnAction = this.factory.createOpaqueAction(stmt.getRawSignature(), currentContext);
        this.commentBuilder.buildComment(returnAction, this.getCommentInfo((IASTNode)stmt));
        ActivityFinalNode finalNode = this.factory.createActivityFinalNode(currentContext);
        this.factory.addFlowTowardsActivityFinalNode((ActivityNode)returnAction, (ActivityNode)finalNode, currentContext);
        return new ActivityNodesPins((ActivityNode)returnAction, (ActivityNode)finalNode);
    }
}

