/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.c.ui.internal.handler;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.umlgen.c.common.interactions.SynchronizersManager;
import org.eclipse.umlgen.c.common.interactions.extension.IDiagramSynchronizer;
import org.eclipse.umlgen.c.common.util.ModelManager;
import org.eclipse.umlgen.gen.c.files.Generate;

public class GenerateCCodeFromUML
extends AbstractHandler {
    private ModelManager manager;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block15: {
            try {
                IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
                EObject selectedObject = null;
                Object obj = selection.getFirstElement();
                if (obj instanceof IFile) {
                    this.manager = new ModelManager((IResource)((IFile)obj));
                    Resource umlResource = this.manager.getModelResource();
                    if (umlResource.getContents().size() > 0) {
                        this.doGenerate((EObject)umlResource.getContents().get(0));
                    }
                    break block15;
                }
                if (!(obj instanceof EObject)) break block15;
                selectedObject = (EObject)obj;
                IResource model = ResourcesPlugin.getWorkspace().getRoot().findMember(selectedObject.eResource().getURI().toPlatformString(true));
                this.manager = new ModelManager(model);
                EClass eClass = selectedObject.eClass();
                if (eClass == UMLPackage.Literals.ACTIVITY) {
                    this.caseActivity((Activity)selectedObject);
                    break block15;
                }
                if (eClass == UMLPackage.Literals.OPERATION) {
                    this.caseOperation((Operation)selectedObject);
                    break block15;
                }
                if (eClass == UMLPackage.Literals.CLASS) {
                    this.caseClass((Class)selectedObject);
                    break block15;
                }
                if (eClass == UMLPackage.Literals.INTERFACE) {
                    this.caseClass((Interface)selectedObject);
                    break block15;
                }
                if (eClass == UMLPackage.Literals.PACKAGE) {
                    this.casePackage((Package)selectedObject);
                    break block15;
                }
                if (eClass == UMLPackage.Literals.OPAQUE_BEHAVIOR) {
                    this.caseOpaqueBehavior((OpaqueBehavior)selectedObject);
                    break block15;
                }
                if (SynchronizersManager.getSynchronizer() instanceof IDiagramSynchronizer && eClass == ((IDiagramSynchronizer)SynchronizersManager.getSynchronizer()).getRepresentationKind()) {
                    this.caseDiagram(selectedObject);
                    break block15;
                }
                throw new ExecutionException("Bad object's class");
            }
            finally {
                if (this.manager != null) {
                    this.manager.dispose();
                    this.manager = null;
                }
            }
        }
        return null;
    }

    private void caseDiagram(EObject selectedObject) throws ExecutionException {
        this.doGenerate((EObject)this.manager.getSourcePackage());
    }

    private void caseOpaqueBehavior(OpaqueBehavior selectedObject) throws ExecutionException {
        this.caseClass((Class)selectedObject.eContainer());
    }

    private void casePackage(Package selectedObject) throws ExecutionException {
        this.doGenerate((EObject)selectedObject);
    }

    private void doGenerate(EObject eObject) throws ExecutionException {
        try {
            Generate gen = new Generate(eObject, ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), Collections.emptyList());
            gen.doGenerate((Monitor)new BasicMonitor());
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        try {
            this.manager.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    private void caseClass(Class selectedObject) throws ExecutionException {
        this.doGenerate((EObject)selectedObject);
    }

    private void caseClass(Interface selectedObject) throws ExecutionException {
        this.doGenerate((EObject)selectedObject);
    }

    private void caseOperation(Operation selectedObject) throws ExecutionException {
        this.caseClass((Class)selectedObject.eContainer());
    }

    private void caseActivity(Activity selectedObject) throws ExecutionException {
        this.caseClass((Class)selectedObject.eContainer().eContainer());
    }
}

