/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.internal.reconciler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.umlgen.c.common.util.ModelUtil;
import org.eclipse.umlgen.reverse.c.event.AbstractCModelChangedEvent;
import org.eclipse.umlgen.reverse.c.event.EnumerationAdded;
import org.eclipse.umlgen.reverse.c.event.EnumerationRemoved;
import org.eclipse.umlgen.reverse.c.event.FunctionDeclarationAdded;
import org.eclipse.umlgen.reverse.c.event.FunctionDeclarationRemoved;
import org.eclipse.umlgen.reverse.c.event.IncludeAdded;
import org.eclipse.umlgen.reverse.c.event.IncludeRemoved;
import org.eclipse.umlgen.reverse.c.event.MacroAdded;
import org.eclipse.umlgen.reverse.c.event.MacroRemoved;
import org.eclipse.umlgen.reverse.c.event.StructAdded;
import org.eclipse.umlgen.reverse.c.event.StructRemoved;
import org.eclipse.umlgen.reverse.c.event.TypeDefAdded;
import org.eclipse.umlgen.reverse.c.event.TypeDefArrayAdded;
import org.eclipse.umlgen.reverse.c.event.TypeDefArrayRemoved;
import org.eclipse.umlgen.reverse.c.event.TypeDefEnumerationAdded;
import org.eclipse.umlgen.reverse.c.event.TypeDefEnumerationRemoved;
import org.eclipse.umlgen.reverse.c.event.TypeDefFunctionDeclarationAdded;
import org.eclipse.umlgen.reverse.c.event.TypeDefFunctionDeclarationRemoved;
import org.eclipse.umlgen.reverse.c.event.TypeDefRemoved;
import org.eclipse.umlgen.reverse.c.event.TypeDefStructAdded;
import org.eclipse.umlgen.reverse.c.event.TypeDefStructRemoved;
import org.eclipse.umlgen.reverse.c.event.UnionAdded;
import org.eclipse.umlgen.reverse.c.event.VariableDeclarationAdded;
import org.eclipse.umlgen.reverse.c.event.VariableDeclarationRemoved;
import org.eclipse.umlgen.reverse.c.internal.beans.FunctionParameter;
import org.eclipse.umlgen.reverse.c.internal.bundle.Activator;
import org.eclipse.umlgen.reverse.c.internal.reconciler.IFileReconciler;
import org.eclipse.umlgen.reverse.c.util.ASTUtil;

public abstract class AbstractFileReconciler
implements IFileReconciler {
    public AbstractCModelChangedEvent addElement(IASTEnumerationSpecifier element, IEnumeration enumeration) {
        return this.buildEvent(ModelUtil.EventType.ADD, element, enumeration);
    }

    public AbstractCModelChangedEvent removeElement(IASTEnumerationSpecifier element, IEnumeration enumeration) {
        return this.buildEvent(ModelUtil.EventType.REMOVE, element, enumeration);
    }

    private AbstractCModelChangedEvent buildEvent(ModelUtil.EventType eType, IASTEnumerationSpecifier specifier, IEnumeration enumeration) {
        String enumName = ModelUtil.computeAnonymousTypeName((String)enumeration.getTranslationUnit().getPath().removeFileExtension().lastSegment(), (String)enumeration.getElementName(), (IASTNode)specifier);
        if (eType == ModelUtil.EventType.ADD) {
            return EnumerationAdded.builder().setEnumerators(specifier.getEnumerators()).currentName(enumName).translationUnit(enumeration.getTranslationUnit()).build();
        }
        return EnumerationRemoved.builder().setEnumerators(specifier.getEnumerators()).currentName(enumName).translationUnit(enumeration.getTranslationUnit()).build();
    }

    public AbstractCModelChangedEvent addElement(IASTCompositeTypeSpecifier specifier, IStructure structure) {
        return this.buildEvent(ModelUtil.EventType.ADD, specifier, structure);
    }

    public AbstractCModelChangedEvent removeElement(IASTCompositeTypeSpecifier specifier, IStructure structure) {
        return this.buildEvent(ModelUtil.EventType.REMOVE, specifier, structure);
    }

    private AbstractCModelChangedEvent buildEvent(ModelUtil.EventType eType, IASTCompositeTypeSpecifier specifier, IStructure structure) {
        boolean isUnion = false;
        AbstractCModelChangedEvent result = null;
        try {
            isUnion = structure.isUnion();
        }
        catch (CModelException cme) {
            Activator.log("Can't deteremine a UNION.", 2, cme);
        }
        String typeName = ModelUtil.computeAnonymousTypeName((String)structure.getTranslationUnit().getPath().removeFileExtension().lastSegment(), (String)structure.getElementName(), (IASTNode)specifier);
        if (!isUnion) {
            if (eType == ModelUtil.EventType.ADD) {
                IASTDeclaration[] declarations = specifier.getDeclarations(false);
                result = (AbstractCModelChangedEvent)StructAdded.builder().setDeclarations(declarations).currentName(typeName).translationUnit(structure.getTranslationUnit()).build();
            } else {
                result = (AbstractCModelChangedEvent)StructRemoved.builder().currentName(typeName).translationUnit(structure.getTranslationUnit()).build();
            }
        } else {
            IASTDeclaration[] declarations = specifier.getDeclarations(false);
            result = (AbstractCModelChangedEvent)UnionAdded.builder().setDeclarations(declarations).currentName(typeName).translationUnit(structure.getTranslationUnit()).build();
        }
        return result;
    }

    public AbstractCModelChangedEvent addElement(IASTEnumerationSpecifier enumerationSpecifier, ITypeDef type) {
        return this.buildEvent(ModelUtil.EventType.ADD, enumerationSpecifier, type);
    }

    public AbstractCModelChangedEvent removeElement(IASTEnumerationSpecifier enumerationSpecifier, ITypeDef type) {
        return this.buildEvent(ModelUtil.EventType.REMOVE, enumerationSpecifier, type);
    }

    private AbstractCModelChangedEvent buildEvent(ModelUtil.EventType eType, IASTEnumerationSpecifier specifier, ITypeDef type) {
        String redefinedEnumName = type.getTypeName().replaceFirst("^enum\\s*", "");
        if (eType == ModelUtil.EventType.ADD) {
            return TypeDefEnumerationAdded.builder().setRedefinedEnumeration(redefinedEnumName).setSource((IASTNode)specifier).currentName(type.getElementName()).translationUnit(type.getTranslationUnit()).build();
        }
        return TypeDefEnumerationRemoved.builder().currentName(type.getElementName()).translationUnit(type.getTranslationUnit()).build();
    }

    public AbstractCModelChangedEvent addElement(IASTSimpleDeclaration element, IVariableDeclaration variableDecl) {
        return this.buildEvent(ModelUtil.EventType.ADD, element, variableDecl);
    }

    public AbstractCModelChangedEvent removeElement(IASTSimpleDeclaration element, IVariableDeclaration variableDecl) {
        return this.buildEvent(ModelUtil.EventType.REMOVE, element, variableDecl);
    }

    private AbstractCModelChangedEvent buildEvent(ModelUtil.EventType eType, IASTSimpleDeclaration element, IVariableDeclaration variableDecl) {
        String typeName = ASTUtil.computeType(element);
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        typeName = ModelUtil.computeAnonymousTypeName((String)variableDecl.getTranslationUnit().getPath().removeFileExtension().lastSegment(), (String)typeName, (IASTNode)element.getDeclSpecifier());
        String varName = ASTUtil.computeName(element, variableDecl.getElementName());
        AbstractCModelChangedEvent event = null;
        try {
            event = eType == ModelUtil.EventType.ADD ? (AbstractCModelChangedEvent)VariableDeclarationAdded.builder().setConst(variableDecl.isConst()).setExtern(element.getRawSignature().contains("extern")).setVolatile(variableDecl.isVolatile()).setIsStatic(variableDecl.isStatic()).setRegister(element.getRawSignature().contains("register")).currentType(typeName).currentName(varName).translationUnit(variableDecl.getTranslationUnit()).build() : (AbstractCModelChangedEvent)VariableDeclarationRemoved.builder().currentType(typeName).currentName(variableDecl.getElementName()).translationUnit(variableDecl.getTranslationUnit()).build();
        }
        catch (CModelException e) {
            Activator.log("Variable Addition Error : " + e.getMessage(), 4);
        }
        return event;
    }

    public AbstractCModelChangedEvent addElement(IASTSimpleDeclaration element, IVariable variable) {
        return this.buildEvent(ModelUtil.EventType.ADD, element, variable);
    }

    public AbstractCModelChangedEvent removeElement(IASTSimpleDeclaration element, IVariable variable) {
        return this.buildEvent(ModelUtil.EventType.REMOVE, element, variable);
    }

    private AbstractCModelChangedEvent buildEvent(ModelUtil.EventType eType, IASTSimpleDeclaration element, IVariable variable) {
        String initialisationExpression = null;
        if (element == null) {
            return null;
        }
        IASTDeclarator[] iASTDeclaratorArray = element.getDeclarators();
        int n = iASTDeclaratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclarator declarator = iASTDeclaratorArray[n2];
            if (variable.getElementName().equals(declarator.getName().toString())) {
                IASTInitializer initializer = declarator.getInitializer();
                if (declarator instanceof IASTArrayDeclarator && initializer instanceof IASTEqualsInitializer) {
                    initialisationExpression = ((IASTEqualsInitializer)initializer).getInitializerClause().getRawSignature();
                    break;
                }
                if (initializer != null && initializer.getChildren()[0] instanceof IASTInitializerClause) {
                    initialisationExpression = ((IASTInitializerClause)initializer.getChildren()[0]).getRawSignature();
                    break;
                }
            }
            ++n2;
        }
        String typeName = ASTUtil.computeType(element);
        typeName = ModelUtil.computeAnonymousTypeName((String)variable.getTranslationUnit().getPath().removeFileExtension().lastSegment(), (String)typeName, (IASTNode)element.getDeclSpecifier());
        String varName = ASTUtil.computeName(element, variable.getElementName());
        AbstractCModelChangedEvent event = null;
        try {
            event = eType == ModelUtil.EventType.ADD ? (AbstractCModelChangedEvent)VariableDeclarationAdded.builder().setConst(variable.isConst()).setExtern(element.getRawSignature().contains("extern")).setVolatile(variable.isVolatile()).setIsStatic(variable.isStatic()).setRegister(element.getRawSignature().contains("register")).setInitializerExpression(initialisationExpression).currentType(typeName).currentName(varName).translationUnit(variable.getTranslationUnit()).build() : (AbstractCModelChangedEvent)VariableDeclarationRemoved.builder().currentType(typeName).currentName(variable.getElementName()).translationUnit(variable.getTranslationUnit()).build();
        }
        catch (CModelException e) {
            Activator.log("Variable Addition Error : " + e.getMessage(), 4);
        }
        return event;
    }

    public AbstractCModelChangedEvent addElement(IASTCompositeTypeSpecifier specifier, ITypeDef type) {
        return this.buildEvent(ModelUtil.EventType.ADD, specifier, type);
    }

    public AbstractCModelChangedEvent removeElement(IASTCompositeTypeSpecifier specifier, ITypeDef type) {
        return this.buildEvent(ModelUtil.EventType.REMOVE, specifier, type);
    }

    private AbstractCModelChangedEvent buildEvent(ModelUtil.EventType eType, IASTCompositeTypeSpecifier specifier, ITypeDef type) {
        if (eType == ModelUtil.EventType.ADD) {
            String redefinedStructName = type.getTypeName().replaceFirst("^struct\\s*", "").trim();
            return TypeDefStructAdded.builder().setRedefinedStruct(redefinedStructName).setSource((IASTNode)specifier).currentName(type.getElementName()).translationUnit(type.getTranslationUnit()).build();
        }
        return TypeDefStructRemoved.builder().currentName(type.getElementName()).translationUnit(type.getTranslationUnit()).build();
    }

    public AbstractCModelChangedEvent addElement(IASTElaboratedTypeSpecifier specifier, ITypeDef type) {
        return this.buildEvent(ModelUtil.EventType.ADD, specifier, type);
    }

    public AbstractCModelChangedEvent removeElement(IASTElaboratedTypeSpecifier specifier, ITypeDef type) {
        return this.buildEvent(ModelUtil.EventType.REMOVE, specifier, type);
    }

    private AbstractCModelChangedEvent buildEvent(ModelUtil.EventType eType, IASTElaboratedTypeSpecifier specifier, ITypeDef type) {
        AbstractCModelChangedEvent result = null;
        if (eType == ModelUtil.EventType.ADD) {
            if (specifier.getKind() == 1) {
                String redefinedStructName = type.getTypeName().replaceFirst("^struct\\s*", "").trim();
                result = (AbstractCModelChangedEvent)TypeDefStructAdded.builder().setRedefinedStruct(redefinedStructName).setSource((IASTNode)specifier).currentName(type.getElementName()).translationUnit(type.getTranslationUnit()).build();
            } else {
                String redefinedEnumName = type.getTypeName().replaceFirst("^enum\\s*", "").trim();
                result = (AbstractCModelChangedEvent)TypeDefEnumerationAdded.builder().setRedefinedEnumeration(redefinedEnumName).setSource((IASTNode)specifier).currentName(type.getElementName()).translationUnit(type.getTranslationUnit()).build();
            }
        } else {
            result = specifier.getKind() == 1 ? (AbstractCModelChangedEvent)TypeDefStructRemoved.builder().currentName(type.getElementName()).translationUnit(type.getTranslationUnit()).build() : (AbstractCModelChangedEvent)TypeDefEnumerationRemoved.builder().currentName(type.getElementName()).translationUnit(type.getTranslationUnit()).build();
        }
        return result;
    }

    public AbstractCModelChangedEvent addElement(IASTPreprocessorIncludeStatement include, ITranslationUnit tu) {
        return this.buildEvent(ModelUtil.EventType.ADD, include, tu);
    }

    public AbstractCModelChangedEvent removeElement(IASTPreprocessorIncludeStatement include, ITranslationUnit tu) {
        return this.buildEvent(ModelUtil.EventType.REMOVE, include, tu);
    }

    private AbstractCModelChangedEvent buildEvent(ModelUtil.EventType eType, IASTPreprocessorIncludeStatement include, ITranslationUnit tu) {
        boolean standard;
        boolean bl = standard = include.getRawSignature().contains("<") && include.getRawSignature().contains("<");
        if (eType == ModelUtil.EventType.ADD) {
            return IncludeAdded.builder().setStandard(standard).currentName(include.getName().toString()).translationUnit(tu).build();
        }
        return IncludeRemoved.builder().currentName(include.getName().toString()).translationUnit(tu).build();
    }

    public AbstractCModelChangedEvent addElement(IASTFunctionDeclarator iFunctionDeclarator, IFunctionDeclaration originalFunction) {
        return this.buildEvent(ModelUtil.EventType.ADD, iFunctionDeclarator, originalFunction);
    }

    public AbstractCModelChangedEvent removeElement(IASTFunctionDeclarator iFunctionDeclarator, IFunctionDeclaration originalFunction) {
        return this.buildEvent(ModelUtil.EventType.REMOVE, iFunctionDeclarator, originalFunction);
    }

    private AbstractCModelChangedEvent buildEvent(ModelUtil.EventType eType, IASTFunctionDeclarator iFunctionDeclarator, IFunctionDeclaration originalFunction) {
        AbstractCModelChangedEvent result = null;
        try {
            List<FunctionParameter> parameters = ASTUtil.collectParameterInformation((IASTDeclarator)iFunctionDeclarator);
            result = eType == ModelUtil.EventType.ADD ? (AbstractCModelChangedEvent)FunctionDeclarationAdded.builder().isStatic(originalFunction.isStatic()).setReturnType(originalFunction.getReturnType()).setParameters(parameters).currentName(originalFunction.getElementName()).translationUnit(originalFunction.getTranslationUnit()).build() : (AbstractCModelChangedEvent)FunctionDeclarationRemoved.builder().isStatic(originalFunction.isStatic()).setParameters(parameters).setReturnType(originalFunction.getReturnType()).currentName(originalFunction.getElementName()).translationUnit(originalFunction.getTranslationUnit()).build();
        }
        catch (CoreException coreException) {}
        return result;
    }

    public AbstractCModelChangedEvent addElement(IASTPreprocessorMacroDefinition astMacro, ITranslationUnit unit) {
        return this.buildEvent(ModelUtil.EventType.ADD, astMacro, unit);
    }

    public AbstractCModelChangedEvent removeElement(IASTPreprocessorMacroDefinition astMacro, ITranslationUnit unit) {
        return this.buildEvent(ModelUtil.EventType.REMOVE, astMacro, unit);
    }

    private AbstractCModelChangedEvent buildEvent(ModelUtil.EventType eType, IASTPreprocessorMacroDefinition astMacro, ITranslationUnit unit) {
        String macroName = ASTUtil.computeName(astMacro);
        if (eType == ModelUtil.EventType.ADD) {
            return MacroAdded.builder().setExpansion(astMacro.getExpansion()).currentName(macroName).translationUnit(unit).build();
        }
        return MacroRemoved.builder().setExpansion(astMacro.getExpansion()).currentName(macroName).translationUnit(unit).build();
    }

    public AbstractCModelChangedEvent addElement(IASTDeclarator iDeclarator, ITypeDef typeDef) {
        AbstractCModelChangedEvent event = null;
        if (iDeclarator instanceof IASTArrayDeclarator) {
            ArrayList<String> size = new ArrayList<String>();
            IASTArrayModifier[] iASTArrayModifierArray = ((IASTArrayDeclarator)iDeclarator).getArrayModifiers();
            int n = iASTArrayModifierArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTArrayModifier arrayModifier = iASTArrayModifierArray[n2];
                if (arrayModifier.getConstantExpression() != null) {
                    size.add(arrayModifier.getConstantExpression().getRawSignature());
                }
                ++n2;
            }
            event = (AbstractCModelChangedEvent)TypeDefArrayAdded.builder().setDimensions(size).setRedefinedType(typeDef.getTypeName()).currentType(typeDef.getTypeName()).currentName(typeDef.getElementName()).translationUnit(typeDef.getTranslationUnit()).build();
        } else if (iDeclarator instanceof IASTFunctionDeclarator) {
            List<FunctionParameter> parameters = ASTUtil.collectParameterInformation(iDeclarator);
            String returnType = typeDef.getTypeName().substring(0, typeDef.getTypeName().indexOf("("));
            event = (AbstractCModelChangedEvent)TypeDefFunctionDeclarationAdded.builder().currentName(typeDef.getElementName()).setReturnType(returnType).setParameters(parameters).translationUnit(typeDef.getTranslationUnit()).build();
        } else if (iDeclarator instanceof IASTDeclarator) {
            event = (AbstractCModelChangedEvent)TypeDefAdded.builder().setRedefinedType(typeDef.getTypeName()).currentType(typeDef.getTypeName()).currentName(typeDef.getElementName()).translationUnit(typeDef.getTranslationUnit()).build();
        }
        return event;
    }

    public AbstractCModelChangedEvent removeElement(IASTDeclarator iDeclarator, ITypeDef typeDef) {
        AbstractCModelChangedEvent event = null;
        if (iDeclarator instanceof IASTArrayDeclarator) {
            ArrayList<String> dim = new ArrayList<String>();
            IASTArrayModifier[] iASTArrayModifierArray = ((IASTArrayDeclarator)iDeclarator).getArrayModifiers();
            int n = iASTArrayModifierArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTArrayModifier arrayModifier = iASTArrayModifierArray[n2];
                if (arrayModifier.getConstantExpression() != null) {
                    dim.add(arrayModifier.getConstantExpression().getRawSignature());
                }
                ++n2;
            }
            event = (AbstractCModelChangedEvent)TypeDefArrayRemoved.builder().setDimensions(dim).setRedefinedType(typeDef.getTypeName()).currentName(typeDef.getElementName()).translationUnit(typeDef.getTranslationUnit()).build();
        } else if (iDeclarator instanceof IASTFunctionDeclarator) {
            List<FunctionParameter> parameters = ASTUtil.collectParameterInformation(iDeclarator);
            String returnType = typeDef.getTypeName().substring(0, typeDef.getTypeName().indexOf("("));
            event = (AbstractCModelChangedEvent)TypeDefFunctionDeclarationRemoved.builder().currentName(typeDef.getElementName()).setReturnType(returnType).setParameters(parameters).translationUnit(typeDef.getTranslationUnit()).build();
        } else if (iDeclarator instanceof IASTDeclarator) {
            event = (AbstractCModelChangedEvent)TypeDefRemoved.builder().setRedefinedType(typeDef.getTypeName()).currentName(typeDef.getElementName()).translationUnit(typeDef.getTranslationUnit()).build();
        }
        return event;
    }
}

