/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.reconciler;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.umlgen.reverse.c.event.AbstractCModelChangedEvent;
import org.eclipse.umlgen.reverse.c.event.FunctionBodyChanged;
import org.eclipse.umlgen.reverse.c.event.FunctionDefinitionRenamed;
import org.eclipse.umlgen.reverse.c.event.FunctionParameterChanged;
import org.eclipse.umlgen.reverse.c.internal.beans.FunctionParameter;
import org.eclipse.umlgen.reverse.c.internal.bundle.Activator;
import org.eclipse.umlgen.reverse.c.internal.reconciler.BindingResolver;
import org.eclipse.umlgen.reverse.c.internal.reconciler.CFileReconciler;
import org.eclipse.umlgen.reverse.c.internal.reconciler.HFileReconciler;
import org.eclipse.umlgen.reverse.c.internal.reconciler.IFileReconciler;
import org.eclipse.umlgen.reverse.c.internal.reconciler.SameFileLocation;
import org.eclipse.umlgen.reverse.c.internal.reconciler.Utils;
import org.eclipse.umlgen.reverse.c.reconciler.ASTCommentReconciler;
import org.eclipse.umlgen.reverse.c.reconciler.AbstractReconciler;
import org.eclipse.umlgen.reverse.c.util.ASTUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CASTReconciler
extends AbstractReconciler {
    private static Function<IASTNode, String> rawSignature = new Function<IASTNode, String>(){

        public String apply(IASTNode from) {
            return from.getRawSignature();
        }
    };
    private static Function<IASTPreprocessorMacroDefinition, String> macroName = new Function<IASTPreprocessorMacroDefinition, String>(){

        public String apply(IASTPreprocessorMacroDefinition from) {
            return from.getName().toString();
        }
    };
    private boolean includeInactiveNodes = true;
    private CFileReconciler cFileReconciler = new CFileReconciler();
    private HFileReconciler hFileReconciler = new HFileReconciler();

    public boolean isIncludeInactiveNodes() {
        return this.includeInactiveNodes;
    }

    public void setIncludeInactiveNodes(boolean include) {
        this.includeInactiveNodes = include;
    }

    protected IFileReconciler getFileReconciler(IASTDeclaration declaration) {
        return this.getFileReconciler(declaration.getTranslationUnit());
    }

    protected IFileReconciler getFileReconciler(IASTTranslationUnit tu) {
        return tu.isHeaderUnit() ? this.hFileReconciler : this.cFileReconciler;
    }

    protected Collection<IASTDeclaration> getAddedASTDeclaration(IASTTranslationUnit originalTranslationUnit, IASTTranslationUnit newTranslationUnit) {
        IASTDeclaration[] newDecls = newTranslationUnit.getDeclarations(this.includeInactiveNodes);
        IASTDeclaration[] originalDecls = originalTranslationUnit.getDeclarations(this.includeInactiveNodes);
        return Utils.inLeftOnly(newDecls, originalDecls, rawSignature);
    }

    protected Collection<IASTDeclaration> getRemovedASTDeclaration(IASTTranslationUnit originalTranslationUnit, IASTTranslationUnit newTranslationUnit) {
        return this.getAddedASTDeclaration(newTranslationUnit, originalTranslationUnit);
    }

    private boolean firstIfndefMacro(IASTPreprocessorStatement ifndefstatement, IASTTranslationUnit astWorking) {
        IASTPreprocessorStatement[] statements = astWorking.getAllPreprocessorStatements();
        int currentMacro = statements.length - 1;
        int firstMacro = statements.length - 1;
        int i = statements.length - 1;
        while (i > -1) {
            if (statements[i].getRawSignature().equals(ifndefstatement.getRawSignature())) {
                currentMacro = i;
                firstMacro = i;
            } else {
                firstMacro = i;
            }
            --i;
        }
        if (firstMacro == currentMacro) {
            int astifndefPosition = ifndefstatement.getFileLocation().getNodeOffset();
            int firstNodePosition = astWorking.getFileLocation().getNodeLength();
            if (astWorking.getDeclarations().length > 0 && astWorking.getDeclarations()[0] instanceof IASTNode) {
                firstNodePosition = astWorking.getDeclarations()[0].getFileLocation().getNodeOffset();
            }
            if (astifndefPosition <= firstNodePosition) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addedElement(ITranslationUnit originalUnit, IWorkingCopy workingUnit, ICElement element) throws CoreException {
        AbstractCModelChangedEvent event = null;
        IASTTranslationUnit astWorking = workingUnit.getAST();
        switch (element.getElementType()) {
            case 75: {
                IASTPreprocessorIncludeStatement include = this.getASTIncludeOf(element, astWorking);
                event = this.getFileReconciler(astWorking).addElement(include, (ITranslationUnit)workingUnit);
                break;
            }
            case 79: {
                IASTPreprocessorMacroDefinition astMacro = this.getASTMacroDeclarationOf(element, astWorking);
                event = this.getFileReconciler(astWorking).addElement(astMacro, (ITranslationUnit)workingUnit);
                break;
            }
        }
        this.notifyListeners(event, true);
    }

    public void modifiedElement(ITranslationUnit originalUnit, ITranslationUnit workingUnit, ICElement oldElement, ICElement newElement) {
        switch (oldElement.getElementType()) {
            case 74: {
                this.modifiedElement(originalUnit, workingUnit, (IFunction)oldElement, (IFunction)newElement);
                break;
            }
            case 75: {
                this.modifiedElement(originalUnit, workingUnit, (IInclude)oldElement, (IInclude)newElement);
                break;
            }
            default: {
                System.out.println("Unhandled modification of " + oldElement.getClass().getSimpleName());
            }
        }
    }

    private void modifiedElement(ITranslationUnit originalUnit, ITranslationUnit workingUnit, IInclude oldElement, IInclude newElement) {
        try {
            IASTPreprocessorIncludeStatement oldInclude = this.getASTIncludeOf((ICElement)oldElement, originalUnit.getAST());
            AbstractCModelChangedEvent event = this.getFileReconciler(originalUnit.getAST()).removeElement(oldInclude, originalUnit);
            this.notifyListeners(event, true);
            IASTTranslationUnit astWorking = workingUnit.getAST();
            IASTPreprocessorIncludeStatement include = this.getASTIncludeOf((ICElement)newElement, astWorking);
            event = this.getFileReconciler(astWorking).addElement(include, workingUnit);
            this.notifyListeners(event, true);
        }
        catch (CoreException e) {
            Activator.log("Core Exception : " + e.getMessage(), 4);
        }
    }

    private void modifiedElement(ITranslationUnit originalUnit, ITranslationUnit workingUnit, IFunction oldElement, IFunction newElement) {
        Collection<IASTDeclaration> elementRemoved = null;
        try {
            elementRemoved = this.getRemovedASTDeclaration(originalUnit.getAST(), workingUnit.getAST());
            this.getAddedASTDeclaration(originalUnit.getAST(), workingUnit.getAST());
        }
        catch (CoreException e) {
            Activator.log("Error : " + e.getMessage(), 4);
        }
        if (!oldElement.getElementName().equals(newElement.getElementName())) {
            Object event = FunctionDefinitionRenamed.builder().previousName(oldElement.getElementName()).currentName(newElement.getElementName()).translationUnit(newElement.getTranslationUnit()).build();
            this.notifyListeners((AbstractCModelChangedEvent)event, true);
        } else {
            oldElement.getReturnType().equals(newElement.getReturnType());
        }
        if (oldElement.getNumberOfParameters() != newElement.getNumberOfParameters()) {
            IASTFunctionDefinition oldAstFunction = (IASTFunctionDefinition)elementRemoved;
            List<FunctionParameter> parameters = ASTUtil.collectParameterInformation((IASTDeclarator)oldAstFunction.getDeclarator());
            Object event = FunctionParameterChanged.builder().functionName(newElement.getElementName()).setParameters(parameters).translationUnit(newElement.getTranslationUnit()).build();
            this.notifyListeners((AbstractCModelChangedEvent)event, true);
        } else {
            System.out.println("Do not see the difference between old function : ");
            System.out.println(oldElement.toString());
            System.out.println(" and ");
            System.out.println(newElement.toString());
        }
    }

    private Collection<IASTPreprocessorMacroDefinition> findPreProcessingMacroAdded(IASTTranslationUnit translationUnitAST, IASTTranslationUnit workingUnitAST) {
        Object[] oldMacros = translationUnitAST.getMacroDefinitions();
        Object[] newMacros = workingUnitAST.getMacroDefinitions();
        Collection oldMacrosFiltered = Collections2.filter((Collection)Lists.newArrayList((Object[])oldMacros), (Predicate)new SameFileLocation(translationUnitAST));
        Collection newMacrosFiltered = Collections2.filter((Collection)Lists.newArrayList((Object[])newMacros), (Predicate)new SameFileLocation(workingUnitAST));
        return Utils.inLeftOnly(newMacrosFiltered, oldMacrosFiltered, macroName);
    }

    private Collection<IASTPreprocessorStatement> findPreProcessingStatementAdded(IASTTranslationUnit translationUnitAST, IASTTranslationUnit workingUnitAST) {
        Object[] oldStatements = translationUnitAST.getAllPreprocessorStatements();
        Object[] newStatements = workingUnitAST.getAllPreprocessorStatements();
        Collection oldStatementsFiltered = Collections2.filter((Collection)Lists.newArrayList((Object[])oldStatements), (Predicate)new SameFileLocation(translationUnitAST));
        Collection newStatementsFiltered = Collections2.filter((Collection)Lists.newArrayList((Object[])newStatements), (Predicate)new SameFileLocation(workingUnitAST));
        return Utils.inLeftOnly(newStatementsFiltered, oldStatementsFiltered, rawSignature);
    }

    @Override
    public void removedElement(ITranslationUnit originalUnit, IWorkingCopy workingUnit, ICElement element) throws CoreException {
        AbstractCModelChangedEvent event = null;
        IASTTranslationUnit astWorking = originalUnit.getAST();
        switch (element.getElementType()) {
            case 75: {
                IASTPreprocessorIncludeStatement include = this.getASTIncludeOf(element, astWorking);
                event = this.getFileReconciler(astWorking).removeElement(include, originalUnit);
                break;
            }
            case 79: {
                IASTPreprocessorMacroDefinition astMacro = this.getASTMacroDeclarationOf(element, astWorking);
                event = this.getFileReconciler(astWorking).removeElement(astMacro, originalUnit);
                break;
            }
            default: {
                Activator.log("CASTReconciler.removedElement() - ignored ICElement removal: " + element, 2);
            }
        }
        this.notifyListeners(event, true);
    }

    private IASTPreprocessorMacroDefinition getASTMacroDeclarationOf(ICElement coreElement, IASTTranslationUnit ast) {
        IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = ast.getMacroDefinitions();
        int n = iASTPreprocessorMacroDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorMacroDefinition macro = iASTPreprocessorMacroDefinitionArray[n2];
            if (macro.getName().toString().equals(coreElement.getElementName())) {
                return macro;
            }
            ++n2;
        }
        return null;
    }

    private IASTPreprocessorIncludeStatement getASTIncludeOf(ICElement coreElement, IASTTranslationUnit ast) {
        IASTPreprocessorIncludeStatement[] iASTPreprocessorIncludeStatementArray = ast.getIncludeDirectives();
        int n = iASTPreprocessorIncludeStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorIncludeStatement include = iASTPreprocessorIncludeStatementArray[n2];
            if (include.getName().toString().equals(coreElement.getElementName())) {
                return include;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void addedElement(IASTTranslationUnit originalTranslationUnit, IASTTranslationUnit newTranslationUnit, ITranslationUnit tu, ICElement coreElement) throws CoreException {
        Collection<IASTDeclaration> elements = this.getAddedASTDeclaration(originalTranslationUnit, newTranslationUnit);
        AbstractCModelChangedEvent event = null;
        IASTSimpleDeclaration element = null;
        switch (coreElement.getElementType()) {
            case 77: {
                element = BindingResolver.resolveBindingIASTSimpleDeclaration(elements, coreElement);
                event = this.getFileReconciler((IASTDeclaration)element).addElement(element, (IVariableDeclaration)coreElement);
                break;
            }
            case 76: {
                element = BindingResolver.resolveBindingIASTSimpleDeclaration(elements, coreElement);
                event = this.getFileReconciler((IASTDeclaration)element).addElement(element, (IVariable)coreElement);
                break;
            }
            case 63: {
                element = BindingResolver.resolveBindingIASTEnumeration(elements, coreElement, tu);
                event = this.getFileReconciler(newTranslationUnit).addElement((IASTEnumerationSpecifier)element.getDeclSpecifier(), (IEnumeration)coreElement);
                break;
            }
            case 73: {
                element = BindingResolver.resolveBindingIASTFunctionDeclarator(elements, coreElement);
                event = this.getFileReconciler((IASTDeclaration)element).addElement((IASTFunctionDeclarator)element.getDeclarators()[0], (IFunctionDeclaration)coreElement);
                break;
            }
            case 74: {
                element = BindingResolver.resolveBindingIASTFunctionDefinition(elements, coreElement);
                event = this.getFileReconciler((IASTDeclaration)element).addElement((IASTFunctionDefinition)element, (IFunction)coreElement);
                break;
            }
            case 80: {
                IASTSimpleDeclaration simpleDeclaration = BindingResolver.resolveBindingIASTypeDefDeclaration(elements, coreElement);
                if (simpleDeclaration.getDeclSpecifier() instanceof IASTEnumerationSpecifier) {
                    event = this.getFileReconciler((IASTDeclaration)simpleDeclaration).addElement((IASTEnumerationSpecifier)simpleDeclaration.getDeclSpecifier(), (ITypeDef)coreElement);
                    break;
                }
                if (simpleDeclaration.getDeclSpecifier() instanceof IASTCompositeTypeSpecifier) {
                    IASTCompositeTypeSpecifier compositeTypeSpec = (IASTCompositeTypeSpecifier)simpleDeclaration.getDeclSpecifier();
                    event = this.getFileReconciler((IASTDeclaration)simpleDeclaration).addElement(compositeTypeSpec, (ITypeDef)coreElement);
                    break;
                }
                if (simpleDeclaration.getDeclSpecifier() instanceof IASTElaboratedTypeSpecifier) {
                    IASTElaboratedTypeSpecifier compositeTypeSpec = (IASTElaboratedTypeSpecifier)simpleDeclaration.getDeclSpecifier();
                    event = this.getFileReconciler((IASTDeclaration)simpleDeclaration).addElement(compositeTypeSpec, (ITypeDef)coreElement);
                    break;
                }
                if (simpleDeclaration.getDeclSpecifier() instanceof IASTNamedTypeSpecifier) {
                    event = this.getFileReconciler((IASTDeclaration)simpleDeclaration).addElement(simpleDeclaration.getDeclarators()[0], (ITypeDef)coreElement);
                    break;
                }
                if (simpleDeclaration.getDeclSpecifier() instanceof IASTSimpleDeclSpecifier) {
                    event = this.getFileReconciler((IASTDeclaration)simpleDeclaration).addElement(simpleDeclaration.getDeclarators()[0], (ITypeDef)coreElement);
                    break;
                }
                if (simpleDeclaration.getDeclarators()[0] instanceof IASTFunctionDeclarator) {
                    event = this.getFileReconciler((IASTDeclaration)simpleDeclaration).addElement((IASTDeclarator)((IASTFunctionDeclarator)simpleDeclaration.getDeclarators()[0]), (ITypeDef)coreElement);
                    break;
                }
                Activator.log("CASTReconciler.addedElement() - ignored TYPEDEF Declaration : " + simpleDeclaration.toString(), 2);
                break;
            }
            case 93: {
                break;
            }
            case 67: {
                IASTSimpleDeclaration simpleDeclaration = BindingResolver.resolveBindingIASTStructure(elements, coreElement, tu);
                IASTCompositeTypeSpecifier specifier = (IASTCompositeTypeSpecifier)simpleDeclaration.getDeclSpecifier();
                event = this.getFileReconciler(newTranslationUnit).addElement(specifier, (IStructure)coreElement);
                break;
            }
            default: {
                Activator.log("CASTReconciler.addedElement() - ignored ICElement: " + coreElement.toString(), 2);
            }
        }
        this.notifyListeners(event, true);
    }

    @Override
    public void removedElement(IASTTranslationUnit originalTranslationUnit, IASTTranslationUnit newTranslationUnit, ITranslationUnit tu, ICElement coreElement) throws CoreException {
        Collection<IASTDeclaration> elements = this.getRemovedASTDeclaration(originalTranslationUnit, newTranslationUnit);
        AbstractCModelChangedEvent event = null;
        IASTSimpleDeclaration element = null;
        switch (coreElement.getElementType()) {
            case 77: {
                element = BindingResolver.resolveBindingIASTSimpleDeclaration(elements, coreElement);
                event = this.getFileReconciler((IASTDeclaration)element).removeElement(element, (IVariableDeclaration)coreElement);
                break;
            }
            case 76: {
                element = BindingResolver.resolveBindingIASTSimpleDeclaration(elements, coreElement);
                event = this.getFileReconciler((IASTDeclaration)element).removeElement(element, (IVariableDeclaration)coreElement);
                break;
            }
            case 63: {
                element = BindingResolver.resolveBindingIASTEnumeration(elements, coreElement, tu);
                event = this.getFileReconciler(newTranslationUnit).removeElement((IASTEnumerationSpecifier)element.getDeclSpecifier(), (IEnumeration)coreElement);
                break;
            }
            case 73: {
                element = BindingResolver.resolveBindingIASTFunctionDeclarator(elements, coreElement);
                event = this.getFileReconciler((IASTDeclaration)element).removeElement((IASTFunctionDeclarator)element.getDeclarators()[0], (IFunctionDeclaration)coreElement);
                break;
            }
            case 74: {
                element = BindingResolver.resolveBindingIASTFunctionDefinition(elements, coreElement);
                event = this.getFileReconciler((IASTDeclaration)element).removeElement((IASTFunctionDefinition)element, (IFunction)coreElement);
                break;
            }
            case 80: {
                IASTSimpleDeclaration simpleDeclaration = BindingResolver.resolveBindingIASTypeDefDeclaration(elements, coreElement);
                if (simpleDeclaration.getDeclSpecifier() instanceof IASTEnumerationSpecifier) {
                    event = this.getFileReconciler(newTranslationUnit).removeElement((IASTEnumerationSpecifier)simpleDeclaration.getDeclSpecifier(), (ITypeDef)coreElement);
                    break;
                }
                if (simpleDeclaration.getDeclSpecifier() instanceof IASTCompositeTypeSpecifier) {
                    event = this.getFileReconciler(newTranslationUnit).removeElement((IASTCompositeTypeSpecifier)simpleDeclaration.getDeclSpecifier(), (ITypeDef)coreElement);
                    break;
                }
                if (simpleDeclaration.getDeclSpecifier() instanceof IASTElaboratedTypeSpecifier) {
                    event = this.getFileReconciler(newTranslationUnit).removeElement((IASTElaboratedTypeSpecifier)simpleDeclaration.getDeclSpecifier(), (ITypeDef)coreElement);
                    break;
                }
                if (simpleDeclaration.getDeclSpecifier() instanceof IASTNamedTypeSpecifier) {
                    event = this.getFileReconciler(newTranslationUnit).removeElement(simpleDeclaration.getDeclarators()[0], (ITypeDef)coreElement);
                    break;
                }
                if (simpleDeclaration.getDeclSpecifier() instanceof IASTSimpleDeclSpecifier) {
                    event = this.getFileReconciler(newTranslationUnit).removeElement(simpleDeclaration.getDeclarators()[0], (ITypeDef)coreElement);
                    break;
                }
                if (!(simpleDeclaration.getDeclarators()[0] instanceof IASTFunctionDeclarator)) break;
                event = this.getFileReconciler(newTranslationUnit).removeElement((IASTDeclarator)((IASTFunctionDeclarator)simpleDeclaration.getDeclarators()[0]), (ITypeDef)coreElement);
                break;
            }
            case 67: {
                element = BindingResolver.resolveBindingIASTStructure(elements, coreElement, tu);
                event = this.getFileReconciler(newTranslationUnit).removeElement((IASTCompositeTypeSpecifier)element.getDeclSpecifier(), (IStructure)coreElement);
                break;
            }
        }
        this.notifyListeners(event, true);
    }

    public void reconcile(ITranslationUnit translationUnit, IWorkingCopy workingCopy) {
        try {
            IASTTranslationUnit translationUnitAST = translationUnit.getAST();
            IASTTranslationUnit workingCopyAST = workingCopy.getAST();
            this.reconcileFunctions(translationUnitAST, workingCopyAST, workingCopy);
            this.reconcilePreprocessorStatements(translationUnit, translationUnitAST, workingCopy, workingCopyAST);
            this.reconcilePreprocessorMacroDefinition(translationUnit, translationUnitAST, workingCopy, workingCopyAST);
            this.reconcileComments(translationUnit, workingCopy);
        }
        catch (CoreException e) {
            Activator.log("CASTReconciler.reconcile() - error while getting AST of the working copy", 4, e);
        }
    }

    protected void reconcileFunctions(IASTTranslationUnit translationUnitAST, IASTTranslationUnit workingCopyAST, IWorkingCopy workingCopy) {
        IASTDeclaration[] originalDecls = translationUnitAST.getDeclarations(this.includeInactiveNodes);
        IASTDeclaration[] newDecls = workingCopyAST.getDeclarations(this.includeInactiveNodes);
        int i = 0;
        int j = 0;
        while (i < originalDecls.length && j < newDecls.length) {
            if (originalDecls[i] instanceof IASTFunctionDefinition && newDecls[j] instanceof IASTFunctionDefinition) {
                String newFunctionName;
                IASTFunctionDefinition originalFunctionDef = (IASTFunctionDefinition)originalDecls[i];
                IASTFunctionDefinition newFunctionDef = (IASTFunctionDefinition)newDecls[j];
                String originalFunctionName = originalFunctionDef.getDeclarator().getName().toString();
                if (originalFunctionName.equals(newFunctionName = newFunctionDef.getDeclarator().getName().toString())) {
                    this.reconcileTheSameFunction((ITranslationUnit)workingCopy, originalFunctionDef, newFunctionDef);
                }
            }
            ++i;
            ++j;
        }
    }

    public void reconcileComments(ITranslationUnit originalUnit, IWorkingCopy newUnit) throws CoreException {
        ASTCommentReconciler commentReconciler = new ASTCommentReconciler();
        commentReconciler.addAllModelChangeListeners(this.getModelChangeListeners());
        commentReconciler.reconcile(originalUnit, (ITranslationUnit)newUnit);
    }

    public void reconcilePreprocessorMacroDefinition(ITranslationUnit translationUnit, IASTTranslationUnit translationUnitAST, IWorkingCopy workingCopy, IASTTranslationUnit workingCopyAST) {
        AbstractCModelChangedEvent event = null;
        Collection<IASTPreprocessorMacroDefinition> allMacroAdded = this.findPreProcessingMacroAdded(translationUnitAST, workingCopyAST);
        for (IASTPreprocessorMacroDefinition macroAdded : allMacroAdded) {
            if (!(macroAdded instanceof IASTPreprocessorMacroDefinition)) continue;
            event = this.getFileReconciler(workingCopyAST).addElement(macroAdded, (ITranslationUnit)workingCopy);
            this.notifyListeners(event, true);
        }
        Collection<IASTPreprocessorMacroDefinition> allMacroRemoved = this.findPreProcessingMacroAdded(workingCopyAST, translationUnitAST);
        for (IASTPreprocessorMacroDefinition macroRemoved : allMacroRemoved) {
            if (!(macroRemoved instanceof IASTPreprocessorMacroDefinition)) continue;
            event = this.getFileReconciler(workingCopyAST).removeElement(macroRemoved, translationUnit);
            this.notifyListeners(event, true);
        }
    }

    public void reconcilePreprocessorStatements(ITranslationUnit translationUnit, IASTTranslationUnit translationUnitAST, IWorkingCopy workingCopy, IASTTranslationUnit workingCopyAST) {
        AbstractCModelChangedEvent event;
        for (IASTPreprocessorStatement statementAdded : this.findPreProcessingStatementAdded(translationUnitAST, workingCopyAST)) {
            if (!(statementAdded instanceof IASTPreprocessorIfndefStatement) || !this.firstIfndefMacro(statementAdded, workingCopyAST)) continue;
            event = this.getFileReconciler(workingCopyAST).addElement((IASTPreprocessorIfndefStatement)statementAdded, (ITranslationUnit)workingCopy);
            this.notifyListeners(event, true);
        }
        for (IASTPreprocessorStatement statementAdded : this.findPreProcessingStatementAdded(workingCopyAST, translationUnitAST)) {
            if (!(statementAdded instanceof IASTPreprocessorIfndefStatement) || !this.firstIfndefMacro(statementAdded, translationUnitAST)) continue;
            event = this.getFileReconciler(workingCopyAST).removeElement((IASTPreprocessorIfndefStatement)statementAdded, translationUnit);
            this.notifyListeners(event, true);
        }
    }

    private void reconcileTheSameFunction(ITranslationUnit newUnit, IASTFunctionDefinition originalFunctionDefinition, IASTFunctionDefinition newFunctionDefinition) {
        IASTFunctionDeclarator originalOutermostDeclarator = (IASTFunctionDeclarator)ASTQueries.findOutermostDeclarator((IASTDeclarator)originalFunctionDefinition.getDeclarator());
        IASTFunctionDeclarator newOutermostDeclarator = (IASTFunctionDeclarator)ASTQueries.findOutermostDeclarator((IASTDeclarator)newFunctionDefinition.getDeclarator());
        originalOutermostDeclarator.getName().resolveBinding();
        newOutermostDeclarator.getName().resolveBinding();
        org.eclipse.cdt.core.dom.ast.IFunction newFunction = (org.eclipse.cdt.core.dom.ast.IFunction)newOutermostDeclarator.getName().getBinding();
        List<FunctionParameter> parameters = ASTUtil.collectParameterInformation((IASTDeclarator)newFunctionDefinition.getDeclarator());
        Object event = FunctionParameterChanged.builder().functionName(newFunction.getName()).setParameters(parameters).translationUnit(newUnit).build();
        this.notifyListeners((AbstractCModelChangedEvent)event, true);
        String newbody = newFunctionDefinition.getBody().getRawSignature();
        String oldBody = originalFunctionDefinition.getBody().getRawSignature();
        String currentName = newFunctionDefinition.getDeclarator().getName().toString();
        event = FunctionBodyChanged.builder().setBody(newbody).setOldBody(oldBody).currentName(currentName).translationUnit(newUnit).build();
        this.notifyListeners((AbstractCModelChangedEvent)event, true);
    }
}

