/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.resource;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public final class ProjectUtil {
    private ProjectUtil() {
    }

    public static void addToBuildSpec(IProject project, String builderID) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand builderCommand = ProjectUtil.getBuilderCommand(description, builderID);
        if (builderCommand == null) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            ProjectUtil.setBuilderCommand(project, description, command);
        }
    }

    private static ICommand getBuilderCommand(IProjectDescription description, String builderId) {
        ICommand[] commands;
        ICommand[] iCommandArray = commands = description.getBuildSpec();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (command.getBuilderName().equals(builderId)) {
                return command;
            }
            ++n2;
        }
        return null;
    }

    public static void removeFromBuildSpec(IProject project, String builderID) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
            }
            ++i;
        }
        project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
    }

    private static void setBuilderCommand(IProject project, IProjectDescription description, ICommand newCommand) throws CoreException {
        ICommand[] newCommands;
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldBuilderCommand = ProjectUtil.getBuilderCommand(description, newCommand.getBuilderName());
        if (oldBuilderCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
            newCommands[oldCommands.length] = newCommand;
        } else {
            int i = 0;
            int max = oldCommands.length;
            while (i < max) {
                if (oldCommands[i] == oldBuilderCommand) {
                    oldCommands[i] = newCommand;
                    break;
                }
                ++i;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
        project.setDescription(description, null);
    }

    public static void addNature(IProject project, String natureId) throws CoreException {
        IProjectDescription projectDesc = project.getDescription();
        String[] natureIds = projectDesc.getNatureIds();
        String[] newNatureIds = new String[natureIds.length + 1];
        System.arraycopy(natureIds, 0, newNatureIds, 0, natureIds.length);
        newNatureIds[natureIds.length] = natureId;
        projectDesc.setNatureIds(newNatureIds);
        project.setDescription(projectDesc, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void removeNature(IProject project, String natureId) throws CoreException {
        IProjectDescription projectDesc = project.getDescription();
        String[] natureIds = projectDesc.getNatureIds();
        String[] newNatureIds = new String[natureIds.length - 1];
        int i = 0;
        int j = 0;
        while (i < natureIds.length && j < newNatureIds.length) {
            if (!natureId.equals(natureIds[i])) {
                newNatureIds[j] = natureIds[i];
                ++j;
            }
            ++i;
        }
        projectDesc.setNatureIds(newNatureIds);
        project.setDescription(projectDesc, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean hasNature(IProject project, String natureId) {
        boolean ret = false;
        try {
            String[] naturesId;
            String[] stringArray = naturesId = project.getDescription().getNatureIds();
            int n = naturesId.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (element.equals(natureId)) {
                    ret = true;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return ret;
    }
}

