/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.c.common.interactions;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.umlgen.c.common.interactions.extension.IModelSynchronizer;
import org.eclipse.umlgen.c.common.interactions.extension.registry.SynchronizerDescriptor;
import org.eclipse.umlgen.c.common.interactions.extension.registry.SynchronizerRegistry;

public final class SynchronizersManager {
    private static Comparator<SynchronizerDescriptor> synchronizerComparator = new Comparator<SynchronizerDescriptor>(){

        @Override
        public int compare(SynchronizerDescriptor o1, SynchronizerDescriptor o2) {
            int o1ranking = Integer.parseInt(o1.getRanking());
            int o2ranking = Integer.parseInt(o2.getRanking());
            return o2ranking - o1ranking;
        }
    };

    private SynchronizersManager() {
    }

    public static IModelSynchronizer getSynchronizer() {
        List<SynchronizerDescriptor> descriptors = SynchronizerRegistry.getRegisteredExtensions();
        Collections.sort(descriptors, synchronizerComparator);
        Iterator<SynchronizerDescriptor> iterator = descriptors.iterator();
        if (iterator.hasNext()) {
            SynchronizerDescriptor desc = iterator.next();
            return desc.getSynchronizerExtension();
        }
        return null;
    }
}

