/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.embedded.c.ui.handler;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.umlgen.gen.embedded.c.main.Uml2ec;
import org.eclipse.umlgen.gen.embedded.c.services.ConfigurationHolder;
import org.eclipse.umlgen.gen.embedded.c.ui.UML2ECUIActivator;
import org.eclipse.umlgen.gen.embedded.c.ui.common.ConfigurationServices;

public class GenerateEmbeddedCHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            IResource model = null;
            Object selectedObj = selection.getFirstElement();
            if (selectedObj instanceof IResource) {
                model = (IResource)selectedObj;
            } else if (selectedObj instanceof EObject) {
                EClass eClass = ((EObject)selectedObj).eClass();
                if (eClass == UMLPackage.Literals.CLASS) {
                    this.caseClass((Class)selectedObj);
                } else if (eClass == UMLPackage.Literals.PACKAGE) {
                    this.casePackage((Package)selectedObj);
                } else if (eClass == UMLPackage.Literals.MODEL) {
                    this.caseModel((Model)selectedObj);
                } else {
                    throw new ExecutionException("Cannot start generation from " + eClass.toString());
                }
            }
            if (model != null) {
                String configName = ConfigurationServices.getConfigurationProperty(model);
                ILaunchConfiguration config = ConfigurationServices.getStoredLaunchConfiguration(configName);
                String computedModelPath = model.getFullPath().toString();
                String modelPath = config.getAttribute("uml_model_path", "");
                if (modelPath != null && modelPath.equals(computedModelPath)) {
                    ILaunchGroup group = ConfigurationServices.getLaunchGroup();
                    if (group != null) {
                        DebugUITools.launch((ILaunchConfiguration)config, (String)group.getMode());
                    }
                } else {
                    Status status = new Status(4, "org.eclipse.umlgen.gen.embedded.c.ui", "No configuration matches with this model.");
                    UML2ECUIActivator.getDefault().getLog().log((IStatus)status);
                }
            }
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (CoreException e2) {
            e2.printStackTrace();
        }
        return null;
    }

    public static void doGenerate(EObject eObject) throws ExecutionException {
        Status status;
        Path outputFolderPath = null;
        IWorkspaceRoot container = ResourcesPlugin.getWorkspace().getRoot();
        IResource model = ResourcesPlugin.getWorkspace().getRoot().findMember(eObject.eResource().getURI().toPlatformString(true));
        String configNameToSelect = ConfigurationServices.getConfigurationProperty(model);
        ILaunchConfiguration configuration = ConfigurationServices.getStoredLaunchConfiguration(configNameToSelect);
        ConfigurationHolder configurationHolder = ConfigurationServices.createConfigurationHolder(configuration);
        try {
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(configuration.getAttribute("output_folder_path", "")));
            outputFolderPath = new Path(folder.getRawLocation().toString());
        }
        catch (CoreException e) {
            status = new Status(4, "org.eclipse.umlgen.gen.embedded.c.ui", e.getMessage(), (Throwable)e);
            UML2ECUIActivator.getDefault().getLog().log((IStatus)status);
        }
        try {
            final Uml2ec generator = new Uml2ec(eObject, outputFolderPath.toFile(), Collections.emptyList());
            generator.setConfigurationHolder(configurationHolder);
            Job generationJob = new Job("Generation in progress...", (IContainer)container){
                private final /* synthetic */ IContainer val$container;
                {
                    this.val$container = iContainer;
                    super($anonymous0);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        generator.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
                    }
                    catch (IOException e) {
                        Status status = new Status(4, "org.eclipse.umlgen.gen.embedded.c.ui", e.getMessage(), (Throwable)e);
                        UML2ECUIActivator.getDefault().getLog().log((IStatus)status);
                    }
                    try {
                        this.val$container.refreshLocal(2, monitor);
                    }
                    catch (CoreException coreException) {}
                    return Status.OK_STATUS;
                }
            };
            generationJob.setPriority(30);
            generationJob.schedule();
        }
        catch (IOException e) {
            status = new Status(4, "org.eclipse.umlgen.gen.embedded.c.ui", e.getMessage(), (Throwable)e);
            UML2ECUIActivator.getDefault().getLog().log((IStatus)status);
        }
    }

    private void caseClass(Class selectedObject) throws ExecutionException {
        GenerateEmbeddedCHandler.doGenerate((EObject)selectedObject);
    }

    private void casePackage(Package selectedObject) throws ExecutionException {
        GenerateEmbeddedCHandler.doGenerate((EObject)selectedObject);
    }

    private void caseModel(Model selectedObject) throws ExecutionException {
        GenerateEmbeddedCHandler.doGenerate((EObject)selectedObject);
    }
}

