/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units;

import com.ibm.icu.util.MeasureUnit;
import java.io.IOException;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.uomo.core.IName;
import org.eclipse.uomo.core.ISymbol;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.QuantityFactory;
import org.eclipse.uomo.units.impl.AlternateUnit;
import org.eclipse.uomo.units.impl.ProductUnit;
import org.eclipse.uomo.units.impl.TransformedUnit;
import org.eclipse.uomo.units.impl.converter.AddConverter;
import org.eclipse.uomo.units.impl.converter.LogConverter;
import org.eclipse.uomo.units.impl.converter.MultiplyConverter;
import org.eclipse.uomo.units.impl.converter.RationalConverter;
import org.eclipse.uomo.units.impl.format.LocalUnitFormatImpl;
import org.unitsofmeasurement.quantity.Dimensionless;
import org.unitsofmeasurement.quantity.Quantity;
import org.unitsofmeasurement.unit.Dimension;
import org.unitsofmeasurement.unit.IncommensurableException;
import org.unitsofmeasurement.unit.UnconvertibleException;
import org.unitsofmeasurement.unit.Unit;
import org.unitsofmeasurement.unit.UnitConverter;

public abstract class AbstractUnit<Q extends Quantity<Q>>
extends MeasureUnit
implements Unit<Q>,
IName,
ISymbol {
    private static final long serialVersionUID = -2107517222666572443L;
    private String name;
    public static final Unit<Dimensionless> ONE = new ProductUnit<Dimensionless>();
    protected static final HashMap<String, Unit<?>> SYMBOL_TO_UNIT = new HashMap();

    protected AbstractUnit() {
        this(null);
    }

    protected AbstractUnit(String name) {
        this.name = name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return null;
    }

    public Map<Unit<?>, Integer> getProductUnits() {
        return null;
    }

    protected abstract Unit<Q> toMetric();

    public abstract UnitConverter getConverterToMetric();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public boolean isUnscaledMetric() {
        return this.toMetric().equals((Object)this);
    }

    public final boolean isCompatible(Unit<?> that) {
        return this == that || this.toMetric().equals((Object)that.getSystemUnit()) || !"".equals(this.getDimension().toString()) && this.getDimension().equals(that.getDimension());
    }

    public final <T extends Quantity<T>> Unit<T> asType(Class<T> type) throws ClassCastException {
        Unit<T> metricUnit = QuantityFactory.getInstance(type).getMetricUnit();
        if (metricUnit == null || metricUnit.isCompatible((Unit)this)) {
            return this;
        }
        throw new ClassCastException("The unit: " + (Object)((Object)this) + " is not of parameterized type " + type);
    }

    public Dimension getDimension() {
        return this.toMetric().getDimension();
    }

    public UnitConverter getDimensionalTransform() {
        return this.getConverterToMetric().concatenate(((AbstractUnit)this.toMetric()).getDimensionalTransform());
    }

    public UnitConverter getConverterTo(Unit<Q> that) throws UnconvertibleException {
        return this.searchConverterTo(that);
    }

    public UnitConverter getConverterToAny(Unit<?> that) throws IncommensurableException, UnconvertibleException {
        return this == that || this.equals(that) ? AbstractConverter.IDENTITY : this.searchConverterTo(that);
    }

    private UnitConverter searchConverterTo(Unit<?> that) throws UnconvertibleException {
        Unit thatSI;
        Unit<Q> thisSI = this.toMetric();
        if (thisSI.equals((Object)(thatSI = that.getSystemUnit()))) {
            return ((AbstractUnit)that).getConverterToMetric().inverse().concatenate(this.getConverterToMetric());
        }
        if (!thisSI.getDimension().equals(thatSI.getDimension())) {
            throw new UnconvertibleException((Object)((Object)this) + " is not compatible with " + that);
        }
        UnitConverter thisTransform = ((AbstractUnit)thisSI).getDimensionalTransform().concatenate(this.getConverterToMetric());
        UnitConverter thatTransform = ((AbstractUnit)thatSI).getDimensionalTransform().concatenate(((AbstractUnit)that).getConverterToMetric());
        return thatTransform.inverse().concatenate(thisTransform);
    }

    public final Unit<Q> alternate(String symbol) {
        return new AlternateUnit(symbol, this);
    }

    public final Unit<Q> transform(UnitConverter operation) {
        if (this instanceof TransformedUnit) {
            AbstractUnit tf = this;
            Unit parent = ((TransformedUnit)tf).getParentUnit();
            UnitConverter toParent = ((TransformedUnit)tf).toParentUnit();
            if (toParent == null) {
                return parent;
            }
            UnitConverter toParentConcat = toParent.concatenate(operation);
            if (toParentConcat == AbstractConverter.IDENTITY) {
                return parent;
            }
            return new TransformedUnit(parent, (AbstractConverter)toParentConcat);
        }
        if (operation == AbstractConverter.IDENTITY) {
            return this;
        }
        return new TransformedUnit(this, (AbstractConverter)operation);
    }

    public final Unit<Q> add(double offset) {
        if (offset == 0.0) {
            return this;
        }
        return this.transform(new AddConverter(offset));
    }

    final Unit<Q> multiply(long factor) {
        if (factor == 1L) {
            return this;
        }
        return this.transform(new RationalConverter(BigInteger.valueOf(factor), BigInteger.ONE));
    }

    public final Unit<Q> multiply(double factor) {
        if (factor == 1.0) {
            return this;
        }
        return this.transform(new MultiplyConverter(factor));
    }

    public final Unit<?> multiply(Unit<?> that) {
        if (this.equals(ONE)) {
            return that;
        }
        if (that.equals(ONE)) {
            return this;
        }
        if (this.isRationalFactor()) {
            return that.transform(this.getConverterTo(ONE));
        }
        if (((AbstractUnit)that).isRationalFactor()) {
            return this.transform(that.getConverterTo(ONE));
        }
        return ProductUnit.getProductInstance(this, (AbstractUnit)that);
    }

    private boolean isRationalFactor() {
        if (!(this instanceof TransformedUnit)) {
            return false;
        }
        TransformedUnit tu = (TransformedUnit)this;
        return tu.getParentUnit().equals(ONE) && tu.getConverterTo(tu.getSystemUnit()) instanceof RationalConverter;
    }

    public final Unit<?> inverse() {
        if (this.equals(ONE)) {
            return this;
        }
        if (this.isRationalFactor()) {
            return this.transform(this.getConverterTo(ONE).inverse());
        }
        return ProductUnit.getQuotientInstance((AbstractUnit)ONE, this);
    }

    public final Unit<Q> divide(long divisor) {
        if (divisor == 1L) {
            return this;
        }
        return this.transform(new RationalConverter(BigInteger.ONE, BigInteger.valueOf(divisor)));
    }

    public final Unit<Q> divide(double divisor) {
        if (divisor == 1.0) {
            return this;
        }
        return this.transform(new MultiplyConverter(1.0 / divisor));
    }

    public final Unit<Q> log(double base) {
        return this.transform(new LogConverter(base));
    }

    public final Unit<?> divide(Unit<?> that) {
        return (AbstractUnit)this.multiply(that.inverse());
    }

    public final Unit<?> root(int n) {
        if (n > 0) {
            return ProductUnit.getRootInstance(this, n);
        }
        if (n == 0) {
            throw new ArithmeticException("Root's order of zero");
        }
        return ONE.divide(this.root(-n));
    }

    public final Unit<?> pow(int n) {
        if (n > 0) {
            return this.multiply(this.pow(n - 1));
        }
        if (n == 0) {
            return ONE;
        }
        return ONE.divide(this.pow(-n));
    }

    public static Unit<?> valueOf(CharSequence charSequence) {
        return LocalUnitFormatImpl.getInstance().parse(charSequence, new ParsePosition(0));
    }

    public String toString() {
        try {
            LocalUnitFormatImpl format = LocalUnitFormatImpl.getInstance();
            return String.valueOf(format.format(this, new StringBuilder()));
        }
        catch (IOException iOException) {
            return "";
        }
    }
}

