/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl.converter;

import java.math.BigDecimal;
import java.math.MathContext;
import org.eclipse.uomo.units.AbstractConverter;
import org.unitsofmeasurement.unit.UnitConverter;

public final class AddConverter
extends AbstractConverter {
    private static final long serialVersionUID = 8088797685241019815L;
    private final double offset;

    public AddConverter(double offset) {
        if (offset == 0.0) {
            throw new IllegalArgumentException("Would result in identity converter");
        }
        this.offset = offset;
    }

    public double getOffset() {
        return this.offset;
    }

    @Override
    public UnitConverter concatenate(UnitConverter converter) {
        if (converter instanceof AddConverter) {
            double newOffset = this.offset + ((AddConverter)converter).offset;
            return newOffset == 0.0 ? IDENTITY : new AddConverter(newOffset);
        }
        return super.concatenate((AbstractConverter)converter);
    }

    @Override
    public AddConverter inverse() {
        return new AddConverter(-this.offset);
    }

    public double convert(double value) {
        return value + this.offset;
    }

    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return value.add(BigDecimal.valueOf(this.offset), ctx);
    }

    public Number convert(Number value) {
        return BigDecimal.valueOf(value.doubleValue()).add(BigDecimal.valueOf(this.offset));
    }

    public final String toString() {
        return "AddConverter(" + this.offset + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddConverter)) {
            return false;
        }
        AddConverter that = (AddConverter)obj;
        return this.offset == that.offset;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.offset);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean isLinear() {
        return false;
    }
}

