/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.util.impl;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.uomo.core.UOMoException;
import org.eclipse.uomo.util.internal.Messages;

public class Iso8601Date {
    public static final int IGNORE = 0;
    public static final int REQUIRED = 1;
    public static final int OPTIONAL = 2;
    public static final int PROHIBITED = 3;
    public static final int CLEAR = 4;
    public static final int SETLOCAL = 5;
    public static final int IF_PRESENT = 6;
    public static final String ISO_DATE_VALIDATION_FULL = Messages.Iso8601Date_ISO_DATE_VALIDATION_FULL;
    public static final String ISO_DATE_VALIDATION_DATE = Messages.Iso8601Date_ISO_DATE_VALIDATION_DATE;
    public static final String DEF_OUTPUT_FORMAT = Messages.Iso8601Date_DEF_OUTPUT_FORMAT;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int milli;
    private int tzHour;
    private int tzMinute;
    private Boolean tzNegative = null;
    private boolean inFraction;

    public Iso8601Date() {
        this.reset(true);
    }

    private void reset(boolean timezoneToo) {
        this.year = -1;
        this.month = -1;
        this.day = -1;
        this.hour = -1;
        this.minute = -1;
        this.second = -1;
        this.milli = -1;
        if (timezoneToo) {
            this.tzHour = 0;
            this.tzMinute = 0;
            this.tzNegative = null;
        }
    }

    public String validate(boolean checkYearReasonable) {
        StringBuffer s = new StringBuffer();
        boolean content = false;
        content = this.checkField(s, this.milli, content, 0, 999, Messages.Iso8601Date_MILIS);
        content = this.checkField(s, this.second, content, 0, 59, Messages.Iso8601Date_SECONDS);
        content = this.checkField(s, this.minute, content, 0, 59, Messages.Iso8601Date_MINUTES);
        content = this.checkField(s, this.hour, content, 0, 23, Messages.Iso8601Date_HOURS);
        content = this.checkField(s, this.day, content, 1, 31, Messages.Iso8601Date_DAYS);
        content = this.checkField(s, this.month, content, 1, 12, Messages.Iso8601Date_MONTHS);
        content = checkYearReasonable ? this.checkField(s, this.year, content, 1000, 2500, Messages.Iso8601Date_YEARS) : this.checkField(s, this.year, content, Integer.MIN_VALUE, Integer.MAX_VALUE, "years");
        if (!content) {
            s.append(Messages.Iso8601Date_NO_VALUES_SET);
        }
        if (this.year != -1 && this.month != -1 && this.day != -1 && this.day > this.daysForMonth(this.month, this.year)) {
            s.append(String.valueOf(Messages.Iso8601Date_THE_DAY) + Integer.toString(this.day) + " is not valid for the month " + Integer.toString(this.month) + " in the year " + Integer.toString(this.year) + "\r\n");
        }
        if (this.tzNegative != null) {
            content = this.checkField(s, this.tzMinute, content, 0, 59, Messages.Iso8601Date_TZ_MINUTES);
            content = this.checkField(s, this.tzHour, content, 0, 13, Messages.Iso8601Date_TZ_HOURS);
        }
        if (s.length() > 0) {
            return s.toString();
        }
        return null;
    }

    private boolean checkField(StringBuffer s, int value, boolean required, int min, int max, String desc) {
        if (value == -1) {
            if (required) {
                s.append(String.valueOf(Messages.Iso8601Date_VALUE_MISSING) + desc + " is missing and required in this context");
            }
            return required;
        }
        if (value < min || value > max) {
            s.append(String.valueOf(Messages.Iso8601Date_VALUE_INVALID) + desc + " is invalid (is " + Integer.toString(value) + " should be " + Integer.toString(min) + " - " + Integer.toString(max) + ")");
        }
        return true;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        this.second = second;
    }

    public int getMilli() {
        return this.milli;
    }

    public void setMilli(int milli) {
        this.milli = milli;
    }

    public int getTzHour() {
        return this.tzHour;
    }

    public void setTzHour(int tzHour) {
        this.tzHour = tzHour;
    }

    public int getTzMinute() {
        return this.tzMinute;
    }

    public void setTzMinute(int tzMinute) {
        this.tzMinute = tzMinute;
    }

    public Boolean getTzNegative() {
        return this.tzNegative;
    }

    public void setTzNegative(Boolean tzNegative) {
        this.tzNegative = tzNegative;
    }

    public Iso8601Date correctForTZ() {
        Iso8601Date result = new Iso8601Date();
        result.year = this.year;
        result.month = this.month;
        result.day = this.day;
        result.hour = this.hour;
        result.minute = this.minute;
        result.second = this.second;
        result.milli = this.milli;
        if (this.tzNegative != null) {
            if (this.tzNegative.booleanValue()) {
                result.addMin(-(this.tzHour * 60 + this.tzMinute));
            } else {
                result.addMin(this.tzHour * 60 + this.tzMinute);
            }
        }
        return result;
    }

    private void addMin(int i) {
        if (i != 0) {
            if (this.minute == -1) {
                this.addHour(i / 60);
            } else {
                this.minute += i;
                int hr = 0;
                while (this.minute < 0) {
                    this.minute += 60;
                    --hr;
                }
                while (this.minute >= 60) {
                    this.minute -= 60;
                    ++hr;
                }
                this.addHour(hr);
            }
        }
    }

    private void addHour(int i) {
        if (i != 0) {
            if (this.hour == -1) {
                this.addDay(i / 24);
            } else {
                this.hour += i;
                int d = 0;
                while (this.hour < 0) {
                    this.hour += 24;
                    --d;
                }
                while (this.hour >= 24) {
                    this.hour -= 24;
                    ++d;
                }
                this.addDay(d);
            }
        }
    }

    private void addDay(int i) {
        if (i != 0 && this.day != -1) {
            this.day += i;
            while (this.day < 1 || this.day > this.daysForMonth(this.month, this.year)) {
                if (this.day < 1) {
                    this.day += this.daysForMonth(this.month, this.year);
                    --this.month;
                    if (this.month == 0) {
                        this.month = 12;
                        --this.year;
                    }
                }
                if (this.day <= this.daysForMonth(this.month, this.year)) continue;
                ++this.month;
                if (this.month == 13) {
                    this.month = 1;
                    ++this.year;
                }
                this.day -= this.daysForMonth(this.month, this.year);
            }
        }
    }

    public Date getAsDate(int timezone) throws UOMoException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        if (this.year != -1) {
            cal.set(1, this.year);
        }
        if (this.month != -1) {
            cal.set(2, this.month - 1);
        }
        if (this.day != -1) {
            cal.set(5, this.day);
        }
        if (this.hour != -1) {
            cal.set(11, this.hour);
        }
        if (this.minute != -1) {
            cal.set(12, this.minute);
        }
        if (this.second != -1) {
            cal.set(13, this.second);
        }
        if (this.milli != -1) {
            cal.set(14, this.milli);
        }
        if (timezone == 1 || timezone == 6 || timezone == 2) {
            if (timezone == 1 && this.tzNegative == null) {
                throw new UOMoException(Messages.Iso8601Date_TZ_NOT_DEFINED);
            }
            if (this.tzNegative != null) {
                TimeZone tzMsg = TimeZone.getTimeZone(String.valueOf(Messages.Iso8601Date_GMT) + this.prepTimezone());
                cal.setTimeZone(tzMsg);
            }
        }
        return cal.getTime();
    }

    public void setAsDate(Date date, int timezone) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        this.reset(timezone != 0);
        this.year = cal.get(1);
        this.month = cal.get(2) + 1;
        this.day = cal.get(5);
        this.hour = cal.get(11);
        this.minute = cal.get(12);
        this.second = cal.get(13);
        this.milli = cal.get(14);
        if (timezone == 4) {
            this.tzHour = 0;
            this.tzMinute = 0;
            this.tzNegative = null;
        } else if (timezone == 5) {
            TimeZone tzLcl = TimeZone.getDefault();
            int offset = tzLcl.getOffset(date.getTime());
            if (offset < 0) {
                this.tzNegative = new Boolean(true);
                offset = -offset;
            } else {
                this.tzNegative = new Boolean(true);
            }
            this.tzHour = offset / 3600000;
            this.tzMinute = (offset - this.tzHour * 1000 * 60 * 60) / 60000;
        }
    }

    public String render(String format, boolean checkValues, int timezone) throws UOMoException {
        String v = this.validate(false);
        if (v != null) {
            throw new UOMoException(v);
        }
        StringBuffer str = new StringBuffer();
        this.render(str, checkValues, format.length() >= 4 && Messages.Iso8601Date_yyyy.equalsIgnoreCase(format.substring(0, 4)), 4, this.year, format, Messages.Iso8601Date_year, null);
        this.render(str, checkValues, format.length() >= 6 && Messages.Iso8601Date_mm.equalsIgnoreCase(format.substring(4, 6)), 2, this.month, format, Messages.Iso8601Date_month, null);
        this.render(str, checkValues, format.length() >= 8 && Messages.Iso8601Date_dd.equalsIgnoreCase(format.substring(6, 8)), 2, this.day, format, Messages.Iso8601Date_day, null);
        this.render(str, checkValues, format.length() >= 10 && Messages.Iso8601Date_hh.equalsIgnoreCase(format.substring(8, 10)), 2, this.hour, format, Messages.Iso8601Date_hour, null);
        this.render(str, checkValues, format.length() >= 12 && Messages.Iso8601Date_nn.equalsIgnoreCase(format.substring(10, 12)), 2, this.minute, format, Messages.Iso8601Date_minute, null);
        this.render(str, checkValues, format.length() >= 14 && Messages.Iso8601Date_ss.equalsIgnoreCase(format.substring(12, 14)), 2, this.second, format, Messages.Iso8601Date_second, null);
        if (format.length() >= 18 && Messages.Iso8601Date_sss.equalsIgnoreCase(format.substring(15, 18))) {
            this.render(str, checkValues, true, 3, this.milli, format, Messages.Iso8601Date_milisecond, Messages.Iso8601Date_DOT);
        } else if (format.length() == 17 && "ss".equalsIgnoreCase(format.substring(15, 17))) {
            this.render(str, checkValues, true, 2, this.milli / 10, format, "millisecond", Messages.Iso8601Date_DOT);
        } else if (format.length() == 16 && Messages.Iso8601Date_s.equalsIgnoreCase(format.substring(15, 16))) {
            this.render(str, checkValues, true, 1, this.milli / 100, format, "millisecond", ".");
        }
        if (timezone == 1 || timezone == 6) {
            if (timezone == 1 && this.tzNegative == null) {
                throw new UOMoException(Messages.Iso8601Date_TZ_REQUIRED_BUT_NOT_DEFINED);
            }
            if (this.tzNegative != null) {
                if (this.tzNegative.booleanValue()) {
                    str.append('-');
                } else {
                    str.append('+');
                }
                this.render(str, checkValues, true, 2, this.tzHour, format, Messages.Iso8601Date_tz_hour, null);
                this.render(str, checkValues, true, 2, this.tzMinute, format, Messages.Iso8601Date_tz_minutes, null);
            }
        }
        if (timezone == 3 && this.tzNegative != null) {
            throw new UOMoException(Messages.Iso8601Date_TZ_PROHIBITED_BUT_DEFINED);
        }
        return str.toString();
    }

    private void render(StringBuffer str, boolean checkValues, boolean render, int len, int value, String format, String desc, String prefix) throws UOMoException {
        if (render) {
            if (value != -1) {
                if (prefix != null) {
                    str.append(prefix);
                }
                str.append(StringUtils.leftPad((String)Integer.toString(value), (int)len, (String)Messages.Iso8601Date_ZERO));
            } else if (checkValues) {
                throw new UOMoException(String.valueOf(Messages.Iso8601Date_NO_SUCH_VALUE_PROVIDED) + format + "' specifies " + desc + " but no such value has been provided");
            }
        }
    }

    public void parse(String value) {
        this.parse(value, ISO_DATE_VALIDATION_FULL, 2);
    }

    public String parse(String value, String format, int timezone) {
        this.reset(timezone != 0);
        String[] parts = new String[]{value};
        this.tzNegative = null;
        if (value.indexOf(43) > 0) {
            parts = StringUtils.split((String)value, (String)"+", (int)2);
            this.tzNegative = new Boolean(false);
        } else if (value.indexOf(45) > 0) {
            parts = StringUtils.split((String)value, (String)"-", (int)2);
            this.tzNegative = new Boolean(true);
        }
        String error = this.checkSections(parts[0], value, format);
        if (error != null) {
            return error;
        }
        if (parts.length > 1 && timezone != 0) {
            error = this.checkSections(parts[1], value, Messages.Iso8601Date_58);
        }
        if (error != null) {
            return error;
        }
        if (timezone == 1) {
            if (parts.length < 2) {
                return Messages.Iso8601Date_59;
            }
        } else if (timezone == 3 && parts.length > 1) {
            return Messages.Iso8601Date_60;
        }
        return null;
    }

    public static Date parseToDate(String value, String format, int timezone) throws UOMoException {
        Iso8601Date d = new Iso8601Date();
        String err = d.parse(value, format, timezone);
        if (err != null) {
            throw new UOMoException(String.valueOf(Messages.Iso8601Date_61) + value + Messages.Iso8601Date_62 + err);
        }
        return d.getAsDate(timezone);
    }

    public static String renderFromDate(Date date, String format, int timezone) throws UOMoException {
        Iso8601Date d = new Iso8601Date();
        d.setAsDate(date, timezone == 1 ? 5 : 4);
        return d.render(format, true, timezone);
    }

    private String checkSections(String content, String whole, String mask) {
        String workingMask = StringUtils.strip((String)mask, (String)Messages.Iso8601Date_63);
        String[] parts = new String[]{"", workingMask};
        boolean first = true;
        this.inFraction = false;
        do {
            String token;
            if ((token = (parts = StringUtils.splitPreserveAllTokens((String)parts[1], (String)Messages.Iso8601Date_65, (int)2))[0]) != null) {
                String section;
                String string = section = content == null || content.length() < token.length() ? null : content.substring(0, token.length());
                if (section == null) {
                    if (!first) {
                        if (content != null && content.length() < token.length()) {
                            return String.valueOf(Messages.Iso8601Date_66) + content + Messages.Iso8601Date_67 + token;
                        }
                        return String.valueOf(Messages.Iso8601Date_68) + token + Messages.Iso8601Date_69 + mask + Messages.Iso8601Date_70 + whole;
                    }
                } else {
                    if (section.length() < token.length()) {
                        return String.valueOf(Messages.Iso8601Date_71) + token + Messages.Iso8601Date_72 + mask + Messages.Iso8601Date_73 + whole + Messages.Iso8601Date_74 + section;
                    }
                    String error = this.checkSection(token, section);
                    if (error != null) {
                        return error;
                    }
                    content = section.length() >= content.length() ? null : content.substring(section.length());
                }
            }
            first = false;
        } while (parts.length > 1 && content != null);
        if (content != null) {
            return String.valueOf(Messages.Iso8601Date_75) + content + Messages.Iso8601Date_76 + whole + Messages.Iso8601Date_77 + mask;
        }
        return null;
    }

    private boolean starts(String source, String test) {
        return source == null || source.length() < test.length() ? false : source.substring(0, test.length()).equals(test);
    }

    private String checkSection(String token, String content) {
        String error = null;
        if (this.starts(token, Messages.Iso8601Date_YYYY)) {
            error = this.checkYear(content.substring(0, 4));
            if (error != null) {
                return error;
            }
            token = token.substring(4, token.length());
            content = content.substring(4, content.length());
        }
        if (this.starts(token, Messages.Iso8601Date_MM)) {
            error = this.checkMonth(content.substring(0, 2));
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, Messages.Iso8601Date_DD)) {
            error = this.checkDay(content.substring(0, 2));
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, Messages.Iso8601Date_HH)) {
            error = this.checkHour(content.substring(0, 2), false);
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, Messages.Iso8601Date_TT)) {
            error = this.checkHour(content.substring(0, 2), true);
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, Messages.Iso8601Date_NN)) {
            error = this.checkMinute(content.substring(0, 2), false);
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, Messages.Iso8601Date_tt)) {
            error = this.checkMinute(content.substring(0, 2), true);
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, Messages.Iso8601Date_SS) && !this.inFraction) {
            error = this.checkSecond(content.substring(0, 2));
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, ".") && !this.inFraction) {
            error = this.checkDot(content.substring(0, 1));
            if (error != null) {
                return error;
            }
            token = token.substring(1, token.length());
            content = content.substring(1, content.length());
        }
        while (this.starts(token, Messages.Iso8601Date_U) && this.inFraction) {
            error = this.checkFraction(content.substring(0, 1));
            if (error != null) {
                return error;
            }
            token = token.substring(1, token.length());
            content = content.substring(1, content.length());
        }
        if (token != null && !token.equals("")) {
            return String.valueOf(Messages.Iso8601Date_DATE_FRAGMENT_NOT_KNOWN) + token + " is not known";
        }
        return null;
    }

    private String checkYear(String value) {
        if (value.length() != 4) {
            return "Year Value " + value + " is not 4 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return String.valueOf(Messages.Iso8601Date_YEAR_VALUE_NOT_NUMERICAL) + value + " is not numerical";
        }
        this.year = Integer.parseInt(value);
        if (this.year <= 0) {
            return String.valueOf(Messages.Iso8601Date_YEAR_VALUE_NEGATIVE_NOT_SUPPORTED) + value + ": negative numbers are not supported";
        }
        return null;
    }

    private String checkMonth(String value) {
        if (value.length() != 2) {
            return String.valueOf(Messages.Iso8601Date_MONTH_VALUE_NOT_2_DIGITS) + value + " is not 2 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return String.valueOf(Messages.Iso8601Date_MONTH_VALUE_NOT_NUMERICAL) + value + " is not numerical";
        }
        this.month = Integer.parseInt(value);
        if (this.month <= 0 || this.month > 12) {
            return String.valueOf(Messages.Iso8601Date_MONTH_VALUE_MUST_BE_1_12) + value + ": month must be 1 - 12";
        }
        return null;
    }

    private String checkDay(String value) {
        if (value.length() != 2) {
            return String.valueOf(Messages.Iso8601Date_DAY_VALUE_NOT_2_DIGITS) + value + " is not 2 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return String.valueOf(Messages.Iso8601Date_DAY_VALUE_NOT_NUMERICAL) + value + " is not numerical";
        }
        this.day = Integer.parseInt(value);
        if (this.day <= 0) {
            return String.valueOf(Messages.Iso8601Date_DAY_VALUE_MUST_BE_POSITIVE) + value + ": Day must be >= 1";
        }
        if (this.month == 0) {
            return String.valueOf(Messages.Iso8601Date_DAY_VALUE_MONTH_MUST_BE_KNOWN) + value + ": Month must be known";
        }
        if (this.year == 0) {
            return String.valueOf(Messages.Iso8601Date_DAY_VALUE_YEAR_MUST_BE_KNOWN) + value + ": Year must be known";
        }
        if (this.day > this.daysForMonth(this.month, this.year)) {
            return String.valueOf(Messages.Iso8601Date_DAY_VALUE_ILLEGAL_FOR_MONTH) + value + ": is illegal for the month " + Integer.toString(this.month) + "-" + Integer.toString(this.year);
        }
        return null;
    }

    private int daysForMonth(int m, int y) {
        int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (m < 1 || m > 12) {
            return 30;
        }
        if (m == 2 && new GregorianCalendar().isLeapYear(y)) {
            return 29;
        }
        return daysInMonth[m - 1];
    }

    private String checkHour(String value, boolean inTimezone) {
        if (value.length() != 2) {
            return String.valueOf(Messages.Iso8601Date_HOUR_VALUE_NOT_2_DIGITS) + value + " is not 2 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return String.valueOf(Messages.Iso8601Date_HOUR_VALUE_NOT_NUMERICAL) + value + " is not numerical";
        }
        if (inTimezone) {
            this.tzHour = Integer.parseInt(value);
            if (this.tzHour < 0) {
                return String.valueOf(Messages.Iso8601Date_TZ_HOUR_VALUE_MUST_BE_0_OR_POSITIVE) + value + ": Hour must be >= 0";
            }
            if (this.tzHour > 12) {
                return String.valueOf(Messages.Iso8601Date_TZ_HOUR_VALUE_MUST_BE_12_OR_LESS) + value + ": Hour must be <= 12";
            }
        } else {
            this.hour = Integer.parseInt(value);
            if (this.hour < 0) {
                return String.valueOf(Messages.Iso8601Date_HOUR_VALUE_MUST_BE_0_OR_POSITIVE) + value + ": Hour must be >= 0";
            }
            if (inTimezone && this.hour > 12) {
                return String.valueOf(Messages.Iso8601Date_HOUR_VALUE_MUST_BE_12_OR_LESS) + value + ": Hour must be <= 12";
            }
            if (this.hour > 23) {
                return String.valueOf(Messages.Iso8601Date_TZ_HOUR_VALUE_MUST_BE_23_OR_LESS) + value + ": Hour must be <= 23";
            }
        }
        return null;
    }

    private String checkMinute(String value, boolean inTimezone) {
        if (value.length() != 2) {
            return String.valueOf(Messages.Iso8601Date_MINUTE_VALUE_NOT_2_DIGITS_LONG) + value + " is not 2 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return String.valueOf(Messages.Iso8601Date_MINUTE_VALUE_NOT_NUMERICAL) + value + " is not numerical";
        }
        if (inTimezone) {
            this.tzMinute = Integer.parseInt(value);
            if (this.tzMinute != 0 && this.tzMinute != 30) {
                return String.valueOf(Messages.Iso8601Date_TZ_MINUTE_VALUE_MUST_BE_0_OR_30) + value + ": Minute must be 0 or 30";
            }
        } else {
            this.minute = Integer.parseInt(value);
            if (this.minute < 0 || this.minute > 59) {
                return String.valueOf(Messages.Iso8601Date_MINUTE_VALUE_MUST_BE_0_AND_59) + value + ": Minute must be 0 and 59";
            }
        }
        return null;
    }

    private String checkSecond(String value) {
        if (value.length() != 2) {
            return String.valueOf(Messages.Iso8601Date_SECOND_VALUE_NOT_2_DIGITS_LONG) + value + " is not 2 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return String.valueOf(Messages.Iso8601Date_SECOND_VALUE_NOT_NUMERICAL) + value + " is not numerical";
        }
        this.second = Integer.parseInt(value);
        if (this.second < 0 || this.second > 59) {
            return NLS.bind((String)Messages.Iso8601Date_SECOND_VALUE_MUST_BE_0_AND_59, (Object)value);
        }
        return null;
    }

    private String checkDot(String value) {
        if (value.equals(".")) {
            this.inFraction = true;
            return null;
        }
        return Messages.Iso8601Date_EXPECTED_DOT;
    }

    private String checkFraction(String value) {
        if (!StringUtils.isNumeric((String)value)) {
            return String.valueOf(Messages.Iso8601Date_FRACT_VAL_NOT_NUMERICAL) + value + " is not numerical";
        }
        return null;
    }

    private String prepTimezone() {
        return String.valueOf(this.tzNegative != false ? Messages.Iso8601Date_MINUS : Messages.Iso8601Date_PLUS) + StringUtils.leftPad((String)Integer.toString(this.tzHour), (int)2, (char)'0') + StringUtils.leftPad((String)Integer.toString(this.tzMinute), (int)2, (char)'0');
    }
}

