/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units;

import java.math.BigDecimal;
import java.math.MathContext;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.IMeasure;
import org.eclipse.uomo.units.QuantityFactory;
import org.unitsofmeasurement.quantity.Dimensionless;
import org.unitsofmeasurement.quantity.Quantity;
import org.unitsofmeasurement.unit.Unit;

public abstract class AbstractQuantity<Q extends Quantity<Q>>
implements IMeasure<Q> {
    private final Unit<Q> unit;
    public static final Quantity<Dimensionless> ONE = QuantityFactory.getInstance(Dimensionless.class).create(BigDecimal.ONE, AbstractUnit.ONE);

    protected AbstractQuantity(Unit<Q> unit) {
        this.unit = unit;
    }

    public abstract Number getValue();

    public Unit<Q> getUnit() {
        return this.unit;
    }

    public Unit<Q> unit() {
        return this.getUnit();
    }

    public AbstractQuantity<Q> toSI() {
        return this.to(this.getUnit().getSystemUnit());
    }

    @Override
    public AbstractQuantity<Q> to(Unit<Q> unit) {
        if (unit.equals(this.getUnit())) {
            return this;
        }
        return AbstractQuantity.of(this.decimalValue(unit, MathContext.UNLIMITED), unit);
    }

    public AbstractQuantity<Q> to(Unit<Q> unit, MathContext ctx) {
        if (unit.equals(this.getUnit())) {
            return this;
        }
        return AbstractQuantity.of(this.decimalValue(unit, ctx), unit);
    }

    public int compareTo(Quantity<Q> that) {
        Unit<Q> unit = this.getUnit();
        return Double.compare(this.doubleValue(unit), that.value().doubleValue());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractQuantity)) {
            return false;
        }
        AbstractQuantity that = (AbstractQuantity)obj;
        return this.getUnit().equals(that.getUnit()) && this.getValue().equals(that.value());
    }

    public boolean equals(AbstractQuantity<Q> that, double epsilon, Unit<Q> epsilonUnit) {
        return Math.abs(this.doubleValue(epsilonUnit) - that.doubleValue(epsilonUnit)) <= epsilon;
    }

    public int hashCode() {
        return this.getUnit().hashCode() + this.getValue().hashCode();
    }

    public abstract boolean isBig();

    public String toString() {
        return String.valueOf(String.valueOf(this.getValue())) + " " + String.valueOf(this.getUnit());
    }

    public abstract BigDecimal decimalValue(Unit<Q> var1, MathContext var2) throws ArithmeticException;

    @Override
    public abstract double doubleValue(Unit<Q> var1) throws ArithmeticException;

    public final int intValue(Unit<Q> unit) throws ArithmeticException {
        long longValue = this.longValue(unit);
        if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
            throw new ArithmeticException("Cannot convert " + longValue + " to int (overflow)");
        }
        return (int)longValue;
    }

    @Override
    public long longValue(Unit<Q> unit) throws ArithmeticException {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    protected final float floatValue(Unit<Q> unit) {
        return (float)this.doubleValue(unit);
    }

    public final <T extends Quantity<T>> AbstractQuantity<T> asType(Class<T> type) throws ClassCastException {
        this.getUnit().asType(type);
        return this;
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(int intValue, Unit<Q> unit) {
        return new IntegerQuantity<Q>(intValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(float floatValue, Unit<Q> unit) {
        return new FloatQuantity<Q>(floatValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(double doubleValue, Unit<Q> unit) {
        return new DoubleQuantity<Q>(doubleValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(BigDecimal decimalValue, Unit<Q> unit) {
        return new DecimalQuantity<Q>(decimalValue, unit);
    }

    private static final class DecimalQuantity<T extends Quantity<T>>
    extends AbstractQuantity<T> {
        final BigDecimal value;

        public DecimalQuantity(BigDecimal value, Unit<T> unit) {
            super(unit);
            this.value = value;
        }

        public BigDecimal value() {
            return this.value;
        }

        @Override
        public double doubleValue(Unit<T> unit) {
            return unit.equals(unit) ? this.value.doubleValue() : unit.getConverterTo(unit).convert(this.value.doubleValue());
        }

        @Override
        public BigDecimal decimalValue(Unit<T> unit, MathContext ctx) throws ArithmeticException {
            return ((AbstractQuantity)this).unit.equals(unit) ? this.value : ((AbstractConverter)unit.getConverterTo(unit)).convert(this.value, ctx);
        }

        @Override
        public IMeasure<T> add(IMeasure<T> that) {
            return DecimalQuantity.of(this.value.add((BigDecimal)that.value()), this.getUnit());
        }

        @Override
        public IMeasure<T> substract(IMeasure<T> that) {
            return DecimalQuantity.of(this.value.subtract((BigDecimal)that.value()), this.getUnit());
        }

        @Override
        public AbstractQuantity<?> multiply(IMeasure<?> that) {
            return DecimalQuantity.of(this.value.multiply((BigDecimal)that.value()), this.getUnit().multiply(that.unit()));
        }

        @Override
        public IMeasure<?> multiply(Number that) {
            return DecimalQuantity.of(this.value.multiply((BigDecimal)that), this.getUnit());
        }

        @Override
        public IMeasure<?> divide(IMeasure<?> that) {
            return DecimalQuantity.of(this.value.divide((BigDecimal)that.value()), this.getUnit());
        }

        public IMeasure<?> divide(Number that) {
            return DecimalQuantity.of(this.value.divide((BigDecimal)that), this.getUnit());
        }

        @Override
        public long longValue(Unit<T> unit) {
            double result = this.doubleValue(unit);
            if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
                throw new ArithmeticException("Overflow (" + result + ")");
            }
            return (long)result;
        }

        @Override
        public boolean isBig() {
            return false;
        }

        @Override
        public Number getValue() {
            return this.value();
        }

        @Override
        public IMeasure<? extends IMeasure<T>> inverse() {
            return DecimalQuantity.of(this.value, this.getUnit().inverse());
        }
    }

    private static final class DoubleQuantity<T extends Quantity<T>>
    extends AbstractQuantity<T> {
        final double value;

        public DoubleQuantity(double value, Unit<T> unit) {
            super(unit);
            this.value = value;
        }

        public Double value() {
            return this.value;
        }

        @Override
        public double doubleValue(Unit<T> unit) {
            return ((AbstractQuantity)this).unit.equals(unit) ? this.value : ((AbstractQuantity)this).unit.getConverterTo(unit).convert(this.value);
        }

        @Override
        public BigDecimal decimalValue(Unit<T> unit, MathContext ctx) throws ArithmeticException {
            BigDecimal decimal = BigDecimal.valueOf(this.value);
            return ((AbstractQuantity)this).unit.equals(unit) ? decimal : ((AbstractConverter)((AbstractQuantity)this).unit.getConverterTo(unit)).convert(decimal, ctx);
        }

        @Override
        public long longValue(Unit<T> unit) {
            double result = this.doubleValue(unit);
            if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
                throw new ArithmeticException("Overflow (" + result + ")");
            }
            return (long)result;
        }

        @Override
        public IMeasure<T> add(IMeasure<T> that) {
            return DoubleQuantity.of(this.value + that.value().doubleValue(), this.getUnit());
        }

        @Override
        public IMeasure<T> substract(IMeasure<T> that) {
            return DoubleQuantity.of(this.value - that.value().doubleValue(), this.getUnit());
        }

        @Override
        public IMeasure<?> multiply(IMeasure<?> that) {
            return DoubleQuantity.of(this.value * that.value().doubleValue(), this.getUnit().multiply(that.unit()));
        }

        @Override
        public IMeasure<?> multiply(Number that) {
            return DoubleQuantity.of(this.value * that.doubleValue(), this.getUnit());
        }

        @Override
        public IMeasure<?> divide(IMeasure<?> that) {
            return DoubleQuantity.of(this.value / that.value().doubleValue(), this.getUnit().divide(that.unit()));
        }

        public IMeasure<?> divide(Number that) {
            return DoubleQuantity.of(this.value / that.doubleValue(), this.getUnit());
        }

        @Override
        public boolean isBig() {
            return false;
        }

        @Override
        public IMeasure<? extends IMeasure<T>> inverse() {
            return null;
        }

        @Override
        public Number getValue() {
            return this.value();
        }
    }

    private static final class FloatQuantity<T extends Quantity<T>>
    extends AbstractQuantity<T> {
        final float value;

        public FloatQuantity(float value, Unit<T> unit) {
            super(unit);
            this.value = value;
        }

        public Float value() {
            return Float.valueOf(this.value);
        }

        @Override
        public double doubleValue(Unit<T> unit) {
            return ((AbstractQuantity)this).unit.equals(unit) ? (double)this.value : ((AbstractQuantity)this).unit.getConverterTo(unit).convert((double)this.value);
        }

        @Override
        public BigDecimal decimalValue(Unit<T> unit, MathContext ctx) throws ArithmeticException {
            BigDecimal decimal = BigDecimal.valueOf(this.value);
            return ((AbstractQuantity)this).unit.equals(unit) ? decimal : ((AbstractConverter)((AbstractQuantity)this).unit.getConverterTo(unit)).convert(decimal, ctx);
        }

        @Override
        public long longValue(Unit<T> unit) {
            double result = this.doubleValue(unit);
            if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
                throw new ArithmeticException("Overflow (" + result + ")");
            }
            return (long)result;
        }

        @Override
        public AbstractQuantity<T> add(IMeasure<T> that) {
            return FloatQuantity.of(this.value + that.value().floatValue(), this.getUnit());
        }

        @Override
        public AbstractQuantity<T> substract(IMeasure<T> that) {
            return FloatQuantity.of(this.value - that.value().floatValue(), this.getUnit());
        }

        @Override
        public AbstractQuantity<T> multiply(IMeasure<?> that) {
            return FloatQuantity.of(this.value * that.value().floatValue(), this.getUnit().multiply(that.unit()));
        }

        @Override
        public IMeasure<?> multiply(Number that) {
            return FloatQuantity.of(this.value * that.floatValue(), this.getUnit().multiply(that.doubleValue()));
        }

        @Override
        public IMeasure<?> divide(IMeasure<?> that) {
            return FloatQuantity.of(this.value / that.value().floatValue(), this.getUnit().divide(that.unit()));
        }

        @Override
        public IMeasure<? extends IMeasure<T>> inverse() {
            return FloatQuantity.of(this.value, this.getUnit().inverse());
        }

        @Override
        public boolean isBig() {
            return false;
        }

        public IMeasure<?> divide(Number that) {
            return FloatQuantity.of(this.value / that.floatValue(), this.getUnit());
        }

        @Override
        public Number getValue() {
            return this.value();
        }
    }

    private static final class IntegerQuantity<T extends Quantity<T>>
    extends AbstractQuantity<T> {
        final int value;

        public IntegerQuantity(int value, Unit<T> unit) {
            super(unit);
            this.value = value;
        }

        public Integer value() {
            return this.value;
        }

        @Override
        public double doubleValue(Unit<T> unit) {
            return ((AbstractQuantity)this).unit.equals(unit) ? (double)this.value : ((AbstractQuantity)this).unit.getConverterTo(unit).convert((double)this.value);
        }

        @Override
        public BigDecimal decimalValue(Unit<T> unit, MathContext ctx) throws ArithmeticException {
            BigDecimal decimal = BigDecimal.valueOf(this.value);
            return ((AbstractQuantity)this).unit.equals(unit) ? decimal : ((AbstractConverter)((AbstractQuantity)this).unit.getConverterTo(unit)).convert(decimal, ctx);
        }

        @Override
        public long longValue(Unit<T> unit) {
            double result = this.doubleValue(unit);
            if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
                throw new ArithmeticException("Overflow (" + result + ")");
            }
            return (long)result;
        }

        @Override
        public IMeasure<T> add(IMeasure<T> that) {
            return null;
        }

        @Override
        public IntegerQuantity<T> substract(IMeasure<T> that) {
            return null;
        }

        @Override
        public IMeasure<?> multiply(IMeasure<?> that) {
            return null;
        }

        @Override
        public IMeasure<?> multiply(Number that) {
            return null;
        }

        @Override
        public IMeasure<?> divide(IMeasure<?> that) {
            return IntegerQuantity.of((double)this.value / that.value().doubleValue(), this.getUnit().divide(that.unit()));
        }

        @Override
        public boolean isBig() {
            return false;
        }

        @Override
        public Unit<T> unit() {
            return null;
        }

        @Override
        public IMeasure<? extends IMeasure<T>> inverse() {
            return null;
        }

        @Override
        public Number getValue() {
            return this.value();
        }
    }
}

