/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.uomo.core.IName;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.QuantityFactory;
import org.unitsofmeasurement.quantity.Quantity;
import org.unitsofmeasurement.unit.Dimension;
import org.unitsofmeasurement.unit.SystemOfUnits;
import org.unitsofmeasurement.unit.Unit;

public abstract class AbstractSystemOfUnits
implements SystemOfUnits,
IName {
    protected static final Set<Unit<?>> UNITS = new HashSet();

    public Set<Unit<?>> getUnits() {
        return Collections.unmodifiableSet(UNITS);
    }

    public Set<Unit<?>> getUnits(Dimension dimension) {
        return Helper.getUnitsOfDimension(UNITS, dimension);
    }

    public <T extends Quantity<T>> Unit<T> getUnit(Class<T> quantityType) {
        return QuantityFactory.getInstance(quantityType).getMetricUnit();
    }

    protected static <U extends Unit<?>> U addUnit(U unit, String name) {
        if (name != null && unit instanceof AbstractUnit) {
            AbstractUnit aUnit = (AbstractUnit)unit;
            aUnit.setName(name);
            UNITS.add(aUnit);
            return (U)((Object)aUnit);
        }
        UNITS.add(unit);
        return unit;
    }

    protected static <U extends Unit<?>> U addUnit(U unit) {
        UNITS.add(unit);
        return unit;
    }

    static class Helper {
        Helper() {
        }

        static Set<Unit<?>> getUnitsOfDimension(Set<Unit<?>> units, Dimension dimension) {
            if (dimension != null) {
                HashSet dimSet = new HashSet();
                for (Unit<?> u : units) {
                    if (!dimension.equals(u.getDimension())) continue;
                    dimSet.add(u);
                }
                return dimSet;
            }
            return null;
        }
    }
}

