/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units;

import com.ibm.icu.util.Measure;
import com.ibm.icu.util.MeasureUnit;
import java.math.BigDecimal;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.IMeasure;
import org.eclipse.uomo.units.QuantityFactory;
import org.eclipse.uomo.units.internal.MeasureAmount;
import org.unitsofmeasurement.quantity.Dimensionless;
import org.unitsofmeasurement.quantity.Quantity;
import org.unitsofmeasurement.unit.Unit;

public abstract class QuantityAmount<Q extends Quantity<Q>>
implements IMeasure<Q> {
    private final Measure measure;
    public static final Quantity<Dimensionless> ONE = QuantityFactory.getInstance(Dimensionless.class).create(BigDecimal.ONE, AbstractUnit.ONE);
    private boolean isExact;

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.measure == null ? 0 : this.measure.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuantityAmount other = (QuantityAmount)obj;
        return !(this.measure == null ? other.measure != null : !this.measure.equals((Object)other.measure));
    }

    public String toString() {
        return String.valueOf(this.measure);
    }

    protected QuantityAmount(Number number, MeasureUnit unit) {
        this.measure = MeasureAmount.of(number, unit);
    }

    public Measure getMeasure() {
        return this.measure;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return this.internalUnit().equals(unit) ? this.value().doubleValue() : this.internalUnit().getConverterTo(unit).convert(this.value().doubleValue());
    }

    @Override
    public long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    public Unit<Q> unit() {
        return this.internalUnit();
    }

    public Number value() {
        return this.getNumber();
    }

    public boolean isExact() {
        return this.isExact;
    }

    public Number getValue() {
        return this.getNumber();
    }

    public Unit<Q> getUnit() {
        return this.internalUnit();
    }

    private final AbstractUnit<Q> internalUnit() {
        return (AbstractUnit)this.measure.getUnit();
    }

    protected final Number getNumber() {
        return this.measure.getNumber();
    }
}

