/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.AbstractQuantity;
import org.eclipse.uomo.units.IMeasure;
import org.unitsofmeasurement.quantity.Quantity;
import org.unitsofmeasurement.unit.IncommensurableException;
import org.unitsofmeasurement.unit.UnconvertibleException;
import org.unitsofmeasurement.unit.Unit;
import org.unitsofmeasurement.unit.UnitConverter;

public class BaseQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q>
implements Quantity<Q>,
Comparable<BaseQuantity<Q>> {
    private final Number value;
    private final boolean isExact;
    private final boolean isBig;

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() == obj.getClass()) {
            return super.equals(obj);
        }
        if (obj instanceof Quantity) {
            Quantity m = (Quantity)obj;
            if (m.value().getClass() == this.getValue().getClass() && m.unit().getClass() == this.getUnit().getClass()) {
                return super.equals(obj);
            }
            return super.equals(obj);
        }
        return false;
    }

    protected BaseQuantity(Number number, Unit<Q> unit) {
        super(unit);
        this.value = number;
        this.isExact = false;
        this.isBig = false;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        Unit myUnit = this.getUnit();
        UnitConverter converter = unit.getConverterTo(myUnit);
        return converter.convert(this.getValue().doubleValue());
    }

    @Override
    public long longValue(Unit<Q> unit) {
        Unit myUnit = this.getUnit();
        try {
            UnitConverter converter = unit.getConverterToAny(myUnit);
            if ((this.getValue() instanceof BigDecimal || this.getValue() instanceof BigInteger) && converter instanceof AbstractConverter) {
                return ((AbstractConverter)converter).convert(BigDecimal.valueOf(this.getValue().longValue()), MathContext.DECIMAL128).longValue();
            }
            double result = this.doubleValue(unit);
            if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
                throw new ArithmeticException("Overflow (" + result + ")");
            }
            return (long)result;
        }
        catch (UnconvertibleException e) {
            throw e;
        }
        catch (IncommensurableException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    public boolean isExact() {
        return this.isExact;
    }

    @Override
    public boolean isBig() {
        return this.isBig;
    }

    @Override
    public BaseQuantity<Q> add(AbstractQuantity<Q> that) {
        IMeasure thatToUnit = that.to(this.getUnit());
        return new BaseQuantity(this.getValue().doubleValue() + ((AbstractQuantity)thatToUnit).getValue().doubleValue(), this.getUnit());
    }

    @Override
    public String toString() {
        return String.valueOf(String.valueOf(this.getValue())) + " " + String.valueOf(this.getUnit());
    }

    @Override
    public IMeasure<Q> add(IMeasure<Q> that) {
        return null;
    }

    @Override
    public IMeasure<Q> substract(IMeasure<Q> that) {
        return null;
    }

    @Override
    public IMeasure<?> multiply(IMeasure<?> that) {
        Unit unit = this.getUnit().multiply(that.unit());
        return BaseQuantity.of(this.getValue().doubleValue() * that.value().doubleValue(), unit);
    }

    @Override
    public BaseQuantity<?> multiply(Number that) {
        return (BaseQuantity)BaseQuantity.of(this.getValue().doubleValue() * that.doubleValue(), this.getUnit());
    }

    @Override
    public IMeasure<?> divide(IMeasure<?> that) {
        Unit unit = this.getUnit().divide(that.unit());
        return BaseQuantity.of(this.getValue().doubleValue() / that.value().doubleValue(), unit);
    }

    public IMeasure<?> divide(Number that) {
        if (this.value instanceof BigDecimal && that instanceof BigDecimal) {
            return BaseQuantity.of(((BigDecimal)this.value).divide((BigDecimal)that), this.getUnit());
        }
        return BaseQuantity.of(this.getValue().doubleValue() / that.doubleValue(), this.getUnit());
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit, MathContext ctx) throws ArithmeticException {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        if (this.value instanceof BigInteger) {
            return new BigDecimal((BigInteger)this.value);
        }
        return BigDecimal.valueOf(this.value.doubleValue());
    }

    @Override
    public int compareTo(BaseQuantity<Q> o) {
        return 0;
    }

    public Number value() {
        return this.getValue();
    }

    @Override
    public IMeasure<? extends IMeasure<Q>> inverse() {
        BaseQuantity<Q> m = new BaseQuantity<Q>(this.getValue(), this.getUnit().inverse());
        return m;
    }
}

