/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.SI;
import org.eclipse.uomo.units.impl.BaseUnit;
import org.unitsofmeasurement.unit.Dimension;
import org.unitsofmeasurement.unit.Unit;
import org.unitsofmeasurement.unit.UnitConverter;

public final class DimensionImpl
implements Dimension,
Serializable {
    private static final long serialVersionUID = 2377803885472362640L;
    private static Model model = Model.STANDARD;
    public static final Dimension NONE = new DimensionImpl(AbstractUnit.ONE);
    public static final Dimension LENGTH = new DimensionImpl('L');
    public static final Dimension MASS = new DimensionImpl('M');
    public static final Dimension TIME = new DimensionImpl('T');
    public static final Dimension ELECTRIC_CURRENT = new DimensionImpl('I');
    public static final Dimension TEMPERATURE = new DimensionImpl('Q');
    public static final Dimension AMOUNT_OF_SUBSTANCE = new DimensionImpl('N');
    public static final Dimension LUMINOUS_INTENSITY = new DimensionImpl('J');
    private final Unit<?> pseudoUnit;

    private DimensionImpl(char symbol) {
        this.pseudoUnit = new BaseUnit("[" + symbol + "]");
    }

    private DimensionImpl(Unit<?> pseudoUnit) {
        this.pseudoUnit = pseudoUnit;
    }

    public final Dimension multiply(Dimension that) {
        return new DimensionImpl(this.pseudoUnit.multiply(((DimensionImpl)that).pseudoUnit));
    }

    public final Dimension divide(Dimension that) {
        return new DimensionImpl(this.pseudoUnit.divide(((DimensionImpl)that).pseudoUnit));
    }

    public final Dimension pow(int n) {
        return new DimensionImpl(this.pseudoUnit.pow(n));
    }

    public final Dimension root(int n) {
        return new DimensionImpl(this.pseudoUnit.root(n));
    }

    public Map<Dimension, Integer> getProductDimensions() {
        if (this.pseudoUnit == null) {
            return null;
        }
        Map pseudoUnits = this.pseudoUnit.getProductUnits();
        HashMap<Dimension, Integer> fundamentalDimensions = new HashMap<Dimension, Integer>();
        for (Map.Entry entry : pseudoUnits.entrySet()) {
            fundamentalDimensions.put(new DimensionImpl((Unit)entry.getKey()), (Integer)entry.getValue());
        }
        return fundamentalDimensions;
    }

    public String toString() {
        return String.valueOf(this.pseudoUnit);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        return that instanceof DimensionImpl && this.pseudoUnit.equals(((DimensionImpl)that).pseudoUnit);
    }

    public int hashCode() {
        return this.pseudoUnit.hashCode();
    }

    public static void setModel(Model model) {
        DimensionImpl.model = model;
    }

    public static Model getModel() {
        return model;
    }

    public static Dimension valueOf(char symbol) {
        return new DimensionImpl(symbol);
    }

    /* synthetic */ DimensionImpl(Unit unit, DimensionImpl dimensionImpl) {
        this(unit);
    }

    public static interface Model {
        public static final Model STANDARD = new Model(){

            @Override
            public Dimension getDimension(Unit<?> unit) {
                if (unit.equals(SI.METRE)) {
                    return LENGTH;
                }
                if (unit.equals(SI.KILOGRAM)) {
                    return MASS;
                }
                if (unit.equals(SI.KELVIN)) {
                    return TEMPERATURE;
                }
                if (unit.equals(SI.SECOND)) {
                    return TIME;
                }
                if (unit.equals(SI.AMPERE)) {
                    return ELECTRIC_CURRENT;
                }
                if (unit.equals(SI.MOLE)) {
                    return AMOUNT_OF_SUBSTANCE;
                }
                if (unit.equals(SI.CANDELA)) {
                    return LUMINOUS_INTENSITY;
                }
                return new DimensionImpl(new BaseUnit("[" + unit.getSymbol() + "]"), null);
            }

            @Override
            public UnitConverter getTransform(Unit<?> unit) {
                return AbstractConverter.IDENTITY;
            }
        };

        public Dimension getDimension(Unit<?> var1);

        public UnitConverter getTransform(Unit<?> var1);
    }
}

