/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl.format;

import org.eclipse.uomo.units.impl.format.Token;
import org.eclipse.uomo.units.impl.format.TokenMgrError;

class ParseException
extends RuntimeException {
    private static final long serialVersionUID = 2932151235799168061L;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super(ParseException.initialise(currentTokenVal, expectedTokenSequencesVal, tokenImageVal));
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    private static String initialise(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage) {
        String eol = System.getProperty("line.separator", "\n");
        StringBuffer expected = new StringBuffer();
        int maxSize = 0;
        int i = 0;
        while (i < expectedTokenSequences.length) {
            if (maxSize < expectedTokenSequences[i].length) {
                maxSize = expectedTokenSequences[i].length;
            }
            int j = 0;
            while (j < expectedTokenSequences[i].length) {
                expected.append(tokenImage[expectedTokenSequences[i][j]]).append(' ');
                ++j;
            }
            if (expectedTokenSequences[i][expectedTokenSequences[i].length - 1] != 0) {
                expected.append("...");
            }
            expected.append(eol).append("    ");
            ++i;
        }
        String retval = "Encountered \"";
        Token tok = currentToken.next;
        int i2 = 0;
        while (i2 < maxSize) {
            if (i2 != 0) {
                retval = String.valueOf(retval) + " ";
            }
            if (tok.kind == 0) {
                retval = String.valueOf(retval) + tokenImage[0];
                break;
            }
            retval = String.valueOf(retval) + " " + tokenImage[tok.kind];
            retval = String.valueOf(retval) + " \"";
            retval = String.valueOf(retval) + TokenMgrError.addEscapes(tok.image);
            retval = String.valueOf(retval) + " \"";
            tok = tok.next;
            ++i2;
        }
        retval = String.valueOf(retval) + "\" at line " + currentToken.next.beginLine + ", column " + currentToken.next.beginColumn;
        retval = String.valueOf(retval) + "." + eol;
        retval = expectedTokenSequences.length == 1 ? String.valueOf(retval) + "Was expecting:" + eol + "    " : String.valueOf(retval) + "Was expecting one of:" + eol + "    ";
        retval = String.valueOf(retval) + expected.toString();
        return retval;
    }
}

