/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl.format;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.SymbolMap;
import org.eclipse.uomo.units.impl.converter.MultiplyConverter;
import org.eclipse.uomo.units.impl.converter.RationalConverter;
import org.eclipse.uomo.units.impl.format.ParsePrefix;
import org.unitsofmeasurement.unit.Unit;
import org.unitsofmeasurement.unit.UnitConverter;

class SymbolMapImpl
implements SymbolMap {
    private final Map<String, Unit<?>> symbolToUnit = new HashMap();
    private final Map<Unit<?>, String> unitToSymbol = new HashMap();
    private final Map<String, ParsePrefix> symbolToPrefix = new HashMap<String, ParsePrefix>();
    private final Map<ParsePrefix, String> prefixToSymbol = new HashMap<ParsePrefix, String>();
    private final Map<UnitConverter, ParsePrefix> converterToPrefix = new HashMap<UnitConverter, ParsePrefix>();

    public SymbolMapImpl() {
    }

    public SymbolMapImpl(ResourceBundle rb) {
        this();
        Enumeration<String> i = rb.getKeys();
        while (i.hasMoreElements()) {
            String fqn = i.nextElement();
            String symbol = rb.getString(fqn);
            boolean isAlias = false;
            int lastDot = fqn.lastIndexOf(46);
            String className = fqn.substring(0, lastDot);
            String fieldName = fqn.substring(lastDot + 1, fqn.length());
            if (Character.isDigit(fieldName.charAt(0))) {
                isAlias = true;
                fqn = className;
                lastDot = fqn.lastIndexOf(46);
                className = fqn.substring(0, lastDot);
                fieldName = fqn.substring(lastDot + 1, fqn.length());
            }
            try {
                Class<?> c = Class.forName(className);
                Field field = c.getField(fieldName);
                Object value = field.get(null);
                if (value instanceof AbstractUnit) {
                    if (isAlias) {
                        this.alias((AbstractUnit)((Object)value), symbol);
                        continue;
                    }
                    this.label((AbstractUnit)((Object)value), symbol);
                    continue;
                }
                if (value instanceof ParsePrefix) {
                    this.label((ParsePrefix)((Object)value), symbol);
                    continue;
                }
                throw new ClassCastException(value + " to Unit or Prefix");
            }
            catch (Exception e) {
                System.err.println("Error reading Unit names: " + e.toString());
            }
        }
    }

    @Override
    public Unit<?> getUnit(String symbol) {
        return this.symbolToUnit.get(symbol);
    }

    @Override
    public UnitConverter getConverter(String prefix) {
        ParsePrefix prefixObject = this.symbolToPrefix.get(prefix);
        if (prefixObject == null) {
            return null;
        }
        return prefixObject.getConverter();
    }

    void label(ParsePrefix prefix, String symbol) {
        this.symbolToPrefix.put(symbol, prefix);
        this.prefixToSymbol.put(prefix, symbol);
        this.converterToPrefix.put(prefix.getConverter(), prefix);
        if (prefix.getConverter() instanceof RationalConverter) {
            RationalConverter rc = (RationalConverter)prefix.getConverter();
            if (rc.getDividend() != null && BigInteger.ONE.equals(rc.getDivisor())) {
                this.converterToPrefix.put(new MultiplyConverter(rc.getDividend().doubleValue()), prefix);
            } else if (rc.getDivisor() != null && BigInteger.ONE.equals(rc.getDividend())) {
                this.converterToPrefix.put(new MultiplyConverter(1.0 / rc.getDivisor().doubleValue()), prefix);
            }
        }
    }

    ParsePrefix getPrefix(String symbol) {
        for (String pfSymbol : this.symbolToPrefix.keySet()) {
            if (!symbol.startsWith(pfSymbol)) continue;
            return this.symbolToPrefix.get(pfSymbol);
        }
        return null;
    }

    ParsePrefix getPrefixObject(UnitConverter converter) {
        return this.converterToPrefix.get(converter);
    }

    String getSymbol(ParsePrefix prefix) {
        return this.prefixToSymbol.get((Object)prefix);
    }

    @Override
    public void alias(Unit<?> unit, String symbol) {
        this.symbolToUnit.put(symbol, unit);
    }

    @Override
    public String getPrefix(UnitConverter converter) {
        ParsePrefix prefix = this.getPrefixObject(converter);
        if (prefix == null) {
            return null;
        }
        return this.prefixToSymbol.get((Object)prefix);
    }

    @Override
    public String getSymbol(Unit<?> unit) {
        return this.unitToSymbol.get(unit);
    }

    @Override
    public void label(Unit<?> unit, String symbol) {
        this.symbolToUnit.put(symbol, unit);
        this.unitToSymbol.put(unit, symbol);
    }

    @Override
    public void prefix(UnitConverter cvtr, String prefix) {
        throw new UnsupportedOperationException("Prefixes are not modifiable");
    }
}

