/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.ui.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.StorageService;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.spi.Credentials;
import org.eclipse.userstorage.ui.AbstractDialog;
import org.eclipse.userstorage.ui.internal.Activator;
import org.eclipse.userstorage.ui.internal.CredentialsComposite;

public class CredentialsDialog
extends AbstractDialog {
    private final IStorageService service;
    private final boolean reauthentication;
    private Credentials credentials;
    private CredentialsComposite credentialsComposite;
    private Button okButton;

    public CredentialsDialog(Shell parentShell, IStorageService service, boolean reauthentication) {
        super(parentShell);
        this.service = service;
        this.reauthentication = reauthentication;
    }

    public final IStorageService getService() {
        return this.service;
    }

    public final Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    protected IDialogSettings getPluginSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String shellText = "User Storage Service";
        String authority = this.service.getServiceURI().getAuthority();
        if (authority != null && authority.endsWith(".eclipse.org")) {
            shellText = "Eclipse " + shellText;
        }
        newShell.setText(shellText);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.setTitle("Login");
        if (this.reauthentication) {
            this.setErrorMessage("You could not be logged in to your " + this.service.getServiceLabel() + " account. Please try again.");
        } else {
            this.setMessage("Enter the login information for your " + this.service.getServiceLabel() + " account.");
        }
        this.initializeDialogUnits((Control)parent);
        Composite area = (Composite)super.createDialogArea(parent);
        this.credentialsComposite = new CredentialsComposite(area, 0, 10, 10, true){

            @Override
            protected void validate() {
                CredentialsDialog.this.validatePage();
            }
        };
        this.credentialsComposite.setLayoutData(new GridData(4, 4, true, true));
        this.credentialsComposite.setService(this.service);
        Dialog.applyDialogFont((Control)this.credentialsComposite);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.okButton = this.getButton(0);
        this.validatePage();
    }

    protected void okPressed() {
        ((StorageService)this.service).setTermsOfUseAgreed(this.credentialsComposite.isTermsOfUseAgreed());
        this.credentials = this.credentialsComposite.getCredentials();
        super.okPressed();
    }

    protected boolean isPageValid() {
        boolean termsOfUseAgreed;
        String termsOfUseLink = this.service.getTermsOfUseLink();
        if (!StringUtil.isEmpty((String)termsOfUseLink) && !(termsOfUseAgreed = this.credentialsComposite.isTermsOfUseAgreed())) {
            return false;
        }
        Credentials credentials = this.credentialsComposite.getCredentials();
        if (credentials == null) {
            return false;
        }
        if (StringUtil.isEmpty((String)credentials.getUsername())) {
            return false;
        }
        return !StringUtil.isEmpty((String)credentials.getPassword());
    }

    private void validatePage() {
        if (this.okButton != null) {
            boolean valid = this.credentialsComposite.isValid();
            this.okButton.setEnabled(valid);
        }
    }
}

