/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.tests.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.eclipse.core.runtime.Path;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.eclipse.userstorage.internal.util.JSONUtil;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.spi.Credentials;
import org.eclipse.userstorage.tests.util.FixedCredentialsProvider;

public final class USSServer {
    public static final String BLOB_EXTENSION = ".blob";
    public static final String ETAG_EXTENSION = ".etag";
    private static final boolean DEBUG = Boolean.getBoolean("org.eclipse.userstorage.tests.server.debug");
    private final USSHandler handler = new USSHandler();
    private final Set<String> applicationTokens = new HashSet<String>();
    private final Map<String, User> users = new HashMap<String, User>();
    private final Map<String, Session> sessions = new HashMap<String, Session>();
    private final File folder;
    private final int startPort;
    private int port;
    private Server server;

    public USSServer(int startPort, File folder) {
        this.startPort = startPort;
        this.folder = folder;
    }

    public int getPort() {
        return this.port;
    }

    public File getFolder() {
        return this.folder;
    }

    public Set<String> getApplicationTokens() {
        return this.applicationTokens;
    }

    public Map<String, User> getUsers() {
        return this.users;
    }

    public User addUser(Credentials credentials) {
        return this.addUser(credentials.getUsername(), credentials.getPassword());
    }

    public User addUser(String username, String password) {
        User user = new User(username, password);
        this.users.put(user.getUsername(), user);
        return user;
    }

    public File getUserFile(User user, String applicationToken, String key, String extension) {
        return new File(this.getApplicationFolder(user, applicationToken), String.valueOf(key) + StringUtil.safe((String)extension));
    }

    public File getApplicationFolder(User user, String applicationToken) {
        return new File(new File(this.folder, user.getUsername()), applicationToken);
    }

    public Map<String, Session> getSessions() {
        return this.sessions;
    }

    public int start() throws Exception {
        Exception exception = new Exception("No free port");
        this.port = this.startPort;
        while (this.port < 65535) {
            this.server = new Server(this.port);
            this.server.setHandler((Handler)this.handler);
            try {
                this.server.start();
                return this.port;
            }
            catch (Exception ex) {
                block8: {
                    exception = ex;
                    try {
                        try {
                            this.server.stop();
                        }
                        catch (Exception exception2) {
                            this.server = null;
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        this.server = null;
                        throw throwable;
                    }
                    this.server = null;
                }
                ++this.port;
            }
        }
        throw exception;
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    public void join() throws InterruptedException {
        if (this.server != null) {
            this.server.join();
        }
    }

    protected void login(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map requestObject = (Map)JSONUtil.parse((InputStream)request.getInputStream(), null);
        String username = (String)requestObject.get("username");
        String password = (String)requestObject.get("password");
        User user = this.users.get(username);
        if (user == null || password == null || !password.equals(user.getPassword())) {
            response.sendError(401);
            return;
        }
        response.setStatus(200);
        response.setContentType("application/json");
        Session session = this.addSession(user);
        Cookie cookie = new Cookie("SESSION", session.getID());
        cookie.setPath("/");
        response.addCookie(cookie);
        LinkedHashMap<String, String> responseObject = new LinkedHashMap<String, String>();
        responseObject.put("sessid", session.getID());
        responseObject.put("token", session.getCSRFToken());
        InputStream body = JSONUtil.build(responseObject);
        try {
            ServletOutputStream out = response.getOutputStream();
            IOUtil.copy((InputStream)body, (OutputStream)out);
            out.flush();
        }
        finally {
            IOUtil.closeSilent((Closeable)body);
        }
    }

    protected void retrieveProperties(HttpServletRequest request, HttpServletResponse response, File applicationFolder) throws IOException {
        String applicationToken = applicationFolder.getName();
        int pageSize = USSServer.getIntParameter(request, "pageSize", 20);
        if (pageSize < 1 || pageSize > 100) {
            response.sendError(400, "Invalid page size");
            return;
        }
        int page = USSServer.getIntParameter(request, "page", 20);
        if (page < 1) {
            response.sendError(400, "Invalid page");
            return;
        }
        boolean empty = true;
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        File[] files = applicationFolder.listFiles();
        if (files != null) {
            int first = (page - 1) * pageSize + 1;
            System.out.println("##### " + first);
            int i = 0;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String name = file.getName();
                if (name.endsWith(ETAG_EXTENSION) && ++i >= first) {
                    String key = name.substring(0, name.length() - ETAG_EXTENSION.length());
                    System.out.println("##### " + key);
                    String etag = IOUtil.readUTF((File)file);
                    if (empty) {
                        empty = false;
                    } else {
                        builder.append(",");
                    }
                    builder.append("{\"application_token\":\"");
                    builder.append(applicationToken);
                    builder.append("\",\"key\":\"");
                    builder.append(key);
                    builder.append("\",\"etag\":\"");
                    builder.append(etag);
                    builder.append("\"}");
                    if (--pageSize == 0) break;
                }
                ++n2;
            }
        }
        builder.append(']');
        System.out.println(builder);
        response.setStatus(200);
        response.setContentType("application/json");
        InputStream body = IOUtil.streamUTF((String)builder.toString());
        try {
            ServletOutputStream out = response.getOutputStream();
            IOUtil.copy((InputStream)body, (OutputStream)out);
            out.flush();
        }
        finally {
            IOUtil.closeSilent((Closeable)body);
        }
    }

    protected void retrieveBlob(HttpServletRequest request, HttpServletResponse response, File blobFile, File etagFile, boolean exists) throws IOException {
        if (!exists) {
            response.sendError(404);
            return;
        }
        String etag = IOUtil.readUTF((File)etagFile);
        String ifNoneMatch = USSServer.getETag(request, "If-None-Match");
        if (ifNoneMatch != null && ifNoneMatch.equals(etag)) {
            response.setStatus(304);
            return;
        }
        response.setStatus(200);
        response.setContentType("application/json");
        response.setHeader("ETag", "\"" + etag + "\"");
        InputStream body = JSONUtil.build(Collections.singletonMap("value", new FileInputStream(blobFile)));
        try {
            ServletOutputStream out = response.getOutputStream();
            IOUtil.copy((InputStream)body, (OutputStream)out);
            out.flush();
        }
        finally {
            IOUtil.closeSilent((Closeable)body);
        }
    }

    protected void updateBlob(HttpServletRequest request, HttpServletResponse response, File blobFile, File etagFile, boolean exists) throws IOException {
        String etag;
        String ifMatch = USSServer.getETag(request, "If-Match");
        if (exists) {
            etag = IOUtil.readUTF((File)etagFile);
            if (StringUtil.isEmpty((String)ifMatch) || !ifMatch.equals(etag)) {
                response.setHeader("ETag", "\"" + etag + "\"");
                response.sendError(409);
                return;
            }
        }
        etag = UUID.randomUUID().toString();
        IOUtil.mkdirs((File)blobFile.getParentFile());
        FileOutputStream out = new FileOutputStream(blobFile);
        InputStream body = null;
        try {
            Map requestObject = (Map)JSONUtil.parse((InputStream)request.getInputStream(), (String)"value");
            body = (InputStream)requestObject.get("value");
            IOUtil.copy((InputStream)body, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(body);
            IOUtil.close((Closeable)out);
            throw throwable;
        }
        IOUtil.closeSilent((Closeable)body);
        IOUtil.close((Closeable)out);
        IOUtil.writeUTF((File)etagFile, (String)etag);
        response.setStatus(exists ? 200 : 201);
        response.setHeader("ETag", "\"" + etag + "\"");
    }

    protected void deleteBlob(HttpServletRequest request, HttpServletResponse response, File blobFile, File etagFile, boolean exists) throws IOException {
        if (exists) {
            String etag = IOUtil.readUTF((File)etagFile);
            String ifMatch = USSServer.getETag(request, "If-Match");
            if (ifMatch != null && !ifMatch.equals(etag)) {
                response.sendError(409);
                return;
            }
        } else {
            response.sendError(404);
            return;
        }
        IOUtil.delete((File)blobFile);
        IOUtil.delete((File)etagFile);
        response.setStatus(204);
    }

    private Session getSession(HttpServletRequest request) {
        Cookie[] cookies;
        String csrfToken = request.getHeader("X-CSRF-Token");
        if (csrfToken != null && (cookies = request.getCookies()) != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if ("SESSION".equals(cookie.getName())) {
                    String sessionID = cookie.getValue();
                    Session session = this.sessions.get(sessionID);
                    if (session == null || !session.getCSRFToken().equals(csrfToken)) break;
                    return session;
                }
                ++n2;
            }
        }
        return null;
    }

    private Session addSession(User user) {
        Session session = new Session(user);
        this.sessions.put(session.getID(), session);
        return session;
    }

    private static String getETag(HttpServletRequest request, String headerName) {
        String eTag = request.getHeader(headerName);
        if (eTag != null) {
            eTag = eTag.substring(1, eTag.length() - 1);
        }
        return eTag;
    }

    private static String getReasonPhrase(int status) {
        try {
            return EnglishReasonPhraseCatalog.INSTANCE.getReason(status, null);
        }
        catch (Throwable ex) {
            return "";
        }
    }

    private static int getIntParameter(HttpServletRequest request, String name, int defaultValue) {
        String parameter = request.getParameter(name);
        if (parameter != null) {
            try {
                return Integer.parseInt(parameter);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static void main(String[] args) throws Exception {
        Log.setLog((Logger)new NOOPLogger());
        USSServer server = new USSServer(8080, new File(System.getProperty("java.io.tmpdir"), "uss-server"));
        server.addUser(FixedCredentialsProvider.DEFAULT_CREDENTIALS);
        Set<String> applicationTokens = server.getApplicationTokens();
        applicationTokens.add("pDKTqBfDuNxlAKydhEwxBZPxa4q");
        applicationTokens.add("cNhDr0INs8T109P8h6E1r_GvU3I");
        System.out.println(server.getFolder());
        System.out.println("Listening on port " + server.start());
        server.join();
    }

    public static class NOOPLogger
    implements Logger {
        public String getName() {
            return "noop";
        }

        public void warn(String msg, Object ... args) {
        }

        public void warn(Throwable thrown) {
        }

        public void warn(String msg, Throwable thrown) {
        }

        public void info(String msg, Object ... args) {
        }

        public void info(Throwable thrown) {
        }

        public void info(String msg, Throwable thrown) {
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public void setDebugEnabled(boolean enabled) {
        }

        public void debug(String msg, Object ... args) {
        }

        public void debug(Throwable thrown) {
        }

        public void debug(String msg, Throwable thrown) {
        }

        public void debug(String msg, long value) {
        }

        public Logger getLogger(String name) {
            return this;
        }

        public void ignore(Throwable ignored) {
        }
    }

    public static final class Session {
        private final String id = UUID.randomUUID().toString();
        private final String csrfToken = UUID.randomUUID().toString();
        private final User user;

        public Session(User user) {
            this.user = user;
        }

        public String getID() {
            return this.id;
        }

        public String getCSRFToken() {
            return this.csrfToken;
        }

        public User getUser() {
            return this.user;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Session other = (Session)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        public String toString() {
            return String.valueOf(this.id) + " -> " + this.user;
        }
    }

    private class USSHandler
    extends AbstractHandler {
        private USSHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            try {
                baseRequest.setHandled(true);
                String userAgent = request.getHeader("User-Agent");
                if (!"uss/1.0.0".equals(userAgent)) {
                    response.sendError(403, "Invalid User-Agent");
                    return;
                }
                String method = request.getMethod();
                String path = request.getPathInfo();
                if (DEBUG) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(method);
                    builder.append(" ");
                    builder.append(path);
                    builder.append('\n');
                    Enumeration headerNames = request.getHeaderNames();
                    while (headerNames.hasMoreElements()) {
                        String headerName = (String)headerNames.nextElement();
                        Enumeration headers = request.getHeaders(headerName);
                        while (headers.hasMoreElements()) {
                            String header = (String)headers.nextElement();
                            builder.append("   ");
                            builder.append(headerName);
                            builder.append(": ");
                            builder.append(header);
                            builder.append('\n');
                        }
                    }
                    System.out.print(builder);
                    System.out.flush();
                }
                if (path != null && method != null) {
                    this.handle(method, path, request, response);
                    if (DEBUG) {
                        int status = response.getStatus();
                        String reasonPhrase = USSServer.getReasonPhrase(status);
                        StringBuilder builder = new StringBuilder();
                        builder.append(request.getProtocol());
                        builder.append(" ");
                        builder.append(status);
                        if (!StringUtil.isEmpty((String)reasonPhrase)) {
                            builder.append(" ");
                            builder.append(reasonPhrase);
                        }
                        builder.append('\n');
                        for (String headerName : response.getHeaderNames()) {
                            for (String header : response.getHeaders(headerName)) {
                                builder.append("   ");
                                builder.append(headerName);
                                builder.append(": ");
                                builder.append(header);
                                builder.append('\n');
                            }
                        }
                        System.out.println(builder);
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                throw ex;
            }
        }

        private void handle(String method, String path, HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (path.equals("/api/user/login") && HttpMethod.POST.is(method)) {
                USSServer.this.login(request, response);
                return;
            }
            Session session = USSServer.this.getSession(request);
            if (session == null) {
                response.sendError(401);
                return;
            }
            if (path.startsWith("/api/blob")) {
                User user = session.getUser();
                Path segments = new Path(path);
                String applicationToken = segments.segment(2);
                if (!USSServer.this.applicationTokens.contains(applicationToken)) {
                    response.sendError(404);
                    return;
                }
                if (segments.segmentCount() < 4) {
                    if (HttpMethod.GET.is(method)) {
                        File applicationFolder = USSServer.this.getApplicationFolder(user, applicationToken);
                        USSServer.this.retrieveProperties(request, response, applicationFolder);
                        return;
                    }
                    response.sendError(403);
                    return;
                }
                String key = segments.segment(3);
                File blobFile = USSServer.this.getUserFile(user, applicationToken, key, USSServer.BLOB_EXTENSION);
                File etagFile = USSServer.this.getUserFile(user, applicationToken, key, USSServer.ETAG_EXTENSION);
                boolean exists = etagFile.exists();
                if (HttpMethod.GET.is(method)) {
                    USSServer.this.retrieveBlob(request, response, blobFile, etagFile, exists);
                    return;
                }
                if (HttpMethod.PUT.is(method)) {
                    USSServer.this.updateBlob(request, response, blobFile, etagFile, exists);
                    return;
                }
                if (HttpMethod.DELETE.is(method)) {
                    USSServer.this.deleteBlob(request, response, blobFile, etagFile, exists);
                    return;
                }
                return;
            }
            response.sendError(403);
        }
    }

    public static final class User {
        private final String username;
        private final byte[] password;

        public User(String username, String password) {
            this.username = username;
            this.password = StringUtil.encrypt((String)password);
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return StringUtil.decrypt((byte[])this.password);
        }

        public String toString() {
            return this.username;
        }

        public int hashCode() {
            return this.username.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            User other = (User)obj;
            return !(this.username == null ? other.username != null : !this.username.equals(other.username));
        }
    }
}

