/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.fluent.Executor;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.userstorage.internal.Activator;

public final class ProxyUtil {
    private static final IProxyService PROXY_MANAGER = ProxyUtil.getProxyManager();
    private static final String PROP_HTTP_AUTH_NTLM_DOMAIN = "http.auth.ntlm.domain";
    private static final String ENV_USER_DOMAIN = "USERDOMAIN";
    private static final String DOUBLE_BACKSLASH = "\\\\";

    private ProxyUtil() {
    }

    public static HttpHost getProxyHost(URI uri) {
        IProxyData proxy = ProxyUtil.getProxyData(uri);
        if (proxy != null) {
            return new HttpHost(proxy.getHost(), proxy.getPort());
        }
        return null;
    }

    public static Executor proxyAuthentication(Executor executor, URI uri) throws IOException {
        IProxyData proxy = ProxyUtil.getProxyData(uri);
        if (proxy != null) {
            HttpHost proxyHost = new HttpHost(proxy.getHost(), proxy.getPort());
            String proxyUserID = proxy.getUserId();
            if (proxyUserID != null) {
                String userID = ProxyUtil.getUserName(proxyUserID);
                String password = proxy.getPassword();
                String workstation = ProxyUtil.getWorkstation();
                String domain = ProxyUtil.getUserDomain(proxyUserID);
                return executor.auth(new AuthScope(proxyHost, AuthScope.ANY_REALM, "ntlm"), (Credentials)new NTCredentials(userID, password, workstation, domain)).auth(new AuthScope(proxyHost, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(userID, password));
            }
        }
        return executor;
    }

    private static String getWorkstation() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private static String getUserDomain(String userName) {
        int pos;
        String domain = System.getProperty(PROP_HTTP_AUTH_NTLM_DOMAIN);
        if (domain != null) {
            return domain;
        }
        domain = System.getenv(ENV_USER_DOMAIN);
        if (domain != null) {
            return domain;
        }
        if (userName != null && (pos = userName.indexOf(DOUBLE_BACKSLASH)) != -1) {
            return userName.substring(0, pos);
        }
        return null;
    }

    private static String getUserName(String userName) {
        int pos;
        if (userName != null && (pos = userName.indexOf(DOUBLE_BACKSLASH)) != -1) {
            return userName.substring(pos + DOUBLE_BACKSLASH.length());
        }
        return userName;
    }

    private static IProxyData getProxyData(URI uri) {
        IProxyData[] proxies;
        if (PROXY_MANAGER != null && (proxies = PROXY_MANAGER.select(uri)).length != 0) {
            return proxies[0];
        }
        return null;
    }

    private static IProxyService getProxyManager() {
        try {
            if (Activator.PLATFORM_RUNNING) {
                return ProxyManager.getProxyManager();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

